#ifndef CUFFTDX_FFT_2048_FP32_FWD_PTX_HPP
#define CUFFTDX_FFT_2048_FP32_FWD_PTX_HPP



template<> __forceinline__ __device__ void cufftdx_private_function<91, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<891>;
.reg .b32 r<22>;
.reg .b64 rd<9>;
mov.u32 r1, %tid.y;
shl.b32 r2, r1, 13;
mov.u32 r3, %32;
add.s32 r4, r3, r2;
mov.u32 r5, %tid.x;
add.f32 f65, %35, %56;
add.f32 f66, %36, %58;
sub.f32 f67, %35, %56;
sub.f32 f68, %36, %58;
add.f32 f69, %45, %67;
add.f32 f70, %47, %68;
sub.f32 f71, %45, %67;
sub.f32 f72, %47, %68;
add.f32 f73, f65, f69;
add.f32 f74, f66, f70;
sub.f32 f75, f65, f69;
sub.f32 f76, f66, f70;
add.f32 f77, f67, f72;
sub.f32 f78, f68, f71;
sub.f32 f79, f67, f72;
add.f32 f80, f68, f71;
add.f32 f81, %40, %61;
add.f32 f82, %42, %63;
sub.f32 f83, %40, %61;
sub.f32 f84, %42, %63;
add.f32 f85, %51, %72;
add.f32 f86, %52, %74;
sub.f32 f87, %51, %72;
sub.f32 f88, %52, %74;
add.f32 f89, f81, f85;
add.f32 f90, f82, f86;
sub.f32 f91, f81, f85;
sub.f32 f92, f82, f86;
add.f32 f93, f83, f88;
sub.f32 f94, f84, f87;
sub.f32 f95, f83, f88;
add.f32 f96, f84, f87;
mul.f32 f97, f93, 0f3F3504F3;
mul.f32 f98, f94, 0fBF3504F3;
sub.f32 f99, f97, f98;
mul.f32 f100, f94, 0f3F3504F3;
fma.rn.f32 f101, f93, 0fBF3504F3, f100;
mul.f32 f102, f95, 0fBF3504F3;
mul.f32 f103, f96, 0fBF3504F3;
sub.f32 f104, f102, f103;
add.f32 f105, f102, f103;
add.f32 f106, f73, f89;
add.f32 f107, f74, f90;
sub.f32 f108, f73, f89;
sub.f32 f109, f74, f90;
add.f32 f110, f77, f99;
add.f32 f111, f78, f101;
sub.f32 f112, f77, f99;
sub.f32 f113, f78, f101;
add.f32 f114, f75, f92;
sub.f32 f115, f76, f91;
sub.f32 f116, f75, f92;
add.f32 f117, f76, f91;
add.f32 f118, f79, f104;
add.f32 f119, f80, f105;
sub.f32 f120, f79, f104;
sub.f32 f121, f80, f105;
add.f32 f122, %37, %59;
add.f32 f123, %39, %60;
sub.f32 f124, %37, %59;
sub.f32 f125, %39, %60;
add.f32 f126, %48, %69;
add.f32 f127, %50, %71;
sub.f32 f128, %48, %69;
sub.f32 f129, %50, %71;
add.f32 f130, f122, f126;
add.f32 f131, f123, f127;
sub.f32 f132, f122, f126;
sub.f32 f133, f123, f127;
add.f32 f134, f124, f129;
sub.f32 f135, f125, f128;
sub.f32 f136, f124, f129;
add.f32 f137, f125, f128;
add.f32 f138, %43, %64;
add.f32 f139, %44, %66;
sub.f32 f140, %43, %64;
sub.f32 f141, %44, %66;
add.f32 f142, %53, %75;
add.f32 f143, %55, %76;
sub.f32 f144, %53, %75;
sub.f32 f145, %55, %76;
add.f32 f146, f138, f142;
add.f32 f147, f139, f143;
sub.f32 f148, f138, f142;
sub.f32 f149, f139, f143;
add.f32 f150, f140, f145;
sub.f32 f151, f141, f144;
sub.f32 f152, f140, f145;
add.f32 f153, f141, f144;
mul.f32 f154, f150, 0f3F3504F3;
mul.f32 f155, f151, 0fBF3504F3;
sub.f32 f156, f154, f155;
mul.f32 f157, f151, 0f3F3504F3;
fma.rn.f32 f158, f150, 0fBF3504F3, f157;
mul.f32 f159, f152, 0fBF3504F3;
mul.f32 f160, f153, 0fBF3504F3;
sub.f32 f161, f159, f160;
add.f32 f162, f159, f160;
add.f32 f163, f130, f146;
add.f32 f164, f131, f147;
sub.f32 f165, f130, f146;
sub.f32 f166, f131, f147;
add.f32 f167, f134, f156;
add.f32 f168, f135, f158;
sub.f32 f169, f134, f156;
sub.f32 f170, f135, f158;
add.f32 f171, f132, f149;
sub.f32 f172, f133, f148;
sub.f32 f173, f132, f149;
add.f32 f174, f133, f148;
add.f32 f175, f136, f161;
add.f32 f176, f137, f162;
sub.f32 f177, f136, f161;
sub.f32 f178, f137, f162;
mul.f32 f179, f167, 0f3F6C835E;
mul.f32 f180, f168, 0fBEC3EF15;
sub.f32 f181, f179, f180;
mul.f32 f182, f168, 0f3F6C835E;
fma.rn.f32 f183, f167, 0fBEC3EF15, f182;
mul.f32 f184, f171, 0f3F3504F3;
mul.f32 f185, f172, 0fBF3504F3;
sub.f32 f186, f184, f185;
mul.f32 f187, f172, 0f3F3504F3;
fma.rn.f32 f188, f171, 0fBF3504F3, f187;
mul.f32 f189, f175, 0f3EC3EF15;
mul.f32 f190, f176, 0fBF6C835E;
sub.f32 f191, f189, f190;
mul.f32 f192, f176, 0f3EC3EF15;
fma.rn.f32 f193, f175, 0fBF6C835E, f192;
mul.f32 f194, f169, 0fBEC3EF15;
mul.f32 f195, f170, 0fBF6C835E;
sub.f32 f196, f194, f195;
mul.f32 f197, f170, 0fBEC3EF15;
fma.rn.f32 f198, f169, 0fBF6C835E, f197;
mul.f32 f199, f173, 0fBF3504F3;
mul.f32 f200, f174, 0fBF3504F3;
sub.f32 f201, f199, f200;
add.f32 f202, f199, f200;
mul.f32 f203, f177, 0fBF6C835E;
mul.f32 f204, f178, 0fBEC3EF15;
sub.f32 f205, f203, f204;
mul.f32 f206, f178, 0fBF6C835E;
fma.rn.f32 f207, f177, 0fBEC3EF15, f206;
add.f32 f208, f106, f163;
add.f32 f209, f107, f164;
sub.f32 f210, f106, f163;
sub.f32 f211, f107, f164;
add.f32 f212, f110, f181;
add.f32 f213, f111, f183;
sub.f32 f214, f110, f181;
sub.f32 f215, f111, f183;
add.f32 f216, f114, f186;
add.f32 f217, f115, f188;
sub.f32 f218, f114, f186;
sub.f32 f219, f115, f188;
add.f32 f220, f118, f191;
add.f32 f221, f119, f193;
sub.f32 f222, f118, f191;
sub.f32 f223, f119, f193;
add.f32 f224, f108, f166;
sub.f32 f225, f109, f165;
sub.f32 f226, f108, f166;
add.f32 f227, f109, f165;
add.f32 f228, f112, f196;
add.f32 f229, f113, f198;
sub.f32 f230, f112, f196;
sub.f32 f231, f113, f198;
add.f32 f232, f116, f201;
add.f32 f233, f117, f202;
sub.f32 f234, f116, f201;
sub.f32 f235, f117, f202;
add.f32 f236, f120, f205;
add.f32 f237, f121, f207;
sub.f32 f238, f120, f205;
sub.f32 f239, f121, f207;
and.b32 r6, r5, 127;
shl.b32 r7, r5, 3;
cvt.u64.u32 rd2, r7;
and.b64 rd3, rd2, 1016;
mov.u64 rd4, %33;
add.s64 rd5, rd4, rd3;
ld.global.v2.f32 {f240, f241}, [rd5];
mul.f32 f244, f240, f212;
mul.f32 f245, f241, f213;
sub.f32 f246, f244, f245;
mul.f32 f247, f240, f213;
fma.rn.f32 f248, f241, f212, f247;
mul.f32 f249, f240, f240;
mul.f32 f250, f241, f241;
sub.f32 f251, f249, f250;
mul.f32 f252, f241, f240;
fma.rn.f32 f253, f241, f240, f252;
mul.f32 f254, f251, f216;
mul.f32 f255, f253, f217;
sub.f32 f256, f254, f255;
mul.f32 f257, f251, f217;
fma.rn.f32 f258, f253, f216, f257;
mul.f32 f259, f240, f251;
mul.f32 f260, f241, f253;
sub.f32 f261, f259, f260;
mul.f32 f262, f240, f253;
fma.rn.f32 f263, f241, f251, f262;
mul.f32 f264, f261, f220;
mul.f32 f265, f263, f221;
sub.f32 f266, f264, f265;
mul.f32 f267, f261, f221;
fma.rn.f32 f268, f263, f220, f267;
mul.f32 f269, f240, f261;
mul.f32 f270, f241, f263;
sub.f32 f271, f269, f270;
mul.f32 f272, f240, f263;
fma.rn.f32 f273, f241, f261, f272;
mul.f32 f274, f271, f224;
mul.f32 f275, f273, f225;
sub.f32 f276, f274, f275;
mul.f32 f277, f271, f225;
fma.rn.f32 f278, f273, f224, f277;
mul.f32 f279, f240, f271;
mul.f32 f280, f241, f273;
sub.f32 f281, f279, f280;
mul.f32 f282, f240, f273;
fma.rn.f32 f283, f241, f271, f282;
mul.f32 f284, f281, f228;
mul.f32 f285, f283, f229;
sub.f32 f286, f284, f285;
mul.f32 f287, f281, f229;
fma.rn.f32 f288, f283, f228, f287;
mul.f32 f289, f240, f281;
mul.f32 f290, f241, f283;
sub.f32 f291, f289, f290;
mul.f32 f292, f240, f283;
fma.rn.f32 f293, f241, f281, f292;
mul.f32 f294, f291, f232;
mul.f32 f295, f293, f233;
sub.f32 f296, f294, f295;
mul.f32 f297, f291, f233;
fma.rn.f32 f298, f293, f232, f297;
mul.f32 f299, f240, f291;
mul.f32 f300, f241, f293;
sub.f32 f301, f299, f300;
mul.f32 f302, f240, f293;
fma.rn.f32 f303, f241, f291, f302;
mul.f32 f304, f301, f236;
mul.f32 f305, f303, f237;
sub.f32 f306, f304, f305;
mul.f32 f307, f301, f237;
fma.rn.f32 f308, f303, f236, f307;
mul.f32 f309, f240, f301;
mul.f32 f310, f241, f303;
sub.f32 f311, f309, f310;
mul.f32 f312, f240, f303;
fma.rn.f32 f313, f241, f301, f312;
mul.f32 f314, f311, f210;
mul.f32 f315, f313, f211;
sub.f32 f316, f314, f315;
mul.f32 f317, f311, f211;
fma.rn.f32 f318, f313, f210, f317;
mul.f32 f319, f240, f311;
mul.f32 f320, f241, f313;
sub.f32 f321, f319, f320;
mul.f32 f322, f240, f313;
fma.rn.f32 f323, f241, f311, f322;
mul.f32 f324, f321, f214;
mul.f32 f325, f323, f215;
sub.f32 f326, f324, f325;
mul.f32 f327, f321, f215;
fma.rn.f32 f328, f323, f214, f327;
mul.f32 f329, f240, f321;
mul.f32 f330, f241, f323;
sub.f32 f331, f329, f330;
mul.f32 f332, f240, f323;
fma.rn.f32 f333, f241, f321, f332;
mul.f32 f334, f331, f218;
mul.f32 f335, f333, f219;
sub.f32 f336, f334, f335;
mul.f32 f337, f331, f219;
fma.rn.f32 f338, f333, f218, f337;
mul.f32 f339, f240, f331;
mul.f32 f340, f241, f333;
sub.f32 f341, f339, f340;
mul.f32 f342, f240, f333;
fma.rn.f32 f343, f241, f331, f342;
mul.f32 f344, f341, f222;
mul.f32 f345, f343, f223;
sub.f32 f346, f344, f345;
mul.f32 f347, f341, f223;
fma.rn.f32 f348, f343, f222, f347;
mul.f32 f349, f240, f341;
mul.f32 f350, f241, f343;
sub.f32 f351, f349, f350;
mul.f32 f352, f240, f343;
fma.rn.f32 f353, f241, f341, f352;
mul.f32 f354, f351, f226;
mul.f32 f355, f353, f227;
sub.f32 f356, f354, f355;
mul.f32 f357, f351, f227;
fma.rn.f32 f358, f353, f226, f357;
mul.f32 f359, f240, f351;
mul.f32 f360, f241, f353;
sub.f32 f361, f359, f360;
mul.f32 f362, f240, f353;
fma.rn.f32 f363, f241, f351, f362;
mul.f32 f364, f361, f230;
mul.f32 f365, f363, f231;
sub.f32 f366, f364, f365;
mul.f32 f367, f361, f231;
fma.rn.f32 f368, f363, f230, f367;
mul.f32 f369, f240, f361;
mul.f32 f370, f241, f363;
sub.f32 f371, f369, f370;
mul.f32 f372, f240, f363;
fma.rn.f32 f373, f241, f361, f372;
mul.f32 f374, f371, f234;
mul.f32 f375, f373, f235;
sub.f32 f376, f374, f375;
mul.f32 f377, f371, f235;
fma.rn.f32 f378, f373, f234, f377;
mul.f32 f379, f240, f371;
mul.f32 f380, f241, f373;
sub.f32 f381, f379, f380;
mul.f32 f382, f240, f373;
fma.rn.f32 f383, f241, f371, f382;
mul.f32 f384, f381, f238;
mul.f32 f385, f383, f239;
sub.f32 f386, f384, f385;
mul.f32 f387, f381, f239;
fma.rn.f32 f388, f383, f238, f387;
shl.b32 r8, r5, 6;
and.b32 r9, r8, -8192;
add.s32 r10, r4, r9;
barrier.sync 0;
and.b32 r11, r8, 8128;
add.s32 r12, r10, r11;
st.shared.v4.f32 [r12], {f208, f246, f256, f266};
st.shared.v4.f32 [r12+16], {f276, f286, f296, f306};
st.shared.v4.f32 [r12+32], {f316, f326, f336, f346};
st.shared.v4.f32 [r12+48], {f356, f366, f376, f386};
barrier.sync 0;
mad.lo.s32 r13, r6, -60, r12;
ld.shared.f32 f389, [r13];
ld.shared.f32 f390, [r13+512];
ld.shared.f32 f391, [r13+1024];
ld.shared.f32 f392, [r13+1536];
ld.shared.f32 f393, [r13+2048];
ld.shared.f32 f394, [r13+2560];
ld.shared.f32 f395, [r13+3072];
ld.shared.f32 f396, [r13+3584];
ld.shared.f32 f397, [r13+4096];
ld.shared.f32 f398, [r13+4608];
ld.shared.f32 f399, [r13+5120];
ld.shared.f32 f400, [r13+5632];
ld.shared.f32 f401, [r13+6144];
ld.shared.f32 f402, [r13+6656];
ld.shared.f32 f403, [r13+7168];
ld.shared.f32 f404, [r13+7680];
barrier.sync 0;
st.shared.v4.f32 [r12], {f209, f248, f258, f268};
st.shared.v4.f32 [r12+16], {f278, f288, f298, f308};
st.shared.v4.f32 [r12+32], {f318, f328, f338, f348};
st.shared.v4.f32 [r12+48], {f358, f368, f378, f388};
barrier.sync 0;
ld.shared.f32 f405, [r13];
ld.shared.f32 f406, [r13+512];
ld.shared.f32 f407, [r13+1024];
ld.shared.f32 f408, [r13+1536];
ld.shared.f32 f409, [r13+2048];
ld.shared.f32 f410, [r13+2560];
ld.shared.f32 f411, [r13+3072];
ld.shared.f32 f412, [r13+3584];
ld.shared.f32 f413, [r13+4096];
ld.shared.f32 f414, [r13+4608];
ld.shared.f32 f415, [r13+5120];
ld.shared.f32 f416, [r13+5632];
ld.shared.f32 f417, [r13+6144];
ld.shared.f32 f418, [r13+6656];
ld.shared.f32 f419, [r13+7168];
ld.shared.f32 f420, [r13+7680];
add.f32 f421, f389, f397;
add.f32 f422, f405, f413;
sub.f32 f423, f389, f397;
sub.f32 f424, f405, f413;
add.f32 f425, f393, f401;
add.f32 f426, f409, f417;
sub.f32 f427, f393, f401;
sub.f32 f428, f409, f417;
add.f32 f429, f421, f425;
add.f32 f430, f422, f426;
sub.f32 f431, f421, f425;
sub.f32 f432, f422, f426;
add.f32 f433, f423, f428;
sub.f32 f434, f424, f427;
sub.f32 f435, f423, f428;
add.f32 f436, f424, f427;
add.f32 f437, f391, f399;
add.f32 f438, f407, f415;
sub.f32 f439, f391, f399;
sub.f32 f440, f407, f415;
add.f32 f441, f395, f403;
add.f32 f442, f411, f419;
sub.f32 f443, f395, f403;
sub.f32 f444, f411, f419;
add.f32 f445, f437, f441;
add.f32 f446, f438, f442;
sub.f32 f447, f437, f441;
sub.f32 f448, f438, f442;
add.f32 f449, f439, f444;
sub.f32 f450, f440, f443;
sub.f32 f451, f439, f444;
add.f32 f452, f440, f443;
mul.f32 f453, f449, 0f3F3504F3;
mul.f32 f454, f450, 0fBF3504F3;
sub.f32 f455, f453, f454;
mul.f32 f456, f450, 0f3F3504F3;
fma.rn.f32 f457, f449, 0fBF3504F3, f456;
mul.f32 f458, f451, 0fBF3504F3;
mul.f32 f459, f452, 0fBF3504F3;
sub.f32 f460, f458, f459;
add.f32 f461, f458, f459;
add.f32 f462, f429, f445;
add.f32 f463, f430, f446;
sub.f32 f464, f429, f445;
sub.f32 f465, f430, f446;
add.f32 f466, f433, f455;
add.f32 f467, f434, f457;
sub.f32 f468, f433, f455;
sub.f32 f469, f434, f457;
add.f32 f470, f431, f448;
sub.f32 f471, f432, f447;
sub.f32 f472, f431, f448;
add.f32 f473, f432, f447;
add.f32 f474, f435, f460;
add.f32 f475, f436, f461;
sub.f32 f476, f435, f460;
sub.f32 f477, f436, f461;
add.f32 f478, f390, f398;
add.f32 f479, f406, f414;
sub.f32 f480, f390, f398;
sub.f32 f481, f406, f414;
add.f32 f482, f394, f402;
add.f32 f483, f410, f418;
sub.f32 f484, f394, f402;
sub.f32 f485, f410, f418;
add.f32 f486, f478, f482;
add.f32 f487, f479, f483;
sub.f32 f488, f478, f482;
sub.f32 f489, f479, f483;
add.f32 f490, f480, f485;
sub.f32 f491, f481, f484;
sub.f32 f492, f480, f485;
add.f32 f493, f481, f484;
add.f32 f494, f392, f400;
add.f32 f495, f408, f416;
sub.f32 f496, f392, f400;
sub.f32 f497, f408, f416;
add.f32 f498, f396, f404;
add.f32 f499, f412, f420;
sub.f32 f500, f396, f404;
sub.f32 f501, f412, f420;
add.f32 f502, f494, f498;
add.f32 f503, f495, f499;
sub.f32 f504, f494, f498;
sub.f32 f505, f495, f499;
add.f32 f506, f496, f501;
sub.f32 f507, f497, f500;
sub.f32 f508, f496, f501;
add.f32 f509, f497, f500;
mul.f32 f510, f506, 0f3F3504F3;
mul.f32 f511, f507, 0fBF3504F3;
sub.f32 f512, f510, f511;
mul.f32 f513, f507, 0f3F3504F3;
fma.rn.f32 f514, f506, 0fBF3504F3, f513;
mul.f32 f515, f508, 0fBF3504F3;
mul.f32 f516, f509, 0fBF3504F3;
sub.f32 f517, f515, f516;
add.f32 f518, f515, f516;
add.f32 f519, f486, f502;
add.f32 f520, f487, f503;
sub.f32 f521, f486, f502;
sub.f32 f522, f487, f503;
add.f32 f523, f490, f512;
add.f32 f524, f491, f514;
sub.f32 f525, f490, f512;
sub.f32 f526, f491, f514;
add.f32 f527, f488, f505;
sub.f32 f528, f489, f504;
sub.f32 f529, f488, f505;
add.f32 f530, f489, f504;
add.f32 f531, f492, f517;
add.f32 f532, f493, f518;
sub.f32 f533, f492, f517;
sub.f32 f534, f493, f518;
mul.f32 f535, f523, 0f3F6C835E;
mul.f32 f536, f524, 0fBEC3EF15;
sub.f32 f537, f535, f536;
mul.f32 f538, f524, 0f3F6C835E;
fma.rn.f32 f539, f523, 0fBEC3EF15, f538;
mul.f32 f540, f527, 0f3F3504F3;
mul.f32 f541, f528, 0fBF3504F3;
sub.f32 f542, f540, f541;
mul.f32 f543, f528, 0f3F3504F3;
fma.rn.f32 f544, f527, 0fBF3504F3, f543;
mul.f32 f545, f531, 0f3EC3EF15;
mul.f32 f546, f532, 0fBF6C835E;
sub.f32 f547, f545, f546;
mul.f32 f548, f532, 0f3EC3EF15;
fma.rn.f32 f549, f531, 0fBF6C835E, f548;
mul.f32 f550, f525, 0fBEC3EF15;
mul.f32 f551, f526, 0fBF6C835E;
sub.f32 f552, f550, f551;
mul.f32 f553, f526, 0fBEC3EF15;
fma.rn.f32 f554, f525, 0fBF6C835E, f553;
mul.f32 f555, f529, 0fBF3504F3;
mul.f32 f556, f530, 0fBF3504F3;
sub.f32 f557, f555, f556;
add.f32 f558, f555, f556;
mul.f32 f559, f533, 0fBF6C835E;
mul.f32 f560, f534, 0fBEC3EF15;
sub.f32 f561, f559, f560;
mul.f32 f562, f534, 0fBF6C835E;
fma.rn.f32 f563, f533, 0fBEC3EF15, f562;
add.f32 f564, f462, f519;
add.f32 f565, f463, f520;
sub.f32 f566, f462, f519;
sub.f32 f567, f463, f520;
add.f32 f568, f466, f537;
add.f32 f569, f467, f539;
sub.f32 f570, f466, f537;
sub.f32 f571, f467, f539;
add.f32 f572, f470, f542;
add.f32 f573, f471, f544;
sub.f32 f574, f470, f542;
sub.f32 f575, f471, f544;
add.f32 f576, f474, f547;
add.f32 f577, f475, f549;
sub.f32 f578, f474, f547;
sub.f32 f579, f475, f549;
add.f32 f580, f464, f522;
sub.f32 f581, f465, f521;
sub.f32 f582, f464, f522;
add.f32 f583, f465, f521;
add.f32 f584, f468, f552;
add.f32 f585, f469, f554;
sub.f32 f586, f468, f552;
sub.f32 f587, f469, f554;
add.f32 f588, f472, f557;
add.f32 f589, f473, f558;
sub.f32 f590, f472, f557;
sub.f32 f591, f473, f558;
add.f32 f592, f476, f561;
add.f32 f593, f477, f563;
sub.f32 f594, f476, f561;
sub.f32 f595, f477, f563;
and.b32 r14, r5, 112;
bfe.u32 r15, r5, 4, 3;
mul.wide.u32 rd6, r15, 8;
mov.u64 rd7, %34;
add.s64 rd8, rd7, rd6;
ld.global.v2.f32 {f596, f597}, [rd8];
mul.f32 f600, f596, f568;
mul.f32 f601, f597, f569;
sub.f32 f602, f600, f601;
mul.f32 f603, f596, f569;
fma.rn.f32 f604, f597, f568, f603;
mul.f32 f605, f596, f596;
mul.f32 f606, f597, f597;
sub.f32 f607, f605, f606;
mul.f32 f608, f597, f596;
fma.rn.f32 f609, f597, f596, f608;
mul.f32 f610, f607, f572;
mul.f32 f611, f609, f573;
sub.f32 f612, f610, f611;
mul.f32 f613, f607, f573;
fma.rn.f32 f614, f609, f572, f613;
mul.f32 f615, f596, f607;
mul.f32 f616, f597, f609;
sub.f32 f617, f615, f616;
mul.f32 f618, f596, f609;
fma.rn.f32 f619, f597, f607, f618;
mul.f32 f620, f617, f576;
mul.f32 f621, f619, f577;
sub.f32 f622, f620, f621;
mul.f32 f623, f617, f577;
fma.rn.f32 f624, f619, f576, f623;
mul.f32 f625, f596, f617;
mul.f32 f626, f597, f619;
sub.f32 f627, f625, f626;
mul.f32 f628, f596, f619;
fma.rn.f32 f629, f597, f617, f628;
mul.f32 f630, f627, f580;
mul.f32 f631, f629, f581;
sub.f32 f632, f630, f631;
mul.f32 f633, f627, f581;
fma.rn.f32 f634, f629, f580, f633;
mul.f32 f635, f596, f627;
mul.f32 f636, f597, f629;
sub.f32 f637, f635, f636;
mul.f32 f638, f596, f629;
fma.rn.f32 f639, f597, f627, f638;
mul.f32 f640, f637, f584;
mul.f32 f641, f639, f585;
sub.f32 f642, f640, f641;
mul.f32 f643, f637, f585;
fma.rn.f32 f644, f639, f584, f643;
mul.f32 f645, f596, f637;
mul.f32 f646, f597, f639;
sub.f32 f647, f645, f646;
mul.f32 f648, f596, f639;
fma.rn.f32 f649, f597, f637, f648;
mul.f32 f650, f647, f588;
mul.f32 f651, f649, f589;
sub.f32 f652, f650, f651;
mul.f32 f653, f647, f589;
fma.rn.f32 f654, f649, f588, f653;
mul.f32 f655, f596, f647;
mul.f32 f656, f597, f649;
sub.f32 f657, f655, f656;
mul.f32 f658, f596, f649;
fma.rn.f32 f659, f597, f647, f658;
mul.f32 f660, f657, f592;
mul.f32 f661, f659, f593;
sub.f32 f662, f660, f661;
mul.f32 f663, f657, f593;
fma.rn.f32 f664, f659, f592, f663;
mul.f32 f665, f596, f657;
mul.f32 f666, f597, f659;
sub.f32 f667, f665, f666;
mul.f32 f668, f596, f659;
fma.rn.f32 f669, f597, f657, f668;
mul.f32 f670, f667, f566;
mul.f32 f671, f669, f567;
sub.f32 f672, f670, f671;
mul.f32 f673, f667, f567;
fma.rn.f32 f674, f669, f566, f673;
mul.f32 f675, f596, f667;
mul.f32 f676, f597, f669;
sub.f32 f677, f675, f676;
mul.f32 f678, f596, f669;
fma.rn.f32 f679, f597, f667, f678;
mul.f32 f680, f677, f570;
mul.f32 f681, f679, f571;
sub.f32 f682, f680, f681;
mul.f32 f683, f677, f571;
fma.rn.f32 f684, f679, f570, f683;
mul.f32 f685, f596, f677;
mul.f32 f686, f597, f679;
sub.f32 f687, f685, f686;
mul.f32 f688, f596, f679;
fma.rn.f32 f689, f597, f677, f688;
mul.f32 f690, f687, f574;
mul.f32 f691, f689, f575;
sub.f32 f692, f690, f691;
mul.f32 f693, f687, f575;
fma.rn.f32 f694, f689, f574, f693;
mul.f32 f695, f596, f687;
mul.f32 f696, f597, f689;
sub.f32 f697, f695, f696;
mul.f32 f698, f596, f689;
fma.rn.f32 f699, f597, f687, f698;
mul.f32 f700, f697, f578;
mul.f32 f701, f699, f579;
sub.f32 f702, f700, f701;
mul.f32 f703, f697, f579;
fma.rn.f32 f704, f699, f578, f703;
mul.f32 f705, f596, f697;
mul.f32 f706, f597, f699;
sub.f32 f707, f705, f706;
mul.f32 f708, f596, f699;
fma.rn.f32 f709, f597, f697, f708;
mul.f32 f710, f707, f582;
mul.f32 f711, f709, f583;
sub.f32 f712, f710, f711;
mul.f32 f713, f707, f583;
fma.rn.f32 f714, f709, f582, f713;
mul.f32 f715, f596, f707;
mul.f32 f716, f597, f709;
sub.f32 f717, f715, f716;
mul.f32 f718, f596, f709;
fma.rn.f32 f719, f597, f707, f718;
mul.f32 f720, f717, f586;
mul.f32 f721, f719, f587;
sub.f32 f722, f720, f721;
mul.f32 f723, f717, f587;
fma.rn.f32 f724, f719, f586, f723;
mul.f32 f725, f596, f717;
mul.f32 f726, f597, f719;
sub.f32 f727, f725, f726;
mul.f32 f728, f596, f719;
fma.rn.f32 f729, f597, f717, f728;
mul.f32 f730, f727, f590;
mul.f32 f731, f729, f591;
sub.f32 f732, f730, f731;
mul.f32 f733, f727, f591;
fma.rn.f32 f734, f729, f590, f733;
mul.f32 f735, f596, f727;
mul.f32 f736, f597, f729;
sub.f32 f737, f735, f736;
mul.f32 f738, f596, f729;
fma.rn.f32 f739, f597, f727, f738;
mul.f32 f740, f737, f594;
mul.f32 f741, f739, f595;
sub.f32 f742, f740, f741;
mul.f32 f743, f737, f595;
fma.rn.f32 f744, f739, f594, f743;
shl.b32 r16, r5, 2;
and.b32 r17, r16, 60;
add.s32 r18, r10, r17;
barrier.sync 0;
and.b32 r19, r8, 7168;
add.s32 r20, r18, r19;
st.shared.f32 [r20], f564;
st.shared.f32 [r20+64], f602;
st.shared.f32 [r20+128], f612;
st.shared.f32 [r20+192], f622;
st.shared.f32 [r20+256], f632;
st.shared.f32 [r20+320], f642;
st.shared.f32 [r20+384], f652;
st.shared.f32 [r20+448], f662;
st.shared.f32 [r20+512], f672;
st.shared.f32 [r20+576], f682;
st.shared.f32 [r20+640], f692;
st.shared.f32 [r20+704], f702;
st.shared.f32 [r20+768], f712;
st.shared.f32 [r20+832], f722;
st.shared.f32 [r20+896], f732;
st.shared.f32 [r20+960], f742;
barrier.sync 0;
mad.lo.s32 r21, r14, -60, r20;
ld.shared.f32 f745, [r21];
ld.shared.f32 f746, [r21+512];
ld.shared.f32 f747, [r21+1024];
ld.shared.f32 f748, [r21+1536];
ld.shared.f32 f749, [r21+2048];
ld.shared.f32 f750, [r21+2560];
ld.shared.f32 f751, [r21+3072];
ld.shared.f32 f752, [r21+3584];
ld.shared.f32 f753, [r21+4096];
ld.shared.f32 f754, [r21+4608];
ld.shared.f32 f755, [r21+5120];
ld.shared.f32 f756, [r21+5632];
ld.shared.f32 f757, [r21+6144];
ld.shared.f32 f758, [r21+6656];
ld.shared.f32 f759, [r21+7168];
ld.shared.f32 f760, [r21+7680];
barrier.sync 0;
st.shared.f32 [r20], f565;
st.shared.f32 [r20+64], f604;
st.shared.f32 [r20+128], f614;
st.shared.f32 [r20+192], f624;
st.shared.f32 [r20+256], f634;
st.shared.f32 [r20+320], f644;
st.shared.f32 [r20+384], f654;
st.shared.f32 [r20+448], f664;
st.shared.f32 [r20+512], f674;
st.shared.f32 [r20+576], f684;
st.shared.f32 [r20+640], f694;
st.shared.f32 [r20+704], f704;
st.shared.f32 [r20+768], f714;
st.shared.f32 [r20+832], f724;
st.shared.f32 [r20+896], f734;
st.shared.f32 [r20+960], f744;
barrier.sync 0;
ld.shared.f32 f761, [r21];
ld.shared.f32 f762, [r21+512];
ld.shared.f32 f763, [r21+1024];
ld.shared.f32 f764, [r21+1536];
ld.shared.f32 f765, [r21+2048];
ld.shared.f32 f766, [r21+2560];
ld.shared.f32 f767, [r21+3072];
ld.shared.f32 f768, [r21+3584];
ld.shared.f32 f769, [r21+4096];
ld.shared.f32 f770, [r21+4608];
ld.shared.f32 f771, [r21+5120];
ld.shared.f32 f772, [r21+5632];
ld.shared.f32 f773, [r21+6144];
ld.shared.f32 f774, [r21+6656];
ld.shared.f32 f775, [r21+7168];
ld.shared.f32 f776, [r21+7680];
add.f32 f777, f745, f753;
add.f32 f778, f761, f769;
sub.f32 f779, f745, f753;
sub.f32 f780, f761, f769;
add.f32 f781, f749, f757;
add.f32 f782, f765, f773;
sub.f32 f783, f749, f757;
sub.f32 f784, f765, f773;
add.f32 f785, f777, f781;
add.f32 f786, f778, f782;
sub.f32 f787, f777, f781;
sub.f32 f788, f778, f782;
add.f32 f789, f779, f784;
sub.f32 f790, f780, f783;
sub.f32 f791, f779, f784;
add.f32 f792, f780, f783;
add.f32 f793, f747, f755;
add.f32 f794, f763, f771;
sub.f32 f795, f747, f755;
sub.f32 f796, f763, f771;
add.f32 f797, f751, f759;
add.f32 f798, f767, f775;
sub.f32 f799, f751, f759;
sub.f32 f800, f767, f775;
add.f32 f801, f793, f797;
add.f32 f802, f794, f798;
sub.f32 f803, f793, f797;
sub.f32 f804, f794, f798;
add.f32 f805, f795, f800;
sub.f32 f806, f796, f799;
sub.f32 f807, f795, f800;
add.f32 f808, f796, f799;
mul.f32 f809, f805, 0f3F3504F3;
mul.f32 f810, f806, 0fBF3504F3;
sub.f32 f811, f809, f810;
mul.f32 f812, f806, 0f3F3504F3;
fma.rn.f32 f813, f805, 0fBF3504F3, f812;
mul.f32 f814, f807, 0fBF3504F3;
mul.f32 f815, f808, 0fBF3504F3;
sub.f32 f816, f814, f815;
add.f32 f817, f814, f815;
add.f32 f818, f746, f754;
add.f32 f819, f762, f770;
sub.f32 f820, f746, f754;
sub.f32 f821, f762, f770;
add.f32 f822, f750, f758;
add.f32 f823, f766, f774;
sub.f32 f824, f750, f758;
sub.f32 f825, f766, f774;
add.f32 f826, f818, f822;
add.f32 f827, f819, f823;
sub.f32 f828, f818, f822;
sub.f32 f829, f819, f823;
add.f32 f830, f820, f825;
sub.f32 f831, f821, f824;
sub.f32 f832, f820, f825;
add.f32 f833, f821, f824;
add.f32 f834, f748, f756;
add.f32 f835, f764, f772;
sub.f32 f836, f748, f756;
sub.f32 f837, f764, f772;
add.f32 f838, f752, f760;
add.f32 f839, f768, f776;
sub.f32 f840, f752, f760;
sub.f32 f841, f768, f776;
add.f32 f842, f834, f838;
add.f32 f843, f835, f839;
sub.f32 f844, f834, f838;
sub.f32 f845, f835, f839;
add.f32 f846, f836, f841;
sub.f32 f847, f837, f840;
sub.f32 f848, f836, f841;
add.f32 f849, f837, f840;
mul.f32 f850, f846, 0f3F3504F3;
mul.f32 f851, f847, 0fBF3504F3;
sub.f32 f852, f850, f851;
mul.f32 f853, f847, 0f3F3504F3;
fma.rn.f32 f854, f846, 0fBF3504F3, f853;
mul.f32 f855, f848, 0fBF3504F3;
mul.f32 f856, f849, 0fBF3504F3;
sub.f32 f857, f855, f856;
add.f32 f858, f855, f856;
add.f32 %0, f785, f801;
add.f32 %1, f786, f802;
add.f32 %2, f826, f842;
add.f32 %3, f827, f843;
add.f32 %5, f790, f813;
add.f32 %4, f789, f811;
add.f32 %7, f831, f854;
add.f32 %6, f830, f852;
sub.f32 %9, f788, f803;
add.f32 %8, f787, f804;
sub.f32 %11, f829, f844;
add.f32 %10, f828, f845;
add.f32 %13, f792, f817;
add.f32 %12, f791, f816;
add.f32 %15, f833, f858;
add.f32 %14, f832, f857;
sub.f32 %16, f785, f801;
sub.f32 %17, f786, f802;
sub.f32 %18, f826, f842;
sub.f32 %19, f827, f843;
sub.f32 %21, f790, f813;
sub.f32 %20, f789, f811;
sub.f32 %23, f831, f854;
sub.f32 %22, f830, f852;
add.f32 %25, f788, f803;
sub.f32 %24, f787, f804;
add.f32 %27, f829, f844;
sub.f32 %26, f828, f845;
sub.f32 %29, f792, f817;
sub.f32 %28, f791, f816;
sub.f32 %31, f833, f858;
sub.f32 %30, f832, f857;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y), "=f"(rmem[2].x), "=f"(rmem[2].y), "=f"(rmem[3].x), "=f"(rmem[3].y), "=f"(rmem[4].x), "=f"(rmem[4].y), "=f"(rmem[5].x), "=f"(rmem[5].y), "=f"(rmem[6].x), "=f"(rmem[6].y), "=f"(rmem[7].x), "=f"(rmem[7].y), "=f"(rmem[8].x), "=f"(rmem[8].y), "=f"(rmem[9].x), "=f"(rmem[9].y), "=f"(rmem[10].x), "=f"(rmem[10].y), "=f"(rmem[11].x), "=f"(rmem[11].y), "=f"(rmem[12].x), "=f"(rmem[12].y), "=f"(rmem[13].x), "=f"(rmem[13].y), "=f"(rmem[14].x), "=f"(rmem[14].y), "=f"(rmem[15].x), "=f"(rmem[15].y): "r"(smem), "l"(lut_sp_16_2048), "l"(lut_sp_16_128), "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y), "f"(rmem[1].y), "f"(rmem[2].x), "f"(rmem[2].y), "f"(rmem[2].y), "f"(rmem[3].x), "f"(rmem[3].y), "f"(rmem[4].x), "f"(rmem[4].y), "f"(rmem[4].y), "f"(rmem[5].x), "f"(rmem[5].y), "f"(rmem[5].y), "f"(rmem[6].x), "f"(rmem[6].y), "f"(rmem[7].x), "f"(rmem[7].y), "f"(rmem[7].y), "f"(rmem[8].x), "f"(rmem[8].y), "f"(rmem[8].y), "f"(rmem[9].x), "f"(rmem[9].y), "f"(rmem[10].x), "f"(rmem[10].y), "f"(rmem[10].y), "f"(rmem[11].x), "f"(rmem[11].y), "f"(rmem[11].y), "f"(rmem[12].x), "f"(rmem[12].y), "f"(rmem[13].x), "f"(rmem[13].y), "f"(rmem[13].y), "f"(rmem[14].x), "f"(rmem[14].y), "f"(rmem[14].y), "f"(rmem[15].x), "f"(rmem[15].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<93, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<491>;
.reg .b32 r<28>;
.reg .b64 rd<12>;
mov.u32 r1, %tid.y;
shl.b32 r2, r1, 13;
mov.u32 r3, %16;
add.s32 r4, r3, r2;
mov.u32 r5, %tid.x;
add.f32 f33, %20, %30;
add.f32 f34, %21, %32;
sub.f32 f35, %20, %30;
sub.f32 f36, %21, %32;
add.f32 f37, %25, %36;
add.f32 f38, %27, %37;
sub.f32 f39, %25, %36;
sub.f32 f40, %27, %37;
add.f32 f41, f33, f37;
add.f32 f42, f34, f38;
sub.f32 f43, f33, f37;
sub.f32 f44, f34, f38;
add.f32 f45, f35, f40;
sub.f32 f46, f36, f39;
sub.f32 f47, f35, f40;
add.f32 f48, f36, f39;
add.f32 f49, %22, %33;
add.f32 f50, %24, %35;
sub.f32 f51, %22, %33;
sub.f32 f52, %24, %35;
add.f32 f53, %28, %38;
add.f32 f54, %29, %39;
sub.f32 f55, %28, %38;
sub.f32 f56, %29, %39;
add.f32 f57, f49, f53;
add.f32 f58, f50, f54;
sub.f32 f59, f49, f53;
sub.f32 f60, f50, f54;
add.f32 f61, f51, f56;
sub.f32 f62, f52, f55;
sub.f32 f63, f51, f56;
add.f32 f64, f52, f55;
mul.f32 f65, f61, 0f3F3504F3;
mul.f32 f66, f62, 0fBF3504F3;
sub.f32 f67, f65, f66;
mul.f32 f68, f62, 0f3F3504F3;
fma.rn.f32 f69, f61, 0fBF3504F3, f68;
mul.f32 f70, f63, 0fBF3504F3;
mul.f32 f71, f64, 0fBF3504F3;
sub.f32 f72, f70, f71;
add.f32 f73, f70, f71;
add.f32 f74, f41, f57;
add.f32 f75, f42, f58;
sub.f32 f76, f41, f57;
sub.f32 f77, f42, f58;
add.f32 f78, f45, f67;
add.f32 f79, f46, f69;
sub.f32 f80, f45, f67;
sub.f32 f81, f46, f69;
add.f32 f82, f43, f60;
sub.f32 f83, f44, f59;
sub.f32 f84, f43, f60;
add.f32 f85, f44, f59;
add.f32 f86, f47, f72;
add.f32 f87, f48, f73;
sub.f32 f88, f47, f72;
sub.f32 f89, f48, f73;
and.b32 r6, r5, 255;
shl.b32 r7, r5, 3;
cvt.u64.u32 rd2, r7;
and.b64 rd3, rd2, 2040;
mov.u64 rd4, %17;
add.s64 rd5, rd4, rd3;
ld.global.v2.f32 {f90, f91}, [rd5];
mul.f32 f94, f90, f78;
mul.f32 f95, f91, f79;
sub.f32 f96, f94, f95;
mul.f32 f97, f90, f79;
fma.rn.f32 f98, f91, f78, f97;
mul.f32 f99, f90, f90;
mul.f32 f100, f91, f91;
sub.f32 f101, f99, f100;
mul.f32 f102, f91, f90;
fma.rn.f32 f103, f91, f90, f102;
mul.f32 f104, f101, f82;
mul.f32 f105, f103, f83;
sub.f32 f106, f104, f105;
mul.f32 f107, f101, f83;
fma.rn.f32 f108, f103, f82, f107;
mul.f32 f109, f90, f101;
mul.f32 f110, f91, f103;
sub.f32 f111, f109, f110;
mul.f32 f112, f90, f103;
fma.rn.f32 f113, f91, f101, f112;
mul.f32 f114, f111, f86;
mul.f32 f115, f113, f87;
sub.f32 f116, f114, f115;
mul.f32 f117, f111, f87;
fma.rn.f32 f118, f113, f86, f117;
mul.f32 f119, f90, f111;
mul.f32 f120, f91, f113;
sub.f32 f121, f119, f120;
mul.f32 f122, f90, f113;
fma.rn.f32 f123, f91, f111, f122;
mul.f32 f124, f121, f76;
mul.f32 f125, f123, f77;
sub.f32 f126, f124, f125;
mul.f32 f127, f121, f77;
fma.rn.f32 f128, f123, f76, f127;
mul.f32 f129, f90, f121;
mul.f32 f130, f91, f123;
sub.f32 f131, f129, f130;
mul.f32 f132, f90, f123;
fma.rn.f32 f133, f91, f121, f132;
mul.f32 f134, f131, f80;
mul.f32 f135, f133, f81;
sub.f32 f136, f134, f135;
mul.f32 f137, f131, f81;
fma.rn.f32 f138, f133, f80, f137;
mul.f32 f139, f90, f131;
mul.f32 f140, f91, f133;
sub.f32 f141, f139, f140;
mul.f32 f142, f90, f133;
fma.rn.f32 f143, f91, f131, f142;
mul.f32 f144, f141, f84;
mul.f32 f145, f143, f85;
sub.f32 f146, f144, f145;
mul.f32 f147, f141, f85;
fma.rn.f32 f148, f143, f84, f147;
mul.f32 f149, f90, f141;
mul.f32 f150, f91, f143;
sub.f32 f151, f149, f150;
mul.f32 f152, f90, f143;
fma.rn.f32 f153, f91, f141, f152;
mul.f32 f154, f151, f88;
mul.f32 f155, f153, f89;
sub.f32 f156, f154, f155;
mul.f32 f157, f151, f89;
fma.rn.f32 f158, f153, f88, f157;
shl.b32 r8, r5, 5;
and.b32 r9, r8, -8192;
add.s32 r10, r4, r9;
barrier.sync 0;
and.b32 r11, r8, 8160;
add.s32 r12, r10, r11;
st.shared.v4.f32 [r12], {f74, f96, f106, f116};
st.shared.v4.f32 [r12+16], {f126, f136, f146, f156};
barrier.sync 0;
mad.lo.s32 r13, r6, -28, r12;
ld.shared.f32 f159, [r13];
ld.shared.f32 f160, [r13+1024];
ld.shared.f32 f161, [r13+2048];
ld.shared.f32 f162, [r13+3072];
ld.shared.f32 f163, [r13+4096];
ld.shared.f32 f164, [r13+5120];
ld.shared.f32 f165, [r13+6144];
ld.shared.f32 f166, [r13+7168];
barrier.sync 0;
st.shared.v4.f32 [r12], {f75, f98, f108, f118};
st.shared.v4.f32 [r12+16], {f128, f138, f148, f158};
barrier.sync 0;
ld.shared.f32 f167, [r13];
ld.shared.f32 f168, [r13+1024];
ld.shared.f32 f169, [r13+2048];
ld.shared.f32 f170, [r13+3072];
ld.shared.f32 f171, [r13+4096];
ld.shared.f32 f172, [r13+5120];
ld.shared.f32 f173, [r13+6144];
ld.shared.f32 f174, [r13+7168];
add.f32 f175, f159, f163;
add.f32 f176, f167, f171;
sub.f32 f177, f159, f163;
sub.f32 f178, f167, f171;
add.f32 f179, f161, f165;
add.f32 f180, f169, f173;
sub.f32 f181, f161, f165;
sub.f32 f182, f169, f173;
add.f32 f183, f175, f179;
add.f32 f184, f176, f180;
sub.f32 f185, f175, f179;
sub.f32 f186, f176, f180;
add.f32 f187, f177, f182;
sub.f32 f188, f178, f181;
sub.f32 f189, f177, f182;
add.f32 f190, f178, f181;
add.f32 f191, f160, f164;
add.f32 f192, f168, f172;
sub.f32 f193, f160, f164;
sub.f32 f194, f168, f172;
add.f32 f195, f162, f166;
add.f32 f196, f170, f174;
sub.f32 f197, f162, f166;
sub.f32 f198, f170, f174;
add.f32 f199, f191, f195;
add.f32 f200, f192, f196;
sub.f32 f201, f191, f195;
sub.f32 f202, f192, f196;
add.f32 f203, f193, f198;
sub.f32 f204, f194, f197;
sub.f32 f205, f193, f198;
add.f32 f206, f194, f197;
mul.f32 f207, f203, 0f3F3504F3;
mul.f32 f208, f204, 0fBF3504F3;
sub.f32 f209, f207, f208;
mul.f32 f210, f204, 0f3F3504F3;
fma.rn.f32 f211, f203, 0fBF3504F3, f210;
mul.f32 f212, f205, 0fBF3504F3;
mul.f32 f213, f206, 0fBF3504F3;
sub.f32 f214, f212, f213;
add.f32 f215, f212, f213;
add.f32 f216, f183, f199;
add.f32 f217, f184, f200;
sub.f32 f218, f183, f199;
sub.f32 f219, f184, f200;
add.f32 f220, f187, f209;
add.f32 f221, f188, f211;
sub.f32 f222, f187, f209;
sub.f32 f223, f188, f211;
add.f32 f224, f185, f202;
sub.f32 f225, f186, f201;
sub.f32 f226, f185, f202;
add.f32 f227, f186, f201;
add.f32 f228, f189, f214;
add.f32 f229, f190, f215;
sub.f32 f230, f189, f214;
sub.f32 f231, f190, f215;
and.b32 r14, r5, 248;
cvt.u64.u32 rd6, r14;
mov.u64 rd7, %18;
add.s64 rd8, rd7, rd6;
ld.global.v2.f32 {f232, f233}, [rd8];
mul.f32 f236, f232, f220;
mul.f32 f237, f233, f221;
sub.f32 f238, f236, f237;
mul.f32 f239, f232, f221;
fma.rn.f32 f240, f233, f220, f239;
mul.f32 f241, f232, f232;
mul.f32 f242, f233, f233;
sub.f32 f243, f241, f242;
mul.f32 f244, f233, f232;
fma.rn.f32 f245, f233, f232, f244;
mul.f32 f246, f243, f224;
mul.f32 f247, f245, f225;
sub.f32 f248, f246, f247;
mul.f32 f249, f243, f225;
fma.rn.f32 f250, f245, f224, f249;
mul.f32 f251, f232, f243;
mul.f32 f252, f233, f245;
sub.f32 f253, f251, f252;
mul.f32 f254, f232, f245;
fma.rn.f32 f255, f233, f243, f254;
mul.f32 f256, f253, f228;
mul.f32 f257, f255, f229;
sub.f32 f258, f256, f257;
mul.f32 f259, f253, f229;
fma.rn.f32 f260, f255, f228, f259;
mul.f32 f261, f232, f253;
mul.f32 f262, f233, f255;
sub.f32 f263, f261, f262;
mul.f32 f264, f232, f255;
fma.rn.f32 f265, f233, f253, f264;
mul.f32 f266, f263, f218;
mul.f32 f267, f265, f219;
sub.f32 f268, f266, f267;
mul.f32 f269, f263, f219;
fma.rn.f32 f270, f265, f218, f269;
mul.f32 f271, f232, f263;
mul.f32 f272, f233, f265;
sub.f32 f273, f271, f272;
mul.f32 f274, f232, f265;
fma.rn.f32 f275, f233, f263, f274;
mul.f32 f276, f273, f222;
mul.f32 f277, f275, f223;
sub.f32 f278, f276, f277;
mul.f32 f279, f273, f223;
fma.rn.f32 f280, f275, f222, f279;
mul.f32 f281, f232, f273;
mul.f32 f282, f233, f275;
sub.f32 f283, f281, f282;
mul.f32 f284, f232, f275;
fma.rn.f32 f285, f233, f273, f284;
mul.f32 f286, f283, f226;
mul.f32 f287, f285, f227;
sub.f32 f288, f286, f287;
mul.f32 f289, f283, f227;
fma.rn.f32 f290, f285, f226, f289;
mul.f32 f291, f232, f283;
mul.f32 f292, f233, f285;
sub.f32 f293, f291, f292;
mul.f32 f294, f232, f285;
fma.rn.f32 f295, f233, f283, f294;
mul.f32 f296, f293, f230;
mul.f32 f297, f295, f231;
sub.f32 f298, f296, f297;
mul.f32 f299, f293, f231;
fma.rn.f32 f300, f295, f230, f299;
shl.b32 r15, r5, 2;
and.b32 r16, r15, 28;
add.s32 r17, r10, r16;
barrier.sync 0;
and.b32 r18, r8, 7936;
add.s32 r19, r17, r18;
st.shared.f32 [r19], f216;
st.shared.f32 [r19+32], f238;
st.shared.f32 [r19+64], f248;
st.shared.f32 [r19+96], f258;
st.shared.f32 [r19+128], f268;
st.shared.f32 [r19+160], f278;
st.shared.f32 [r19+192], f288;
st.shared.f32 [r19+224], f298;
barrier.sync 0;
mad.lo.s32 r20, r14, -28, r19;
ld.shared.f32 f301, [r20];
ld.shared.f32 f302, [r20+1024];
ld.shared.f32 f303, [r20+2048];
ld.shared.f32 f304, [r20+3072];
ld.shared.f32 f305, [r20+4096];
ld.shared.f32 f306, [r20+5120];
ld.shared.f32 f307, [r20+6144];
ld.shared.f32 f308, [r20+7168];
barrier.sync 0;
st.shared.f32 [r19], f217;
st.shared.f32 [r19+32], f240;
st.shared.f32 [r19+64], f250;
st.shared.f32 [r19+96], f260;
st.shared.f32 [r19+128], f270;
st.shared.f32 [r19+160], f280;
st.shared.f32 [r19+192], f290;
st.shared.f32 [r19+224], f300;
barrier.sync 0;
ld.shared.f32 f309, [r20];
ld.shared.f32 f310, [r20+1024];
ld.shared.f32 f311, [r20+2048];
ld.shared.f32 f312, [r20+3072];
ld.shared.f32 f313, [r20+4096];
ld.shared.f32 f314, [r20+5120];
ld.shared.f32 f315, [r20+6144];
ld.shared.f32 f316, [r20+7168];
add.f32 f317, f301, f305;
add.f32 f318, f309, f313;
sub.f32 f319, f301, f305;
sub.f32 f320, f309, f313;
add.f32 f321, f303, f307;
add.f32 f322, f311, f315;
sub.f32 f323, f303, f307;
sub.f32 f324, f311, f315;
add.f32 f325, f317, f321;
add.f32 f326, f318, f322;
sub.f32 f327, f317, f321;
sub.f32 f328, f318, f322;
add.f32 f329, f319, f324;
sub.f32 f330, f320, f323;
sub.f32 f331, f319, f324;
add.f32 f332, f320, f323;
add.f32 f333, f302, f306;
add.f32 f334, f310, f314;
sub.f32 f335, f302, f306;
sub.f32 f336, f310, f314;
add.f32 f337, f304, f308;
add.f32 f338, f312, f316;
sub.f32 f339, f304, f308;
sub.f32 f340, f312, f316;
add.f32 f341, f333, f337;
add.f32 f342, f334, f338;
sub.f32 f343, f333, f337;
sub.f32 f344, f334, f338;
add.f32 f345, f335, f340;
sub.f32 f346, f336, f339;
sub.f32 f347, f335, f340;
add.f32 f348, f336, f339;
mul.f32 f349, f345, 0f3F3504F3;
mul.f32 f350, f346, 0fBF3504F3;
sub.f32 f351, f349, f350;
mul.f32 f352, f346, 0f3F3504F3;
fma.rn.f32 f353, f345, 0fBF3504F3, f352;
mul.f32 f354, f347, 0fBF3504F3;
mul.f32 f355, f348, 0fBF3504F3;
sub.f32 f356, f354, f355;
add.f32 f357, f354, f355;
add.f32 f358, f325, f341;
add.f32 f359, f326, f342;
sub.f32 f360, f325, f341;
sub.f32 f361, f326, f342;
add.f32 f362, f329, f351;
add.f32 f363, f330, f353;
sub.f32 f364, f329, f351;
sub.f32 f365, f330, f353;
add.f32 f366, f327, f344;
sub.f32 f367, f328, f343;
sub.f32 f368, f327, f344;
add.f32 f369, f328, f343;
add.f32 f370, f331, f356;
add.f32 f371, f332, f357;
sub.f32 f372, f331, f356;
sub.f32 f373, f332, f357;
and.b32 r21, r5, 192;
bfe.u32 r22, r5, 6, 2;
mul.wide.u32 rd9, r22, 8;
mov.u64 rd10, %19;
add.s64 rd11, rd10, rd9;
ld.global.v2.f32 {f374, f375}, [rd11];
mul.f32 f378, f374, f362;
mul.f32 f379, f375, f363;
sub.f32 f380, f378, f379;
mul.f32 f381, f374, f363;
fma.rn.f32 f382, f375, f362, f381;
mul.f32 f383, f374, f374;
mul.f32 f384, f375, f375;
sub.f32 f385, f383, f384;
mul.f32 f386, f375, f374;
fma.rn.f32 f387, f375, f374, f386;
mul.f32 f388, f385, f366;
mul.f32 f389, f387, f367;
sub.f32 f390, f388, f389;
mul.f32 f391, f385, f367;
fma.rn.f32 f392, f387, f366, f391;
mul.f32 f393, f374, f385;
mul.f32 f394, f375, f387;
sub.f32 f395, f393, f394;
mul.f32 f396, f374, f387;
fma.rn.f32 f397, f375, f385, f396;
mul.f32 f398, f395, f370;
mul.f32 f399, f397, f371;
sub.f32 f400, f398, f399;
mul.f32 f401, f395, f371;
fma.rn.f32 f402, f397, f370, f401;
mul.f32 f403, f374, f395;
mul.f32 f404, f375, f397;
sub.f32 f405, f403, f404;
mul.f32 f406, f374, f397;
fma.rn.f32 f407, f375, f395, f406;
mul.f32 f408, f405, f360;
mul.f32 f409, f407, f361;
sub.f32 f410, f408, f409;
mul.f32 f411, f405, f361;
fma.rn.f32 f412, f407, f360, f411;
mul.f32 f413, f374, f405;
mul.f32 f414, f375, f407;
sub.f32 f415, f413, f414;
mul.f32 f416, f374, f407;
fma.rn.f32 f417, f375, f405, f416;
mul.f32 f418, f415, f364;
mul.f32 f419, f417, f365;
sub.f32 f420, f418, f419;
mul.f32 f421, f415, f365;
fma.rn.f32 f422, f417, f364, f421;
mul.f32 f423, f374, f415;
mul.f32 f424, f375, f417;
sub.f32 f425, f423, f424;
mul.f32 f426, f374, f417;
fma.rn.f32 f427, f375, f415, f426;
mul.f32 f428, f425, f368;
mul.f32 f429, f427, f369;
sub.f32 f430, f428, f429;
mul.f32 f431, f425, f369;
fma.rn.f32 f432, f427, f368, f431;
mul.f32 f433, f374, f425;
mul.f32 f434, f375, f427;
sub.f32 f435, f433, f434;
mul.f32 f436, f374, f427;
fma.rn.f32 f437, f375, f425, f436;
mul.f32 f438, f435, f372;
mul.f32 f439, f437, f373;
sub.f32 f440, f438, f439;
mul.f32 f441, f435, f373;
fma.rn.f32 f442, f437, f372, f441;
and.b32 r23, r15, 252;
add.s32 r24, r10, r23;
barrier.sync 0;
and.b32 r25, r8, 6144;
add.s32 r26, r24, r25;
st.shared.f32 [r26], f358;
st.shared.f32 [r26+256], f380;
st.shared.f32 [r26+512], f390;
st.shared.f32 [r26+768], f400;
st.shared.f32 [r26+1024], f410;
st.shared.f32 [r26+1280], f420;
st.shared.f32 [r26+1536], f430;
st.shared.f32 [r26+1792], f440;
barrier.sync 0;
mad.lo.s32 r27, r21, -28, r26;
ld.shared.f32 f443, [r27];
ld.shared.f32 f444, [r27+1024];
ld.shared.f32 f445, [r27+2048];
ld.shared.f32 f446, [r27+3072];
ld.shared.f32 f447, [r27+4096];
ld.shared.f32 f448, [r27+5120];
ld.shared.f32 f449, [r27+6144];
ld.shared.f32 f450, [r27+7168];
barrier.sync 0;
st.shared.f32 [r26], f359;
st.shared.f32 [r26+256], f382;
st.shared.f32 [r26+512], f392;
st.shared.f32 [r26+768], f402;
st.shared.f32 [r26+1024], f412;
st.shared.f32 [r26+1280], f422;
st.shared.f32 [r26+1536], f432;
st.shared.f32 [r26+1792], f442;
barrier.sync 0;
ld.shared.f32 f451, [r27];
ld.shared.f32 f452, [r27+1024];
ld.shared.f32 f453, [r27+2048];
ld.shared.f32 f454, [r27+3072];
ld.shared.f32 f455, [r27+4096];
ld.shared.f32 f456, [r27+5120];
ld.shared.f32 f457, [r27+6144];
ld.shared.f32 f458, [r27+7168];
add.f32 f459, f443, f447;
add.f32 f460, f451, f455;
sub.f32 f461, f443, f447;
sub.f32 f462, f451, f455;
add.f32 f463, f445, f449;
add.f32 f464, f453, f457;
sub.f32 f465, f445, f449;
sub.f32 f466, f453, f457;
add.f32 f467, f444, f448;
add.f32 f468, f452, f456;
sub.f32 f469, f444, f448;
sub.f32 f470, f452, f456;
add.f32 f471, f446, f450;
add.f32 f472, f454, f458;
sub.f32 f473, f446, f450;
sub.f32 f474, f454, f458;
add.f32 %0, f459, f463;
add.f32 %1, f460, f464;
add.f32 %2, f467, f471;
add.f32 %3, f468, f472;
sub.f32 %5, f462, f465;
add.f32 %4, f461, f466;
sub.f32 %7, f470, f473;
add.f32 %6, f469, f474;
sub.f32 %8, f459, f463;
sub.f32 %9, f460, f464;
sub.f32 %10, f467, f471;
sub.f32 %11, f468, f472;
add.f32 %13, f462, f465;
sub.f32 %12, f461, f466;
add.f32 %15, f470, f473;
sub.f32 %14, f469, f474;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y), "=f"(rmem[2].x), "=f"(rmem[2].y), "=f"(rmem[3].x), "=f"(rmem[3].y), "=f"(rmem[4].x), "=f"(rmem[4].y), "=f"(rmem[5].x), "=f"(rmem[5].y), "=f"(rmem[6].x), "=f"(rmem[6].y), "=f"(rmem[7].x), "=f"(rmem[7].y): "r"(smem), "l"(lut_sp_8_2048), "l"(lut_sp_8_256), "l"(lut_sp_8_32), "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y), "f"(rmem[1].y), "f"(rmem[2].x), "f"(rmem[2].y), "f"(rmem[2].y), "f"(rmem[3].x), "f"(rmem[3].y), "f"(rmem[4].x), "f"(rmem[4].y), "f"(rmem[4].y), "f"(rmem[5].x), "f"(rmem[5].y), "f"(rmem[5].y), "f"(rmem[6].x), "f"(rmem[6].y), "f"(rmem[7].x), "f"(rmem[7].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<92, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<539>;
.reg .b32 r<27>;
.reg .b64 rd<12>;
mov.u32 r1, %tid.y;
shl.b32 r2, r1, 14;
mov.u32 r3, %16;
add.s32 r4, r3, r2;
mov.u32 r5, %tid.x;
add.f32 f33, %20, %30;
add.f32 f34, %21, %32;
sub.f32 f35, %20, %30;
sub.f32 f36, %21, %32;
add.f32 f37, %25, %36;
add.f32 f38, %27, %37;
sub.f32 f39, %25, %36;
sub.f32 f40, %27, %37;
add.f32 f41, f33, f37;
add.f32 f42, f34, f38;
sub.f32 f43, f33, f37;
sub.f32 f44, f34, f38;
add.f32 f45, f35, f40;
sub.f32 f46, f36, f39;
sub.f32 f47, f35, f40;
add.f32 f48, f36, f39;
add.f32 f49, %22, %33;
add.f32 f50, %24, %35;
sub.f32 f51, %22, %33;
sub.f32 f52, %24, %35;
add.f32 f53, %28, %38;
add.f32 f54, %29, %39;
sub.f32 f55, %28, %38;
sub.f32 f56, %29, %39;
add.f32 f57, f49, f53;
add.f32 f58, f50, f54;
sub.f32 f59, f49, f53;
sub.f32 f60, f50, f54;
add.f32 f61, f51, f56;
sub.f32 f62, f52, f55;
sub.f32 f63, f51, f56;
add.f32 f64, f52, f55;
mul.f32 f65, f61, 0f3F3504F3;
mul.f32 f66, f62, 0fBF3504F3;
sub.f32 f67, f65, f66;
mul.f32 f68, f62, 0f3F3504F3;
fma.rn.f32 f69, f61, 0fBF3504F3, f68;
mul.f32 f70, f63, 0fBF3504F3;
mul.f32 f71, f64, 0fBF3504F3;
sub.f32 f72, f70, f71;
add.f32 f73, f70, f71;
sub.f32 f74, f41, f57;
sub.f32 f75, f42, f58;
add.f32 f76, f45, f67;
add.f32 f77, f46, f69;
sub.f32 f78, f45, f67;
sub.f32 f79, f46, f69;
add.f32 f80, f43, f60;
sub.f32 f81, f44, f59;
sub.f32 f82, f43, f60;
add.f32 f83, f44, f59;
add.f32 f84, f47, f72;
add.f32 f85, f48, f73;
sub.f32 f86, f47, f72;
sub.f32 f87, f48, f73;
and.b32 r6, r5, 255;
shl.b32 r7, r5, 6;
and.b32 r8, r7, -16384;
add.s32 r9, r4, r8;
shl.b32 r10, r5, 3;
cvt.u64.u32 rd2, r10;
and.b64 rd3, rd2, 2040;
mov.u64 rd4, %17;
add.s64 rd5, rd4, rd3;
ld.global.v2.f32 {f88, f89}, [rd5];
mul.f32 f92, f88, f76;
mul.f32 f93, f89, f77;
mul.f32 f94, f88, f77;
mul.f32 f95, f88, f88;
mul.f32 f96, f89, f89;
sub.f32 f97, f95, f96;
mul.f32 f98, f89, f88;
fma.rn.f32 f99, f89, f88, f98;
mul.f32 f100, f97, f80;
mul.f32 f101, f99, f81;
mul.f32 f102, f97, f81;
mul.f32 f103, f88, f97;
mul.f32 f104, f89, f99;
sub.f32 f105, f103, f104;
mul.f32 f106, f88, f99;
fma.rn.f32 f107, f89, f97, f106;
mul.f32 f108, f105, f84;
mul.f32 f109, f107, f85;
mul.f32 f110, f105, f85;
mul.f32 f111, f88, f105;
mul.f32 f112, f89, f107;
sub.f32 f113, f111, f112;
mul.f32 f114, f88, f107;
fma.rn.f32 f115, f89, f105, f114;
mul.f32 f116, f113, f74;
mul.f32 f117, f115, f75;
mul.f32 f118, f113, f75;
mul.f32 f119, f88, f113;
mul.f32 f120, f89, f115;
sub.f32 f121, f119, f120;
mul.f32 f122, f88, f115;
fma.rn.f32 f123, f89, f113, f122;
mul.f32 f124, f121, f78;
mul.f32 f125, f123, f79;
mul.f32 f126, f121, f79;
mul.f32 f127, f88, f121;
mul.f32 f128, f89, f123;
sub.f32 f129, f127, f128;
mul.f32 f130, f88, f123;
fma.rn.f32 f131, f89, f121, f130;
mul.f32 f132, f129, f82;
mul.f32 f133, f131, f83;
mul.f32 f134, f129, f83;
mul.f32 f135, f88, f129;
mul.f32 f136, f89, f131;
sub.f32 f137, f135, f136;
mul.f32 f138, f88, f131;
fma.rn.f32 f139, f89, f129, f138;
mul.f32 f140, f137, f86;
mul.f32 f141, f139, f87;
mul.f32 f142, f137, f87;
barrier.sync 0;
and.b32 r11, r7, 16320;
add.s32 r12, r9, r11;
add.f32 f143, f42, f58;
add.f32 f144, f41, f57;
fma.rn.f32 f145, f89, f76, f94;
sub.f32 f146, f92, f93;
st.shared.v4.f32 [r12], {f144, f143, f146, f145};
fma.rn.f32 f147, f99, f80, f102;
sub.f32 f148, f100, f101;
sub.f32 f149, f108, f109;
fma.rn.f32 f150, f107, f84, f110;
st.shared.v4.f32 [r12+16], {f148, f147, f149, f150};
fma.rn.f32 f151, f115, f74, f118;
sub.f32 f152, f116, f117;
fma.rn.f32 f153, f123, f78, f126;
sub.f32 f154, f124, f125;
st.shared.v4.f32 [r12+32], {f152, f151, f154, f153};
fma.rn.f32 f155, f131, f82, f134;
sub.f32 f156, f132, f133;
fma.rn.f32 f157, f139, f86, f142;
sub.f32 f158, f140, f141;
st.shared.v4.f32 [r12+48], {f156, f155, f158, f157};
barrier.sync 0;
mad.lo.s32 r13, r6, -56, r12;
ld.shared.v2.f32 {f159, f160}, [r13];
ld.shared.v2.f32 {f163, f164}, [r13+2048];
ld.shared.v2.f32 {f167, f168}, [r13+4096];
ld.shared.v2.f32 {f171, f172}, [r13+6144];
ld.shared.v2.f32 {f175, f176}, [r13+8192];
ld.shared.v2.f32 {f179, f180}, [r13+10240];
ld.shared.v2.f32 {f183, f184}, [r13+12288];
ld.shared.v2.f32 {f187, f188}, [r13+14336];
add.f32 f191, f159, f175;
add.f32 f192, f160, f176;
sub.f32 f193, f159, f175;
sub.f32 f194, f160, f176;
add.f32 f195, f167, f183;
add.f32 f196, f168, f184;
sub.f32 f197, f167, f183;
sub.f32 f198, f168, f184;
add.f32 f199, f191, f195;
add.f32 f200, f192, f196;
sub.f32 f201, f191, f195;
sub.f32 f202, f192, f196;
add.f32 f203, f193, f198;
sub.f32 f204, f194, f197;
sub.f32 f205, f193, f198;
add.f32 f206, f194, f197;
add.f32 f207, f163, f179;
add.f32 f208, f164, f180;
sub.f32 f209, f163, f179;
sub.f32 f210, f164, f180;
add.f32 f211, f171, f187;
add.f32 f212, f172, f188;
sub.f32 f213, f171, f187;
sub.f32 f214, f172, f188;
add.f32 f215, f207, f211;
add.f32 f216, f208, f212;
sub.f32 f217, f207, f211;
sub.f32 f218, f208, f212;
add.f32 f219, f209, f214;
sub.f32 f220, f210, f213;
sub.f32 f221, f209, f214;
add.f32 f222, f210, f213;
mul.f32 f223, f219, 0f3F3504F3;
mul.f32 f224, f220, 0fBF3504F3;
sub.f32 f225, f223, f224;
mul.f32 f226, f220, 0f3F3504F3;
fma.rn.f32 f227, f219, 0fBF3504F3, f226;
mul.f32 f228, f221, 0fBF3504F3;
mul.f32 f229, f222, 0fBF3504F3;
sub.f32 f230, f228, f229;
add.f32 f231, f228, f229;
sub.f32 f232, f199, f215;
sub.f32 f233, f200, f216;
add.f32 f234, f203, f225;
add.f32 f235, f204, f227;
sub.f32 f236, f203, f225;
sub.f32 f237, f204, f227;
add.f32 f238, f201, f218;
sub.f32 f239, f202, f217;
sub.f32 f240, f201, f218;
add.f32 f241, f202, f217;
add.f32 f242, f205, f230;
add.f32 f243, f206, f231;
sub.f32 f244, f205, f230;
sub.f32 f245, f206, f231;
and.b32 r14, r5, 248;
cvt.u64.u32 rd6, r14;
mov.u64 rd7, %18;
add.s64 rd8, rd7, rd6;
ld.global.v2.f32 {f246, f247}, [rd8];
mul.f32 f250, f246, f234;
mul.f32 f251, f247, f235;
mul.f32 f252, f246, f235;
mul.f32 f253, f246, f246;
mul.f32 f254, f247, f247;
sub.f32 f255, f253, f254;
mul.f32 f256, f247, f246;
fma.rn.f32 f257, f247, f246, f256;
mul.f32 f258, f255, f238;
mul.f32 f259, f257, f239;
mul.f32 f260, f255, f239;
mul.f32 f261, f246, f255;
mul.f32 f262, f247, f257;
sub.f32 f263, f261, f262;
mul.f32 f264, f246, f257;
fma.rn.f32 f265, f247, f255, f264;
mul.f32 f266, f263, f242;
mul.f32 f267, f265, f243;
mul.f32 f268, f263, f243;
mul.f32 f269, f246, f263;
mul.f32 f270, f247, f265;
sub.f32 f271, f269, f270;
mul.f32 f272, f246, f265;
fma.rn.f32 f273, f247, f263, f272;
mul.f32 f274, f271, f232;
mul.f32 f275, f273, f233;
mul.f32 f276, f271, f233;
mul.f32 f277, f246, f271;
mul.f32 f278, f247, f273;
sub.f32 f279, f277, f278;
mul.f32 f280, f246, f273;
fma.rn.f32 f281, f247, f271, f280;
mul.f32 f282, f279, f236;
mul.f32 f283, f281, f237;
mul.f32 f284, f279, f237;
mul.f32 f285, f246, f279;
mul.f32 f286, f247, f281;
sub.f32 f287, f285, f286;
mul.f32 f288, f246, f281;
fma.rn.f32 f289, f247, f279, f288;
mul.f32 f290, f287, f240;
mul.f32 f291, f289, f241;
mul.f32 f292, f287, f241;
mul.f32 f293, f246, f287;
mul.f32 f294, f247, f289;
sub.f32 f295, f293, f294;
mul.f32 f296, f246, f289;
fma.rn.f32 f297, f247, f287, f296;
mul.f32 f298, f295, f244;
mul.f32 f299, f297, f245;
mul.f32 f300, f295, f245;
and.b32 r15, r10, 56;
add.s32 r16, r9, r15;
barrier.sync 0;
and.b32 r17, r7, 15872;
add.s32 r18, r16, r17;
add.f32 f301, f200, f216;
add.f32 f302, f199, f215;
st.shared.v2.f32 [r18], {f302, f301};
fma.rn.f32 f303, f247, f234, f252;
sub.f32 f304, f250, f251;
st.shared.v2.f32 [r18+64], {f304, f303};
fma.rn.f32 f305, f257, f238, f260;
sub.f32 f306, f258, f259;
st.shared.v2.f32 [r18+128], {f306, f305};
fma.rn.f32 f307, f265, f242, f268;
sub.f32 f308, f266, f267;
st.shared.v2.f32 [r18+192], {f308, f307};
sub.f32 f309, f274, f275;
fma.rn.f32 f310, f273, f232, f276;
st.shared.v2.f32 [r18+256], {f309, f310};
fma.rn.f32 f311, f281, f236, f284;
sub.f32 f312, f282, f283;
st.shared.v2.f32 [r18+320], {f312, f311};
fma.rn.f32 f313, f289, f240, f292;
sub.f32 f314, f290, f291;
st.shared.v2.f32 [r18+384], {f314, f313};
fma.rn.f32 f315, f297, f244, f300;
sub.f32 f316, f298, f299;
st.shared.v2.f32 [r18+448], {f316, f315};
barrier.sync 0;
mad.lo.s32 r19, r14, -56, r18;
ld.shared.v2.f32 {f317, f318}, [r19];
ld.shared.v2.f32 {f321, f322}, [r19+2048];
ld.shared.v2.f32 {f325, f326}, [r19+4096];
ld.shared.v2.f32 {f329, f330}, [r19+6144];
ld.shared.v2.f32 {f333, f334}, [r19+8192];
ld.shared.v2.f32 {f337, f338}, [r19+10240];
ld.shared.v2.f32 {f341, f342}, [r19+12288];
ld.shared.v2.f32 {f345, f346}, [r19+14336];
add.f32 f349, f317, f333;
add.f32 f350, f318, f334;
sub.f32 f351, f317, f333;
sub.f32 f352, f318, f334;
add.f32 f353, f325, f341;
add.f32 f354, f326, f342;
sub.f32 f355, f325, f341;
sub.f32 f356, f326, f342;
add.f32 f357, f349, f353;
add.f32 f358, f350, f354;
sub.f32 f359, f349, f353;
sub.f32 f360, f350, f354;
add.f32 f361, f351, f356;
sub.f32 f362, f352, f355;
sub.f32 f363, f351, f356;
add.f32 f364, f352, f355;
add.f32 f365, f321, f337;
add.f32 f366, f322, f338;
sub.f32 f367, f321, f337;
sub.f32 f368, f322, f338;
add.f32 f369, f329, f345;
add.f32 f370, f330, f346;
sub.f32 f371, f329, f345;
sub.f32 f372, f330, f346;
add.f32 f373, f365, f369;
add.f32 f374, f366, f370;
sub.f32 f375, f365, f369;
sub.f32 f376, f366, f370;
add.f32 f377, f367, f372;
sub.f32 f378, f368, f371;
sub.f32 f379, f367, f372;
add.f32 f380, f368, f371;
mul.f32 f381, f377, 0f3F3504F3;
mul.f32 f382, f378, 0fBF3504F3;
sub.f32 f383, f381, f382;
mul.f32 f384, f378, 0f3F3504F3;
fma.rn.f32 f385, f377, 0fBF3504F3, f384;
mul.f32 f386, f379, 0fBF3504F3;
mul.f32 f387, f380, 0fBF3504F3;
sub.f32 f388, f386, f387;
add.f32 f389, f386, f387;
sub.f32 f390, f357, f373;
sub.f32 f391, f358, f374;
add.f32 f392, f361, f383;
add.f32 f393, f362, f385;
sub.f32 f394, f361, f383;
sub.f32 f395, f362, f385;
add.f32 f396, f359, f376;
sub.f32 f397, f360, f375;
sub.f32 f398, f359, f376;
add.f32 f399, f360, f375;
add.f32 f400, f363, f388;
add.f32 f401, f364, f389;
sub.f32 f402, f363, f388;
sub.f32 f403, f364, f389;
and.b32 r20, r5, 192;
bfe.u32 r21, r5, 6, 2;
mul.wide.u32 rd9, r21, 8;
mov.u64 rd10, %19;
add.s64 rd11, rd10, rd9;
ld.global.v2.f32 {f404, f405}, [rd11];
mul.f32 f408, f404, f392;
mul.f32 f409, f405, f393;
mul.f32 f410, f404, f393;
mul.f32 f411, f404, f404;
mul.f32 f412, f405, f405;
sub.f32 f413, f411, f412;
mul.f32 f414, f405, f404;
fma.rn.f32 f415, f405, f404, f414;
mul.f32 f416, f413, f396;
mul.f32 f417, f415, f397;
mul.f32 f418, f413, f397;
mul.f32 f419, f404, f413;
mul.f32 f420, f405, f415;
sub.f32 f421, f419, f420;
mul.f32 f422, f404, f415;
fma.rn.f32 f423, f405, f413, f422;
mul.f32 f424, f421, f400;
mul.f32 f425, f423, f401;
mul.f32 f426, f421, f401;
mul.f32 f427, f404, f421;
mul.f32 f428, f405, f423;
sub.f32 f429, f427, f428;
mul.f32 f430, f404, f423;
fma.rn.f32 f431, f405, f421, f430;
mul.f32 f432, f429, f390;
mul.f32 f433, f431, f391;
mul.f32 f434, f429, f391;
mul.f32 f435, f404, f429;
mul.f32 f436, f405, f431;
sub.f32 f437, f435, f436;
mul.f32 f438, f404, f431;
fma.rn.f32 f439, f405, f429, f438;
mul.f32 f440, f437, f394;
mul.f32 f441, f439, f395;
mul.f32 f442, f437, f395;
mul.f32 f443, f404, f437;
mul.f32 f444, f405, f439;
sub.f32 f445, f443, f444;
mul.f32 f446, f404, f439;
fma.rn.f32 f447, f405, f437, f446;
mul.f32 f448, f445, f398;
mul.f32 f449, f447, f399;
mul.f32 f450, f445, f399;
mul.f32 f451, f404, f445;
mul.f32 f452, f405, f447;
sub.f32 f453, f451, f452;
mul.f32 f454, f404, f447;
fma.rn.f32 f455, f405, f445, f454;
mul.f32 f456, f453, f402;
mul.f32 f457, f455, f403;
mul.f32 f458, f453, f403;
and.b32 r22, r10, 504;
add.s32 r23, r9, r22;
barrier.sync 0;
and.b32 r24, r7, 12288;
add.s32 r25, r23, r24;
add.f32 f459, f358, f374;
add.f32 f460, f357, f373;
st.shared.v2.f32 [r25], {f460, f459};
fma.rn.f32 f461, f405, f392, f410;
sub.f32 f462, f408, f409;
st.shared.v2.f32 [r25+512], {f462, f461};
fma.rn.f32 f463, f415, f396, f418;
sub.f32 f464, f416, f417;
st.shared.v2.f32 [r25+1024], {f464, f463};
fma.rn.f32 f465, f423, f400, f426;
sub.f32 f466, f424, f425;
st.shared.v2.f32 [r25+1536], {f466, f465};
sub.f32 f467, f432, f433;
fma.rn.f32 f468, f431, f390, f434;
st.shared.v2.f32 [r25+2048], {f467, f468};
fma.rn.f32 f469, f439, f394, f442;
sub.f32 f470, f440, f441;
st.shared.v2.f32 [r25+2560], {f470, f469};
fma.rn.f32 f471, f447, f398, f450;
sub.f32 f472, f448, f449;
st.shared.v2.f32 [r25+3072], {f472, f471};
fma.rn.f32 f473, f455, f402, f458;
sub.f32 f474, f456, f457;
st.shared.v2.f32 [r25+3584], {f474, f473};
barrier.sync 0;
mad.lo.s32 r26, r20, -56, r25;
ld.shared.v2.f32 {f475, f476}, [r26];
ld.shared.v2.f32 {f479, f480}, [r26+2048];
ld.shared.v2.f32 {f483, f484}, [r26+4096];
ld.shared.v2.f32 {f487, f488}, [r26+6144];
ld.shared.v2.f32 {f491, f492}, [r26+8192];
ld.shared.v2.f32 {f495, f496}, [r26+10240];
ld.shared.v2.f32 {f499, f500}, [r26+12288];
ld.shared.v2.f32 {f503, f504}, [r26+14336];
add.f32 f507, f475, f491;
add.f32 f508, f476, f492;
sub.f32 f509, f475, f491;
sub.f32 f510, f476, f492;
add.f32 f511, f483, f499;
add.f32 f512, f484, f500;
sub.f32 f513, f483, f499;
sub.f32 f514, f484, f500;
add.f32 f515, f479, f495;
add.f32 f516, f480, f496;
sub.f32 f517, f479, f495;
sub.f32 f518, f480, f496;
add.f32 f519, f487, f503;
add.f32 f520, f488, f504;
sub.f32 f521, f487, f503;
sub.f32 f522, f488, f504;
add.f32 %1, f508, f512;
add.f32 %0, f507, f511;
add.f32 %3, f516, f520;
add.f32 %2, f515, f519;
sub.f32 %5, f510, f513;
add.f32 %4, f509, f514;
sub.f32 %7, f518, f521;
add.f32 %6, f517, f522;
sub.f32 %9, f508, f512;
sub.f32 %8, f507, f511;
sub.f32 %11, f516, f520;
sub.f32 %10, f515, f519;
add.f32 %13, f510, f513;
sub.f32 %12, f509, f514;
add.f32 %15, f518, f521;
sub.f32 %14, f517, f522;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y), "=f"(rmem[2].x), "=f"(rmem[2].y), "=f"(rmem[3].x), "=f"(rmem[3].y), "=f"(rmem[4].x), "=f"(rmem[4].y), "=f"(rmem[5].x), "=f"(rmem[5].y), "=f"(rmem[6].x), "=f"(rmem[6].y), "=f"(rmem[7].x), "=f"(rmem[7].y): "r"(smem), "l"(lut_sp_8_2048), "l"(lut_sp_8_256), "l"(lut_sp_8_32), "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y), "f"(rmem[1].y), "f"(rmem[2].x), "f"(rmem[2].y), "f"(rmem[2].y), "f"(rmem[3].x), "f"(rmem[3].y), "f"(rmem[4].x), "f"(rmem[4].y), "f"(rmem[4].y), "f"(rmem[5].x), "f"(rmem[5].y), "f"(rmem[5].y), "f"(rmem[6].x), "f"(rmem[6].y), "f"(rmem[7].x), "f"(rmem[7].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<94, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<1162>;
.reg .b32 r<36>;
.reg .b64 rd<12>;
mov.u32 r1, %tid.y;
shl.b32 r2, r1, 14;
mov.u32 r3, %32;
add.s32 r4, r3, r2;
add.f32 f65, %35, %51;
sub.f32 f67, %35, %51;
add.f32 f1151, %36, %67;
sub.f32 f68, %36, %67;
add.f32 f69, %43, %59;
sub.f32 f71, %43, %59;
add.f32 f1149, %68, %60;
sub.f32 f72, %68, %60;
add.f32 f73, f65, f69;
sub.f32 f75, f65, f69;
add.f32 f1148, f1151, f1149;
sub.f32 f76, f1151, f1149;
add.f32 f77, f67, f72;
sub.f32 f79, f67, f72;
sub.f32 f1147, f68, f71;
add.f32 f80, f68, f71;
add.f32 f81, %39, %55;
sub.f32 f83, %39, %55;
add.f32 f1144, %70, %69;
sub.f32 f84, %70, %69;
add.f32 f85, %47, %63;
sub.f32 f87, %47, %63;
add.f32 f1142, %48, %71;
sub.f32 f88, %48, %71;
add.f32 f89, f81, f85;
sub.f32 f91, f81, f85;
add.f32 f1141, f1144, f1142;
sub.f32 f92, f1144, f1142;
add.f32 f93, f83, f88;
sub.f32 f95, f83, f88;
sub.f32 f1140, f84, f87;
add.f32 f96, f84, f87;
mul.f32 f98, f1140, 0fBF3504F3;
mul.f32 f1139, f93, 0f3F3504F3;
sub.f32 f99, f1139, f98;
mul.f32 f100, f1140, 0f3F3504F3;
fma.rn.f32 f101, f93, 0fBF3504F3, f100;
mul.f32 f102, f95, 0fBF3504F3;
mul.f32 f103, f96, 0fBF3504F3;
sub.f32 f104, f102, f103;
add.f32 f105, f102, f103;
add.f32 f106, f73, f89;
sub.f32 f108, f73, f89;
add.f32 f1138, f1148, f1141;
sub.f32 f109, f1148, f1141;
add.f32 f110, f77, f99;
sub.f32 f112, f77, f99;
add.f32 f1137, f1147, f101;
sub.f32 f113, f1147, f101;
add.f32 f114, f75, f92;
sub.f32 f116, f75, f92;
sub.f32 f1136, f76, f91;
add.f32 f117, f76, f91;
add.f32 f118, f79, f104;
sub.f32 f120, f79, f104;
add.f32 f1135, f80, f105;
sub.f32 f121, f80, f105;
add.f32 f122, %37, %53;
sub.f32 f124, %37, %53;
add.f32 f1133, %72, %54;
sub.f32 f125, %72, %54;
add.f32 f126, %45, %61;
sub.f32 f128, %45, %61;
add.f32 f1130, %73, %74;
sub.f32 f129, %73, %74;
add.f32 f130, f122, f126;
sub.f32 f132, f122, f126;
add.f32 f1129, f1133, f1130;
sub.f32 f133, f1133, f1130;
add.f32 f134, f124, f129;
sub.f32 f136, f124, f129;
sub.f32 f1128, f125, f128;
add.f32 f137, f125, f128;
add.f32 f138, %41, %57;
sub.f32 f140, %41, %57;
add.f32 f1126, %42, %75;
sub.f32 f141, %42, %75;
add.f32 f142, %49, %65;
sub.f32 f144, %49, %65;
add.f32 f1124, %76, %66;
sub.f32 f145, %76, %66;
add.f32 f146, f138, f142;
sub.f32 f148, f138, f142;
add.f32 f1123, f1126, f1124;
sub.f32 f149, f1126, f1124;
add.f32 f150, f140, f145;
sub.f32 f152, f140, f145;
sub.f32 f1122, f141, f144;
add.f32 f153, f141, f144;
mul.f32 f155, f1122, 0fBF3504F3;
mul.f32 f1121, f150, 0f3F3504F3;
sub.f32 f156, f1121, f155;
mul.f32 f157, f1122, 0f3F3504F3;
fma.rn.f32 f158, f150, 0fBF3504F3, f157;
mul.f32 f159, f152, 0fBF3504F3;
mul.f32 f160, f153, 0fBF3504F3;
sub.f32 f161, f159, f160;
add.f32 f162, f159, f160;
add.f32 f163, f130, f146;
sub.f32 f165, f130, f146;
add.f32 f1120, f1129, f1123;
sub.f32 f166, f1129, f1123;
add.f32 f167, f134, f156;
sub.f32 f169, f134, f156;
add.f32 f1119, f1128, f158;
sub.f32 f170, f1128, f158;
add.f32 f171, f132, f149;
sub.f32 f173, f132, f149;
sub.f32 f1118, f133, f148;
add.f32 f174, f133, f148;
add.f32 f175, f136, f161;
sub.f32 f177, f136, f161;
add.f32 f1117, f137, f162;
sub.f32 f178, f137, f162;
mul.f32 f1115, f167, 0f3F6C835E;
mul.f32 f1116, f1119, 0fBEC3EF15;
sub.f32 f181, f1115, f1116;
mul.f32 f182, f1119, 0f3F6C835E;
fma.rn.f32 f183, f167, 0fBEC3EF15, f182;
mul.f32 f1113, f171, 0f3F3504F3;
mul.f32 f1114, f1118, 0fBF3504F3;
sub.f32 f186, f1113, f1114;
mul.f32 f187, f1118, 0f3F3504F3;
fma.rn.f32 f188, f171, 0fBF3504F3, f187;
mul.f32 f1111, f175, 0f3EC3EF15;
mul.f32 f1112, f1117, 0fBF6C835E;
sub.f32 f191, f1111, f1112;
mul.f32 f192, f1117, 0f3EC3EF15;
fma.rn.f32 f193, f175, 0fBF6C835E, f192;
mul.f32 f1109, f169, 0fBEC3EF15;
mul.f32 f1110, f170, 0fBF6C835E;
sub.f32 f196, f1109, f1110;
mul.f32 f197, f170, 0fBEC3EF15;
fma.rn.f32 f198, f169, 0fBF6C835E, f197;
mul.f32 f199, f173, 0fBF3504F3;
mul.f32 f200, f174, 0fBF3504F3;
sub.f32 f201, f199, f200;
add.f32 f202, f199, f200;
mul.f32 f1107, f177, 0fBF6C835E;
mul.f32 f1108, f178, 0fBEC3EF15;
sub.f32 f205, f1107, f1108;
mul.f32 f206, f178, 0fBF6C835E;
fma.rn.f32 f207, f177, 0fBEC3EF15, f206;
add.f32 f210, f110, f181;
sub.f32 f212, f110, f181;
add.f32 f1106, f1137, f183;
sub.f32 f213, f1137, f183;
add.f32 f214, f114, f186;
sub.f32 f216, f114, f186;
add.f32 f1105, f1136, f188;
sub.f32 f217, f1136, f188;
add.f32 f218, f118, f191;
sub.f32 f220, f118, f191;
add.f32 f1104, f1135, f193;
sub.f32 f221, f1135, f193;
add.f32 f222, f108, f166;
sub.f32 f224, f108, f166;
sub.f32 f1103, f109, f165;
add.f32 f225, f109, f165;
add.f32 f226, f112, f196;
sub.f32 f228, f112, f196;
add.f32 f1102, f113, f198;
sub.f32 f229, f113, f198;
add.f32 f230, f116, f201;
sub.f32 f232, f116, f201;
add.f32 f1101, f117, f202;
sub.f32 f233, f117, f202;
add.f32 f234, f120, f205;
sub.f32 f236, f120, f205;
add.f32 f1100, f121, f207;
sub.f32 f237, f121, f207;
mov.u32 r22, %tid.x;
shl.b32 r7, r22, 7;
and.b32 r8, r7, -16384;
add.s32 r9, r4, r8;
shl.b32 r10, r22, 3;
cvt.u64.u32 rd2, r10;
and.b64 rd3, rd2, 1016;
mov.u64 rd4, %33;
add.s64 rd5, rd4, rd3;
ld.global.v2.f32 {f238, f239}, [rd5];
mul.f32 f243, f239, f1106;
mul.f32 f244, f238, f1106;
mul.f32 f246, f239, f239;
mul.f32 f1099, f238, f238;
sub.f32 f247, f1099, f246;
mul.f32 f248, f239, f238;
fma.rn.f32 f249, f239, f238, f248;
mul.f32 f251, f249, f1105;
mul.f32 f252, f247, f1105;
mul.f32 f1097, f238, f247;
mul.f32 f1098, f239, f249;
sub.f32 f255, f1097, f1098;
mul.f32 f1096, f247, f214;
mul.f32 f256, f238, f249;
fma.rn.f32 f257, f239, f247, f256;
mul.f32 f259, f257, f1104;
mul.f32 f260, f255, f1104;
mul.f32 f262, f239, f257;
mul.f32 f1095, f238, f255;
sub.f32 f263, f1095, f262;
mul.f32 f1094, f255, f218;
mul.f32 f264, f238, f257;
fma.rn.f32 f265, f239, f255, f264;
mul.f32 f267, f265, f1103;
mul.f32 f268, f263, f1103;
mul.f32 f270, f239, f265;
mul.f32 f1093, f238, f263;
sub.f32 f271, f1093, f270;
mul.f32 f1092, f263, f222;
mul.f32 f272, f238, f265;
fma.rn.f32 f273, f239, f263, f272;
mul.f32 f275, f273, f1102;
mul.f32 f276, f271, f1102;
mul.f32 f1090, f238, f271;
mul.f32 f1091, f239, f273;
sub.f32 f279, f1090, f1091;
mul.f32 f1089, f271, f226;
mul.f32 f280, f238, f273;
fma.rn.f32 f281, f239, f271, f280;
mul.f32 f283, f281, f1101;
mul.f32 f284, f279, f1101;
mul.f32 f286, f239, f281;
mul.f32 f1088, f238, f279;
sub.f32 f287, f1088, f286;
mul.f32 f1087, f279, f230;
mul.f32 f288, f238, f281;
fma.rn.f32 f289, f239, f279, f288;
mul.f32 f291, f289, f1100;
mul.f32 f292, f287, f1100;
mul.f32 f294, f239, f289;
mul.f32 f1086, f238, f287;
sub.f32 f295, f1086, f294;
mul.f32 f1085, f287, f234;
mul.f32 f296, f238, f289;
fma.rn.f32 f297, f239, f287, f296;
sub.f32 f1084, f1138, f1120;
mul.f32 f299, f297, f1084;
mul.f32 f300, f295, f1084;
mul.f32 f1082, f238, f295;
mul.f32 f1083, f239, f297;
sub.f32 f303, f1082, f1083;
sub.f32 f1081, f106, f163;
mul.f32 f1080, f295, f1081;
mul.f32 f304, f238, f297;
fma.rn.f32 f305, f239, f295, f304;
mul.f32 f307, f305, f213;
mul.f32 f308, f303, f213;
mul.f32 f310, f239, f305;
mul.f32 f1079, f238, f303;
sub.f32 f311, f1079, f310;
mul.f32 f1078, f303, f212;
mul.f32 f312, f238, f305;
fma.rn.f32 f313, f239, f303, f312;
mul.f32 f315, f313, f217;
mul.f32 f316, f311, f217;
mul.f32 f1076, f238, f311;
mul.f32 f1077, f239, f313;
sub.f32 f319, f1076, f1077;
mul.f32 f1075, f311, f216;
mul.f32 f320, f238, f313;
fma.rn.f32 f321, f239, f311, f320;
mul.f32 f323, f321, f221;
mul.f32 f324, f319, f221;
mul.f32 f326, f239, f321;
mul.f32 f1074, f238, f319;
sub.f32 f327, f1074, f326;
mul.f32 f1073, f319, f220;
mul.f32 f328, f238, f321;
fma.rn.f32 f329, f239, f319, f328;
mul.f32 f331, f329, f225;
mul.f32 f332, f327, f225;
mul.f32 f334, f239, f329;
mul.f32 f1072, f238, f327;
sub.f32 f335, f1072, f334;
mul.f32 f1071, f327, f224;
mul.f32 f336, f238, f329;
fma.rn.f32 f337, f239, f327, f336;
mul.f32 f339, f337, f229;
mul.f32 f340, f335, f229;
mul.f32 f1069, f238, f335;
mul.f32 f1070, f239, f337;
sub.f32 f343, f1069, f1070;
mul.f32 f1068, f335, f228;
mul.f32 f344, f238, f337;
fma.rn.f32 f345, f239, f335, f344;
mul.f32 f347, f345, f233;
mul.f32 f348, f343, f233;
mul.f32 f350, f239, f345;
mul.f32 f1067, f238, f343;
sub.f32 f351, f1067, f350;
mul.f32 f1066, f238, f210;
mul.f32 f352, f238, f345;
mul.f32 f1065, f343, f232;
fma.rn.f32 f353, f239, f343, f352;
mul.f32 f354, f351, f236;
mul.f32 f355, f353, f237;
mul.f32 f356, f351, f237;
sub.f32 f1159, f1138, f1120;
mul.f32 f1158, f297, f1159;
barrier.sync 0;
and.b32 r11, r7, 16256;
add.s32 r12, r9, r11;
add.f32 f357, f1138, f1120;
sub.f32 f1157, f106, f163;
add.f32 f358, f106, f163;
mov.u32 r35, %tid.x;
fma.rn.f32 f359, f239, f210, f244;
sub.f32 f360, f1066, f243;
st.shared.v4.f32 [r12], {f358, f357, f360, f359};
fma.rn.f32 f361, f249, f214, f252;
sub.f32 f362, f1096, f251;
fma.rn.f32 f363, f257, f218, f260;
sub.f32 f364, f1094, f259;
st.shared.v4.f32 [r12+16], {f362, f361, f364, f363};
sub.f32 f365, f1092, f267;
fma.rn.f32 f366, f265, f222, f268;
fma.rn.f32 f367, f273, f226, f276;
sub.f32 f368, f1089, f275;
st.shared.v4.f32 [r12+32], {f365, f366, f368, f367};
fma.rn.f32 f369, f281, f230, f284;
sub.f32 f370, f1087, f283;
fma.rn.f32 f371, f289, f234, f292;
sub.f32 f372, f1085, f291;
st.shared.v4.f32 [r12+48], {f370, f369, f372, f371};
fma.rn.f32 f373, f297, f1157, f300;
sub.f32 f374, f1080, f1158;
fma.rn.f32 f375, f305, f212, f308;
sub.f32 f376, f1078, f307;
st.shared.v4.f32 [r12+64], {f374, f373, f376, f375};
fma.rn.f32 f377, f313, f216, f316;
sub.f32 f378, f1075, f315;
fma.rn.f32 f379, f321, f220, f324;
sub.f32 f380, f1073, f323;
st.shared.v4.f32 [r12+80], {f378, f377, f380, f379};
fma.rn.f32 f381, f329, f224, f332;
sub.f32 f382, f1071, f331;
fma.rn.f32 f383, f337, f228, f340;
sub.f32 f384, f1068, f339;
st.shared.v4.f32 [r12+96], {f382, f381, f384, f383};
fma.rn.f32 f385, f345, f232, f348;
sub.f32 f386, f1065, f347;
fma.rn.f32 f387, f353, f236, f356;
sub.f32 f388, f354, f355;
st.shared.v4.f32 [r12+112], {f386, f385, f388, f387};
barrier.sync 0;
and.b32 r21, r35, 127;
mad.lo.s32 r13, r21, -120, r12;
ld.shared.v2.f32 {f389, f390}, [r13];
ld.shared.v2.f32 {f393, f394}, [r13+1024];
ld.shared.v2.f32 {f397, f398}, [r13+2048];
ld.shared.v2.f32 {f401, f402}, [r13+3072];
ld.shared.v2.f32 {f405, f406}, [r13+4096];
ld.shared.v2.f32 {f409, f410}, [r13+5120];
ld.shared.v2.f32 {f413, f414}, [r13+6144];
ld.shared.v2.f32 {f417, f418}, [r13+7168];
ld.shared.v2.f32 {f421, f422}, [r13+8192];
ld.shared.v2.f32 {f425, f426}, [r13+9216];
ld.shared.v2.f32 {f429, f430}, [r13+10240];
ld.shared.v2.f32 {f433, f434}, [r13+11264];
ld.shared.v2.f32 {f437, f438}, [r13+12288];
ld.shared.v2.f32 {f441, f442}, [r13+13312];
ld.shared.v2.f32 {f445, f446}, [r13+14336];
ld.shared.v2.f32 {f449, f450}, [r13+15360];
add.f32 f453, f389, f421;
sub.f32 f455, f389, f421;
add.f32 f1064, f390, f422;
sub.f32 f456, f390, f422;
add.f32 f457, f405, f437;
sub.f32 f459, f405, f437;
add.f32 f1063, f406, f438;
sub.f32 f460, f406, f438;
add.f32 f461, f453, f457;
sub.f32 f463, f453, f457;
add.f32 f1062, f1064, f1063;
sub.f32 f464, f1064, f1063;
add.f32 f465, f455, f460;
sub.f32 f467, f455, f460;
sub.f32 f1061, f456, f459;
add.f32 f468, f456, f459;
add.f32 f469, f397, f429;
sub.f32 f471, f397, f429;
add.f32 f1060, f398, f430;
sub.f32 f472, f398, f430;
add.f32 f473, f413, f445;
sub.f32 f475, f413, f445;
add.f32 f1059, f414, f446;
sub.f32 f476, f414, f446;
add.f32 f477, f469, f473;
sub.f32 f479, f469, f473;
add.f32 f1058, f1060, f1059;
sub.f32 f480, f1060, f1059;
add.f32 f481, f471, f476;
sub.f32 f483, f471, f476;
sub.f32 f1057, f472, f475;
add.f32 f484, f472, f475;
mul.f32 f1055, f481, 0f3F3504F3;
mul.f32 f1056, f1057, 0fBF3504F3;
sub.f32 f487, f1055, f1056;
mul.f32 f488, f1057, 0f3F3504F3;
fma.rn.f32 f489, f481, 0fBF3504F3, f488;
mul.f32 f490, f483, 0fBF3504F3;
mul.f32 f491, f484, 0fBF3504F3;
sub.f32 f492, f490, f491;
add.f32 f493, f490, f491;
add.f32 f494, f461, f477;
sub.f32 f496, f461, f477;
add.f32 f1054, f1062, f1058;
sub.f32 f497, f1062, f1058;
add.f32 f498, f465, f487;
sub.f32 f500, f465, f487;
add.f32 f1053, f1061, f489;
sub.f32 f501, f1061, f489;
add.f32 f502, f463, f480;
sub.f32 f504, f463, f480;
sub.f32 f1052, f464, f479;
add.f32 f505, f464, f479;
add.f32 f506, f467, f492;
sub.f32 f508, f467, f492;
add.f32 f1051, f468, f493;
sub.f32 f509, f468, f493;
add.f32 f510, f393, f425;
sub.f32 f512, f393, f425;
add.f32 f1050, f394, f426;
sub.f32 f513, f394, f426;
add.f32 f514, f409, f441;
sub.f32 f516, f409, f441;
add.f32 f1049, f410, f442;
sub.f32 f517, f410, f442;
add.f32 f518, f510, f514;
sub.f32 f520, f510, f514;
add.f32 f1048, f1050, f1049;
sub.f32 f521, f1050, f1049;
add.f32 f522, f512, f517;
sub.f32 f524, f512, f517;
sub.f32 f1047, f513, f516;
add.f32 f525, f513, f516;
add.f32 f526, f401, f433;
sub.f32 f528, f401, f433;
add.f32 f1046, f402, f434;
sub.f32 f529, f402, f434;
add.f32 f530, f417, f449;
sub.f32 f532, f417, f449;
add.f32 f1045, f418, f450;
sub.f32 f533, f418, f450;
add.f32 f534, f526, f530;
sub.f32 f536, f526, f530;
add.f32 f1044, f1046, f1045;
sub.f32 f537, f1046, f1045;
add.f32 f538, f528, f533;
sub.f32 f540, f528, f533;
sub.f32 f1043, f529, f532;
add.f32 f541, f529, f532;
mul.f32 f1041, f538, 0f3F3504F3;
mul.f32 f1042, f1043, 0fBF3504F3;
sub.f32 f544, f1041, f1042;
mul.f32 f545, f1043, 0f3F3504F3;
fma.rn.f32 f546, f538, 0fBF3504F3, f545;
mul.f32 f547, f540, 0fBF3504F3;
mul.f32 f548, f541, 0fBF3504F3;
sub.f32 f549, f547, f548;
add.f32 f550, f547, f548;
add.f32 f551, f518, f534;
sub.f32 f553, f518, f534;
add.f32 f1040, f1048, f1044;
sub.f32 f554, f1048, f1044;
add.f32 f555, f522, f544;
sub.f32 f557, f522, f544;
add.f32 f1039, f1047, f546;
sub.f32 f558, f1047, f546;
add.f32 f559, f520, f537;
sub.f32 f561, f520, f537;
sub.f32 f1038, f521, f536;
add.f32 f562, f521, f536;
add.f32 f563, f524, f549;
sub.f32 f565, f524, f549;
add.f32 f1037, f525, f550;
sub.f32 f566, f525, f550;
mul.f32 f568, f1039, 0fBEC3EF15;
mul.f32 f1036, f555, 0f3F6C835E;
sub.f32 f569, f1036, f568;
mul.f32 f570, f1039, 0f3F6C835E;
fma.rn.f32 f571, f555, 0fBEC3EF15, f570;
mul.f32 f573, f1038, 0fBF3504F3;
mul.f32 f1035, f559, 0f3F3504F3;
sub.f32 f574, f1035, f573;
mul.f32 f575, f1038, 0f3F3504F3;
fma.rn.f32 f576, f559, 0fBF3504F3, f575;
mul.f32 f1033, f563, 0f3EC3EF15;
mul.f32 f1034, f1037, 0fBF6C835E;
sub.f32 f579, f1033, f1034;
mul.f32 f580, f1037, 0f3EC3EF15;
fma.rn.f32 f581, f563, 0fBF6C835E, f580;
mul.f32 f1031, f557, 0fBEC3EF15;
mul.f32 f1032, f558, 0fBF6C835E;
sub.f32 f584, f1031, f1032;
mul.f32 f585, f558, 0fBEC3EF15;
fma.rn.f32 f586, f557, 0fBF6C835E, f585;
mul.f32 f587, f561, 0fBF3504F3;
mul.f32 f588, f562, 0fBF3504F3;
sub.f32 f589, f587, f588;
add.f32 f590, f587, f588;
mul.f32 f592, f566, 0fBEC3EF15;
mul.f32 f1030, f565, 0fBF6C835E;
sub.f32 f593, f1030, f592;
mul.f32 f594, f566, 0fBF6C835E;
fma.rn.f32 f595, f565, 0fBEC3EF15, f594;
add.f32 f598, f498, f569;
sub.f32 f600, f498, f569;
add.f32 f1029, f1053, f571;
sub.f32 f601, f1053, f571;
add.f32 f602, f502, f574;
sub.f32 f604, f502, f574;
add.f32 f1028, f1052, f576;
sub.f32 f605, f1052, f576;
add.f32 f606, f506, f579;
sub.f32 f608, f506, f579;
add.f32 f1027, f1051, f581;
sub.f32 f609, f1051, f581;
add.f32 f610, f496, f554;
sub.f32 f612, f496, f554;
sub.f32 f1026, f497, f553;
add.f32 f613, f497, f553;
add.f32 f614, f500, f584;
sub.f32 f616, f500, f584;
add.f32 f1025, f501, f586;
sub.f32 f617, f501, f586;
add.f32 f618, f504, f589;
sub.f32 f620, f504, f589;
add.f32 f1024, f505, f590;
sub.f32 f621, f505, f590;
add.f32 f622, f508, f593;
sub.f32 f624, f508, f593;
add.f32 f1023, f509, f595;
sub.f32 f625, f509, f595;
and.b32 r14, r35, 112;
bfe.u32 r15, r35, 4, 3;
mul.wide.u32 rd6, r15, 8;
mov.u64 rd7, %34;
add.s64 rd8, rd7, rd6;
ld.global.v2.f32 {f626, f627}, [rd8];
mul.f32 f631, f627, f1029;
mul.f32 f632, f626, f1029;
mul.f32 f634, f627, f627;
mul.f32 f1022, f626, f626;
sub.f32 f635, f1022, f634;
mul.f32 f636, f627, f626;
fma.rn.f32 f637, f627, f626, f636;
mul.f32 f639, f637, f1028;
mul.f32 f640, f635, f1028;
mul.f32 f1020, f626, f635;
mul.f32 f1021, f627, f637;
sub.f32 f643, f1020, f1021;
mul.f32 f1019, f635, f602;
mul.f32 f644, f626, f637;
fma.rn.f32 f645, f627, f635, f644;
mul.f32 f647, f645, f1027;
mul.f32 f648, f643, f1027;
mul.f32 f650, f627, f645;
mul.f32 f1018, f626, f643;
sub.f32 f651, f1018, f650;
mul.f32 f1017, f643, f606;
mul.f32 f652, f626, f645;
fma.rn.f32 f653, f627, f643, f652;
mul.f32 f655, f653, f1026;
mul.f32 f656, f651, f1026;
mul.f32 f658, f627, f653;
mul.f32 f1016, f626, f651;
sub.f32 f659, f1016, f658;
mul.f32 f1015, f651, f610;
mul.f32 f660, f626, f653;
fma.rn.f32 f661, f627, f651, f660;
mul.f32 f663, f661, f1025;
mul.f32 f664, f659, f1025;
mul.f32 f1013, f626, f659;
mul.f32 f1014, f627, f661;
sub.f32 f667, f1013, f1014;
mul.f32 f1012, f659, f614;
mul.f32 f668, f626, f661;
fma.rn.f32 f669, f627, f659, f668;
mul.f32 f671, f669, f1024;
mul.f32 f672, f667, f1024;
mul.f32 f674, f627, f669;
mul.f32 f1011, f626, f667;
sub.f32 f675, f1011, f674;
mul.f32 f1010, f667, f618;
mul.f32 f676, f626, f669;
fma.rn.f32 f677, f627, f667, f676;
mul.f32 f679, f677, f1023;
mul.f32 f680, f675, f1023;
mul.f32 f682, f627, f677;
mul.f32 f1009, f626, f675;
sub.f32 f683, f1009, f682;
mul.f32 f1008, f675, f622;
mul.f32 f684, f626, f677;
fma.rn.f32 f685, f627, f675, f684;
sub.f32 f1007, f1054, f1040;
mul.f32 f687, f685, f1007;
mul.f32 f688, f683, f1007;
mul.f32 f1005, f626, f683;
mul.f32 f1006, f627, f685;
sub.f32 f691, f1005, f1006;
sub.f32 f1004, f494, f551;
mul.f32 f1003, f683, f1004;
mul.f32 f692, f626, f685;
fma.rn.f32 f693, f627, f683, f692;
mul.f32 f695, f693, f601;
mul.f32 f696, f691, f601;
mul.f32 f698, f627, f693;
mul.f32 f1002, f626, f691;
sub.f32 f699, f1002, f698;
mul.f32 f1001, f691, f600;
mul.f32 f700, f626, f693;
fma.rn.f32 f701, f627, f691, f700;
mul.f32 f703, f701, f605;
mul.f32 f704, f699, f605;
mul.f32 f999, f626, f699;
mul.f32 f1000, f627, f701;
sub.f32 f707, f999, f1000;
mul.f32 f998, f699, f604;
mul.f32 f708, f626, f701;
fma.rn.f32 f709, f627, f699, f708;
mul.f32 f711, f709, f609;
mul.f32 f712, f707, f609;
mul.f32 f714, f627, f709;
mul.f32 f997, f626, f707;
sub.f32 f715, f997, f714;
mul.f32 f996, f707, f608;
mul.f32 f716, f626, f709;
fma.rn.f32 f717, f627, f707, f716;
mul.f32 f719, f717, f613;
mul.f32 f720, f715, f613;
mul.f32 f722, f627, f717;
mul.f32 f995, f626, f715;
sub.f32 f723, f995, f722;
mul.f32 f994, f715, f612;
mul.f32 f724, f626, f717;
fma.rn.f32 f725, f627, f715, f724;
mul.f32 f727, f725, f617;
mul.f32 f728, f723, f617;
mul.f32 f992, f626, f723;
mul.f32 f993, f627, f725;
sub.f32 f731, f992, f993;
mul.f32 f991, f723, f616;
mul.f32 f732, f626, f725;
fma.rn.f32 f733, f627, f723, f732;
mul.f32 f735, f733, f621;
mul.f32 f736, f731, f621;
mul.f32 f738, f627, f733;
mul.f32 f990, f626, f731;
sub.f32 f739, f990, f738;
mul.f32 f989, f626, f598;
mul.f32 f740, f626, f733;
mul.f32 f988, f731, f620;
fma.rn.f32 f741, f627, f731, f740;
mul.f32 f742, f739, f624;
mul.f32 f743, f741, f625;
mul.f32 f744, f739, f625;
mov.u32 r25, %tid.x;
shl.b32 r24, r25, 3;
and.b32 r16, r24, 120;
add.s32 r17, r9, r16;
mov.u32 r27, %tid.x;
shl.b32 r26, r27, 7;
barrier.sync 0;
and.b32 r18, r26, 14336;
add.s32 r19, r17, r18;
mov.u32 r29, %tid.x;
and.b32 r28, r29, 112;
add.f32 f745, f1054, f1040;
sub.f32 f1156, f494, f551;
add.f32 f746, f494, f551;
st.shared.v2.f32 [r19], {f746, f745};
mov.u32 r32, %tid.x;
and.b32 r31, r32, 112;
fma.rn.f32 f747, f627, f598, f632;
sub.f32 f748, f989, f631;
st.shared.v2.f32 [r19+128], {f748, f747};
fma.rn.f32 f749, f637, f602, f640;
sub.f32 f750, f1019, f639;
st.shared.v2.f32 [r19+256], {f750, f749};
fma.rn.f32 f751, f645, f606, f648;
sub.f32 f752, f1017, f647;
st.shared.v2.f32 [r19+384], {f752, f751};
fma.rn.f32 f753, f653, f610, f656;
sub.f32 f754, f1015, f655;
st.shared.v2.f32 [r19+512], {f754, f753};
sub.f32 f755, f1012, f663;
fma.rn.f32 f756, f661, f614, f664;
st.shared.v2.f32 [r19+640], {f755, f756};
fma.rn.f32 f757, f669, f618, f672;
sub.f32 f758, f1010, f671;
st.shared.v2.f32 [r19+768], {f758, f757};
fma.rn.f32 f759, f677, f622, f680;
sub.f32 f760, f1008, f679;
st.shared.v2.f32 [r19+896], {f760, f759};
fma.rn.f32 f761, f685, f1156, f688;
sub.f32 f762, f1003, f687;
st.shared.v2.f32 [r19+1024], {f762, f761};
fma.rn.f32 f763, f693, f600, f696;
sub.f32 f764, f1001, f695;
st.shared.v2.f32 [r19+1152], {f764, f763};
fma.rn.f32 f765, f701, f604, f704;
sub.f32 f766, f998, f703;
st.shared.v2.f32 [r19+1280], {f766, f765};
fma.rn.f32 f767, f709, f608, f712;
sub.f32 f768, f996, f711;
st.shared.v2.f32 [r19+1408], {f768, f767};
fma.rn.f32 f769, f717, f612, f720;
sub.f32 f770, f994, f719;
st.shared.v2.f32 [r19+1536], {f770, f769};
fma.rn.f32 f771, f725, f616, f728;
sub.f32 f772, f991, f727;
st.shared.v2.f32 [r19+1664], {f772, f771};
fma.rn.f32 f773, f733, f620, f736;
sub.f32 f774, f988, f735;
st.shared.v2.f32 [r19+1792], {f774, f773};
fma.rn.f32 f775, f741, f624, f744;
sub.f32 f776, f742, f743;
st.shared.v2.f32 [r19+1920], {f776, f775};
barrier.sync 0;
mad.lo.s32 r20, r31, -120, r19;
ld.shared.v2.f32 {f777, f778}, [r20];
ld.shared.v2.f32 {f781, f782}, [r20+1024];
ld.shared.v2.f32 {f785, f786}, [r20+2048];
ld.shared.v2.f32 {f789, f790}, [r20+3072];
ld.shared.v2.f32 {f793, f794}, [r20+4096];
ld.shared.v2.f32 {f797, f798}, [r20+5120];
ld.shared.v2.f32 {f801, f802}, [r20+6144];
ld.shared.v2.f32 {f805, f806}, [r20+7168];
ld.shared.v2.f32 {f809, f810}, [r20+8192];
ld.shared.v2.f32 {f813, f814}, [r20+9216];
ld.shared.v2.f32 {f817, f818}, [r20+10240];
ld.shared.v2.f32 {f821, f822}, [r20+11264];
ld.shared.v2.f32 {f825, f826}, [r20+12288];
ld.shared.v2.f32 {f829, f830}, [r20+13312];
ld.shared.v2.f32 {f833, f834}, [r20+14336];
ld.shared.v2.f32 {f837, f838}, [r20+15360];
add.f32 f841, f777, f809;
sub.f32 f843, f777, f809;
add.f32 f987, f778, f810;
sub.f32 f844, f778, f810;
add.f32 f845, f793, f825;
sub.f32 f847, f793, f825;
add.f32 f986, f794, f826;
sub.f32 f848, f794, f826;
add.f32 f849, f841, f845;
sub.f32 f851, f841, f845;
add.f32 f985, f987, f986;
sub.f32 f852, f987, f986;
add.f32 f853, f843, f848;
sub.f32 f855, f843, f848;
sub.f32 f984, f844, f847;
add.f32 f856, f844, f847;
add.f32 f857, f785, f817;
sub.f32 f859, f785, f817;
add.f32 f983, f786, f818;
sub.f32 f860, f786, f818;
add.f32 f861, f801, f833;
sub.f32 f863, f801, f833;
add.f32 f982, f802, f834;
sub.f32 f864, f802, f834;
add.f32 f865, f857, f861;
sub.f32 f867, f857, f861;
add.f32 f981, f983, f982;
sub.f32 f868, f983, f982;
add.f32 f869, f859, f864;
sub.f32 f871, f859, f864;
sub.f32 f980, f860, f863;
add.f32 f872, f860, f863;
mul.f32 f978, f869, 0f3F3504F3;
mul.f32 f979, f980, 0fBF3504F3;
sub.f32 f875, f978, f979;
mul.f32 f876, f980, 0f3F3504F3;
fma.rn.f32 f877, f869, 0fBF3504F3, f876;
mul.f32 f878, f871, 0fBF3504F3;
mul.f32 f879, f872, 0fBF3504F3;
sub.f32 f880, f878, f879;
add.f32 f881, f878, f879;
add.f32 f882, f781, f813;
sub.f32 f884, f781, f813;
add.f32 f977, f782, f814;
sub.f32 f885, f782, f814;
add.f32 f886, f797, f829;
sub.f32 f888, f797, f829;
add.f32 f976, f798, f830;
sub.f32 f889, f798, f830;
add.f32 f890, f882, f886;
sub.f32 f892, f882, f886;
add.f32 f975, f977, f976;
sub.f32 f893, f977, f976;
add.f32 f894, f884, f889;
sub.f32 f896, f884, f889;
sub.f32 f974, f885, f888;
add.f32 f897, f885, f888;
add.f32 f898, f789, f821;
sub.f32 f900, f789, f821;
add.f32 f973, f790, f822;
sub.f32 f901, f790, f822;
add.f32 f902, f805, f837;
sub.f32 f904, f805, f837;
add.f32 f972, f806, f838;
sub.f32 f905, f806, f838;
add.f32 f906, f898, f902;
sub.f32 f908, f898, f902;
add.f32 f971, f973, f972;
sub.f32 f909, f973, f972;
add.f32 f910, f900, f905;
sub.f32 f912, f900, f905;
sub.f32 f970, f901, f904;
add.f32 f913, f901, f904;
mul.f32 f968, f910, 0f3F3504F3;
mul.f32 f969, f970, 0fBF3504F3;
sub.f32 f916, f968, f969;
mul.f32 f917, f970, 0f3F3504F3;
fma.rn.f32 f918, f910, 0fBF3504F3, f917;
mul.f32 f919, f912, 0fBF3504F3;
mul.f32 f920, f913, 0fBF3504F3;
sub.f32 f921, f919, f920;
add.f32 f922, f919, f920;
add.f32 %1, f985, f981;
add.f32 %0, f849, f865;
add.f32 %3, f975, f971;
add.f32 %2, f890, f906;
add.f32 %4, f853, f875;
add.f32 %5, f984, f877;
add.f32 %6, f894, f916;
add.f32 %7, f974, f918;
add.f32 %8, f851, f868;
sub.f32 %9, f852, f867;
sub.f32 %11, f893, f908;
add.f32 %10, f892, f909;
add.f32 %13, f856, f881;
add.f32 %12, f855, f880;
add.f32 %15, f897, f922;
add.f32 %14, f896, f921;
sub.f32 %17, f985, f981;
sub.f32 %16, f849, f865;
sub.f32 %19, f975, f971;
sub.f32 %18, f890, f906;
sub.f32 %21, f984, f877;
sub.f32 %20, f853, f875;
sub.f32 %23, f974, f918;
sub.f32 %22, f894, f916;
add.f32 %25, f852, f867;
sub.f32 %24, f851, f868;
add.f32 %27, f893, f908;
sub.f32 %26, f892, f909;
sub.f32 %29, f856, f881;
sub.f32 %28, f855, f880;
sub.f32 %31, f897, f922;
sub.f32 %30, f896, f921;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y), "=f"(rmem[2].x), "=f"(rmem[2].y), "=f"(rmem[3].x), "=f"(rmem[3].y), "=f"(rmem[4].x), "=f"(rmem[4].y), "=f"(rmem[5].x), "=f"(rmem[5].y), "=f"(rmem[6].x), "=f"(rmem[6].y), "=f"(rmem[7].x), "=f"(rmem[7].y), "=f"(rmem[8].x), "=f"(rmem[8].y), "=f"(rmem[9].x), "=f"(rmem[9].y), "=f"(rmem[10].x), "=f"(rmem[10].y), "=f"(rmem[11].x), "=f"(rmem[11].y), "=f"(rmem[12].x), "=f"(rmem[12].y), "=f"(rmem[13].x), "=f"(rmem[13].y), "=f"(rmem[14].x), "=f"(rmem[14].y), "=f"(rmem[15].x), "=f"(rmem[15].y): "r"(smem), "l"(lut_sp_16_2048), "l"(lut_sp_16_128), "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y), "f"(rmem[2].x), "f"(rmem[2].y), "f"(rmem[3].x), "f"(rmem[3].y), "f"(rmem[4].x), "f"(rmem[4].y), "f"(rmem[5].x), "f"(rmem[5].y), "f"(rmem[6].x), "f"(rmem[6].y), "f"(rmem[7].x), "f"(rmem[7].y), "f"(rmem[8].x), "f"(rmem[8].y), "f"(rmem[9].x), "f"(rmem[9].y), "f"(rmem[10].x), "f"(rmem[10].y), "f"(rmem[11].x), "f"(rmem[11].y), "f"(rmem[12].x), "f"(rmem[12].y), "f"(rmem[13].x), "f"(rmem[13].y), "f"(rmem[14].x), "f"(rmem[14].y), "f"(rmem[15].x), "f"(rmem[15].y), "f"(rmem[8].y), "f"(rmem[4].y), "f"(rmem[10].y), "f"(rmem[2].y), "f"(rmem[14].y), "f"(rmem[1].y), "f"(rmem[5].y), "f"(rmem[13].y), "f"(rmem[11].y), "f"(rmem[7].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<95, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<2469>;
.reg .b32 r<41>;
.reg .b64 rd<12>;
mov.u32 r1, %tid.y;
shl.b32 r2, r1, 14;
mov.u32 r3, %64;
add.s32 r4, r3, r2;
add.f32 f129, %67, %99;
sub.f32 f131, %67, %99;
add.f32 f2459, %68, %131;
sub.f32 f132, %68, %131;
add.f32 f133, %83, %115;
sub.f32 f135, %83, %115;
add.f32 f2457, %132, %116;
sub.f32 f136, %132, %116;
add.f32 f137, f129, f133;
sub.f32 f139, f129, f133;
add.f32 f2456, f2459, f2457;
sub.f32 f140, f2459, f2457;
add.f32 f141, f131, f136;
sub.f32 f143, f131, f136;
sub.f32 f2455, f132, f135;
add.f32 f144, f132, f135;
add.f32 f145, %75, %107;
sub.f32 f147, %75, %107;
add.f32 f2452, %133, %134;
sub.f32 f148, %133, %134;
add.f32 f149, %91, %123;
sub.f32 f151, %91, %123;
add.f32 f2450, %92, %135;
sub.f32 f152, %92, %135;
add.f32 f153, f145, f149;
sub.f32 f155, f145, f149;
add.f32 f2449, f2452, f2450;
sub.f32 f156, f2452, f2450;
add.f32 f157, f147, f152;
sub.f32 f159, f147, f152;
sub.f32 f2448, f148, f151;
add.f32 f160, f148, f151;
mul.f32 f162, f2448, 0fBF3504F3;
mul.f32 f2447, f157, 0f3F3504F3;
sub.f32 f163, f2447, f162;
mul.f32 f164, f2448, 0f3F3504F3;
fma.rn.f32 f165, f157, 0fBF3504F3, f164;
mul.f32 f166, f159, 0fBF3504F3;
mul.f32 f167, f160, 0fBF3504F3;
sub.f32 f168, f166, f167;
add.f32 f169, f166, f167;
add.f32 f170, f137, f153;
sub.f32 f172, f137, f153;
add.f32 f2446, f2456, f2449;
sub.f32 f173, f2456, f2449;
add.f32 f174, f141, f163;
sub.f32 f176, f141, f163;
add.f32 f2445, f2455, f165;
sub.f32 f177, f2455, f165;
add.f32 f178, f139, f156;
sub.f32 f180, f139, f156;
sub.f32 f2444, f140, f155;
add.f32 f181, f140, f155;
add.f32 f182, f143, f168;
sub.f32 f184, f143, f168;
add.f32 f2443, f144, f169;
sub.f32 f185, f144, f169;
add.f32 f186, %71, %103;
sub.f32 f188, %71, %103;
add.f32 f2441, %136, %104;
sub.f32 f189, %136, %104;
add.f32 f190, %87, %119;
sub.f32 f192, %87, %119;
add.f32 f2438, %138, %137;
sub.f32 f193, %138, %137;
add.f32 f194, f186, f190;
sub.f32 f196, f186, f190;
add.f32 f2437, f2441, f2438;
sub.f32 f197, f2441, f2438;
add.f32 f198, f188, f193;
sub.f32 f200, f188, f193;
sub.f32 f2436, f189, f192;
add.f32 f201, f189, f192;
add.f32 f202, %79, %111;
sub.f32 f204, %79, %111;
add.f32 f2434, %80, %139;
sub.f32 f205, %80, %139;
add.f32 f206, %95, %127;
sub.f32 f208, %95, %127;
add.f32 f2432, %140, %128;
sub.f32 f209, %140, %128;
add.f32 f210, f202, f206;
sub.f32 f212, f202, f206;
add.f32 f2431, f2434, f2432;
sub.f32 f213, f2434, f2432;
add.f32 f214, f204, f209;
sub.f32 f216, f204, f209;
sub.f32 f2430, f205, f208;
add.f32 f217, f205, f208;
mul.f32 f219, f2430, 0fBF3504F3;
mul.f32 f2429, f214, 0f3F3504F3;
sub.f32 f220, f2429, f219;
mul.f32 f221, f2430, 0f3F3504F3;
fma.rn.f32 f222, f214, 0fBF3504F3, f221;
mul.f32 f223, f216, 0fBF3504F3;
mul.f32 f224, f217, 0fBF3504F3;
sub.f32 f225, f223, f224;
add.f32 f226, f223, f224;
add.f32 f227, f194, f210;
sub.f32 f229, f194, f210;
add.f32 f2428, f2437, f2431;
sub.f32 f230, f2437, f2431;
add.f32 f231, f198, f220;
sub.f32 f233, f198, f220;
add.f32 f2427, f2436, f222;
sub.f32 f234, f2436, f222;
add.f32 f235, f196, f213;
sub.f32 f237, f196, f213;
sub.f32 f2426, f197, f212;
add.f32 f238, f197, f212;
add.f32 f239, f200, f225;
sub.f32 f241, f200, f225;
add.f32 f2425, f201, f226;
sub.f32 f242, f201, f226;
mul.f32 f2423, f231, 0f3F6C835E;
mul.f32 f2424, f2427, 0fBEC3EF15;
sub.f32 f245, f2423, f2424;
mul.f32 f246, f2427, 0f3F6C835E;
fma.rn.f32 f247, f231, 0fBEC3EF15, f246;
mul.f32 f2421, f235, 0f3F3504F3;
mul.f32 f2422, f2426, 0fBF3504F3;
sub.f32 f250, f2421, f2422;
mul.f32 f251, f2426, 0f3F3504F3;
fma.rn.f32 f252, f235, 0fBF3504F3, f251;
mul.f32 f2419, f239, 0f3EC3EF15;
mul.f32 f2420, f2425, 0fBF6C835E;
sub.f32 f255, f2419, f2420;
mul.f32 f256, f2425, 0f3EC3EF15;
fma.rn.f32 f257, f239, 0fBF6C835E, f256;
mul.f32 f2417, f233, 0fBEC3EF15;
mul.f32 f2418, f234, 0fBF6C835E;
sub.f32 f260, f2417, f2418;
mul.f32 f261, f234, 0fBEC3EF15;
fma.rn.f32 f262, f233, 0fBF6C835E, f261;
mul.f32 f263, f237, 0fBF3504F3;
mul.f32 f264, f238, 0fBF3504F3;
sub.f32 f265, f263, f264;
add.f32 f266, f263, f264;
mul.f32 f2415, f241, 0fBF6C835E;
mul.f32 f2416, f242, 0fBEC3EF15;
sub.f32 f269, f2415, f2416;
mul.f32 f270, f242, 0fBF6C835E;
fma.rn.f32 f271, f241, 0fBEC3EF15, f270;
add.f32 f272, f170, f227;
sub.f32 f274, f170, f227;
add.f32 f2414, f2446, f2428;
sub.f32 f275, f2446, f2428;
add.f32 f276, f174, f245;
sub.f32 f278, f174, f245;
add.f32 f2413, f2445, f247;
sub.f32 f279, f2445, f247;
add.f32 f280, f178, f250;
sub.f32 f282, f178, f250;
add.f32 f2412, f2444, f252;
sub.f32 f283, f2444, f252;
add.f32 f284, f182, f255;
sub.f32 f286, f182, f255;
add.f32 f2411, f2443, f257;
sub.f32 f287, f2443, f257;
add.f32 f288, f172, f230;
sub.f32 f290, f172, f230;
sub.f32 f2410, f173, f229;
add.f32 f291, f173, f229;
add.f32 f292, f176, f260;
sub.f32 f294, f176, f260;
add.f32 f2409, f177, f262;
sub.f32 f295, f177, f262;
add.f32 f296, f180, f265;
sub.f32 f298, f180, f265;
add.f32 f2408, f181, f266;
sub.f32 f299, f181, f266;
add.f32 f300, f184, f269;
sub.f32 f302, f184, f269;
add.f32 f2407, f185, f271;
sub.f32 f303, f185, f271;
add.f32 f304, %69, %101;
sub.f32 f306, %69, %101;
add.f32 f2404, %142, %141;
sub.f32 f307, %142, %141;
add.f32 f308, %85, %117;
sub.f32 f310, %85, %117;
add.f32 f2402, %86, %143;
sub.f32 f311, %86, %143;
add.f32 f312, f304, f308;
sub.f32 f314, f304, f308;
add.f32 f2401, f2404, f2402;
sub.f32 f315, f2404, f2402;
add.f32 f316, f306, f311;
sub.f32 f318, f306, f311;
sub.f32 f2400, f307, f310;
add.f32 f319, f307, f310;
add.f32 f320, %77, %109;
sub.f32 f322, %77, %109;
add.f32 f2398, %144, %110;
sub.f32 f323, %144, %110;
add.f32 f324, %93, %125;
sub.f32 f326, %93, %125;
add.f32 f2395, %146, %145;
sub.f32 f327, %146, %145;
add.f32 f328, f320, f324;
sub.f32 f330, f320, f324;
add.f32 f2394, f2398, f2395;
sub.f32 f331, f2398, f2395;
add.f32 f332, f322, f327;
sub.f32 f334, f322, f327;
sub.f32 f2393, f323, f326;
add.f32 f335, f323, f326;
mul.f32 f2391, f332, 0f3F3504F3;
mul.f32 f2392, f2393, 0fBF3504F3;
sub.f32 f338, f2391, f2392;
mul.f32 f339, f2393, 0f3F3504F3;
fma.rn.f32 f340, f332, 0fBF3504F3, f339;
mul.f32 f341, f334, 0fBF3504F3;
mul.f32 f342, f335, 0fBF3504F3;
sub.f32 f343, f341, f342;
add.f32 f344, f341, f342;
add.f32 f345, f312, f328;
sub.f32 f347, f312, f328;
add.f32 f2390, f2401, f2394;
sub.f32 f348, f2401, f2394;
add.f32 f349, f316, f338;
sub.f32 f351, f316, f338;
add.f32 f2389, f2400, f340;
sub.f32 f352, f2400, f340;
add.f32 f353, f314, f331;
sub.f32 f355, f314, f331;
sub.f32 f2388, f315, f330;
add.f32 f356, f315, f330;
add.f32 f357, f318, f343;
sub.f32 f359, f318, f343;
add.f32 f2387, f319, f344;
sub.f32 f360, f319, f344;
add.f32 f361, %73, %105;
sub.f32 f363, %73, %105;
add.f32 f2385, %74, %147;
sub.f32 f364, %74, %147;
add.f32 f365, %89, %121;
sub.f32 f367, %89, %121;
add.f32 f2383, %148, %122;
sub.f32 f368, %148, %122;
add.f32 f369, f361, f365;
sub.f32 f371, f361, f365;
add.f32 f2382, f2385, f2383;
sub.f32 f372, f2385, f2383;
add.f32 f373, f363, f368;
sub.f32 f375, f363, f368;
sub.f32 f2381, f364, f367;
add.f32 f376, f364, f367;
add.f32 f377, %81, %113;
sub.f32 f379, %81, %113;
add.f32 f2378, %149, %150;
sub.f32 f380, %149, %150;
add.f32 f381, %97, %129;
sub.f32 f383, %97, %129;
add.f32 f2377, %98, %130;
sub.f32 f384, %98, %130;
add.f32 f385, f377, f381;
sub.f32 f387, f377, f381;
add.f32 f2376, f2378, f2377;
sub.f32 f388, f2378, f2377;
add.f32 f389, f379, f384;
sub.f32 f391, f379, f384;
sub.f32 f2375, f380, f383;
add.f32 f392, f380, f383;
mul.f32 f2373, f389, 0f3F3504F3;
mul.f32 f2374, f2375, 0fBF3504F3;
sub.f32 f395, f2373, f2374;
mul.f32 f396, f2375, 0f3F3504F3;
fma.rn.f32 f397, f389, 0fBF3504F3, f396;
mul.f32 f398, f391, 0fBF3504F3;
mul.f32 f399, f392, 0fBF3504F3;
sub.f32 f400, f398, f399;
add.f32 f401, f398, f399;
add.f32 f402, f369, f385;
sub.f32 f404, f369, f385;
add.f32 f2372, f2382, f2376;
sub.f32 f405, f2382, f2376;
add.f32 f406, f373, f395;
sub.f32 f408, f373, f395;
add.f32 f2371, f2381, f397;
sub.f32 f409, f2381, f397;
add.f32 f410, f371, f388;
sub.f32 f412, f371, f388;
sub.f32 f2370, f372, f387;
add.f32 f413, f372, f387;
add.f32 f414, f375, f400;
sub.f32 f416, f375, f400;
add.f32 f2369, f376, f401;
sub.f32 f417, f376, f401;
mul.f32 f419, f2371, 0fBEC3EF15;
mul.f32 f2368, f406, 0f3F6C835E;
sub.f32 f420, f2368, f419;
mul.f32 f421, f2371, 0f3F6C835E;
fma.rn.f32 f422, f406, 0fBEC3EF15, f421;
mul.f32 f424, f2370, 0fBF3504F3;
mul.f32 f2367, f410, 0f3F3504F3;
sub.f32 f425, f2367, f424;
mul.f32 f426, f2370, 0f3F3504F3;
fma.rn.f32 f427, f410, 0fBF3504F3, f426;
mul.f32 f2365, f414, 0f3EC3EF15;
mul.f32 f2366, f2369, 0fBF6C835E;
sub.f32 f430, f2365, f2366;
mul.f32 f431, f2369, 0f3EC3EF15;
fma.rn.f32 f432, f414, 0fBF6C835E, f431;
mul.f32 f2363, f408, 0fBEC3EF15;
mul.f32 f2364, f409, 0fBF6C835E;
sub.f32 f435, f2363, f2364;
mul.f32 f436, f409, 0fBEC3EF15;
fma.rn.f32 f437, f408, 0fBF6C835E, f436;
mul.f32 f438, f412, 0fBF3504F3;
mul.f32 f439, f413, 0fBF3504F3;
sub.f32 f440, f438, f439;
add.f32 f441, f438, f439;
mul.f32 f443, f417, 0fBEC3EF15;
mul.f32 f2362, f416, 0fBF6C835E;
sub.f32 f444, f2362, f443;
mul.f32 f445, f417, 0fBF6C835E;
fma.rn.f32 f446, f416, 0fBEC3EF15, f445;
add.f32 f447, f345, f402;
sub.f32 f449, f345, f402;
add.f32 f2361, f2390, f2372;
sub.f32 f450, f2390, f2372;
add.f32 f451, f349, f420;
sub.f32 f453, f349, f420;
add.f32 f2360, f2389, f422;
sub.f32 f454, f2389, f422;
add.f32 f455, f353, f425;
sub.f32 f457, f353, f425;
add.f32 f2359, f2388, f427;
sub.f32 f458, f2388, f427;
add.f32 f459, f357, f430;
sub.f32 f461, f357, f430;
add.f32 f2358, f2387, f432;
sub.f32 f462, f2387, f432;
add.f32 f463, f347, f405;
sub.f32 f465, f347, f405;
sub.f32 f2357, f348, f404;
add.f32 f466, f348, f404;
add.f32 f467, f351, f435;
sub.f32 f469, f351, f435;
add.f32 f2356, f352, f437;
sub.f32 f470, f352, f437;
add.f32 f471, f355, f440;
sub.f32 f473, f355, f440;
add.f32 f2355, f356, f441;
sub.f32 f474, f356, f441;
add.f32 f475, f359, f444;
sub.f32 f477, f359, f444;
add.f32 f2354, f360, f446;
sub.f32 f478, f360, f446;
mul.f32 f480, f2360, 0fBE47C5C2;
mul.f32 f2353, f451, 0f3F7B14BE;
sub.f32 f481, f2353, f480;
mul.f32 f482, f2360, 0f3F7B14BE;
fma.rn.f32 f483, f451, 0fBE47C5C2, f482;
mul.f32 f485, f2359, 0fBEC3EF15;
mul.f32 f2352, f455, 0f3F6C835E;
sub.f32 f486, f2352, f485;
mul.f32 f487, f2359, 0f3F6C835E;
fma.rn.f32 f488, f455, 0fBEC3EF15, f487;
mul.f32 f490, f2358, 0fBF0E39DA;
mul.f32 f2351, f459, 0f3F54DB31;
sub.f32 f491, f2351, f490;
mul.f32 f492, f2358, 0f3F54DB31;
fma.rn.f32 f493, f459, 0fBF0E39DA, f492;
mul.f32 f495, f2357, 0fBF3504F3;
mul.f32 f2350, f463, 0f3F3504F3;
sub.f32 f496, f2350, f495;
mul.f32 f497, f2357, 0f3F3504F3;
fma.rn.f32 f498, f463, 0fBF3504F3, f497;
mul.f32 f2348, f467, 0f3F0E39DA;
mul.f32 f2349, f2356, 0fBF54DB31;
sub.f32 f501, f2348, f2349;
mul.f32 f502, f2356, 0f3F0E39DA;
fma.rn.f32 f503, f467, 0fBF54DB31, f502;
mul.f32 f2346, f471, 0f3EC3EF15;
mul.f32 f2347, f2355, 0fBF6C835E;
sub.f32 f506, f2346, f2347;
mul.f32 f507, f2355, 0f3EC3EF15;
fma.rn.f32 f508, f471, 0fBF6C835E, f507;
mul.f32 f2344, f475, 0f3E47C5C2;
mul.f32 f2345, f2354, 0fBF7B14BE;
sub.f32 f511, f2344, f2345;
mul.f32 f512, f2354, 0f3E47C5C2;
fma.rn.f32 f513, f475, 0fBF7B14BE, f512;
mul.f32 f2342, f453, 0fBE47C5C2;
mul.f32 f2343, f454, 0fBF7B14BE;
sub.f32 f516, f2342, f2343;
mul.f32 f517, f454, 0fBE47C5C2;
fma.rn.f32 f518, f453, 0fBF7B14BE, f517;
mul.f32 f520, f458, 0fBF6C835E;
mul.f32 f2341, f457, 0fBEC3EF15;
sub.f32 f521, f2341, f520;
mul.f32 f522, f458, 0fBEC3EF15;
fma.rn.f32 f523, f457, 0fBF6C835E, f522;
mul.f32 f525, f462, 0fBF54DB31;
mul.f32 f2340, f461, 0fBF0E39DA;
sub.f32 f526, f2340, f525;
mul.f32 f527, f462, 0fBF0E39DA;
fma.rn.f32 f528, f461, 0fBF54DB31, f527;
mul.f32 f529, f465, 0fBF3504F3;
mul.f32 f530, f466, 0fBF3504F3;
sub.f32 f531, f529, f530;
add.f32 f532, f529, f530;
mul.f32 f2338, f469, 0fBF54DB31;
mul.f32 f2339, f470, 0fBF0E39DA;
sub.f32 f535, f2338, f2339;
mul.f32 f536, f470, 0fBF54DB31;
fma.rn.f32 f537, f469, 0fBF0E39DA, f536;
mul.f32 f539, f474, 0fBEC3EF15;
mul.f32 f2337, f473, 0fBF6C835E;
sub.f32 f540, f2337, f539;
mul.f32 f541, f474, 0fBF6C835E;
fma.rn.f32 f542, f473, 0fBEC3EF15, f541;
mul.f32 f544, f478, 0fBE47C5C2;
mul.f32 f2336, f477, 0fBF7B14BE;
sub.f32 f545, f2336, f544;
mul.f32 f546, f478, 0fBF7B14BE;
fma.rn.f32 f547, f477, 0fBE47C5C2, f546;
add.f32 f550, f276, f481;
sub.f32 f552, f276, f481;
add.f32 f2335, f2413, f483;
sub.f32 f553, f2413, f483;
add.f32 f554, f280, f486;
sub.f32 f556, f280, f486;
add.f32 f2334, f2412, f488;
sub.f32 f557, f2412, f488;
add.f32 f558, f284, f491;
sub.f32 f560, f284, f491;
add.f32 f2333, f2411, f493;
sub.f32 f561, f2411, f493;
add.f32 f562, f288, f496;
sub.f32 f564, f288, f496;
add.f32 f2332, f2410, f498;
sub.f32 f565, f2410, f498;
add.f32 f566, f292, f501;
sub.f32 f568, f292, f501;
add.f32 f2331, f2409, f503;
sub.f32 f569, f2409, f503;
add.f32 f570, f296, f506;
sub.f32 f572, f296, f506;
add.f32 f2330, f2408, f508;
sub.f32 f573, f2408, f508;
add.f32 f574, f300, f511;
sub.f32 f576, f300, f511;
add.f32 f2329, f2407, f513;
sub.f32 f577, f2407, f513;
add.f32 f578, f274, f450;
sub.f32 f580, f274, f450;
sub.f32 f2328, f275, f449;
add.f32 f581, f275, f449;
add.f32 f582, f278, f516;
sub.f32 f584, f278, f516;
add.f32 f2327, f279, f518;
sub.f32 f585, f279, f518;
add.f32 f586, f282, f521;
sub.f32 f588, f282, f521;
add.f32 f2326, f283, f523;
sub.f32 f589, f283, f523;
add.f32 f590, f286, f526;
sub.f32 f592, f286, f526;
add.f32 f2325, f287, f528;
sub.f32 f593, f287, f528;
add.f32 f594, f290, f531;
sub.f32 f596, f290, f531;
add.f32 f2324, f291, f532;
sub.f32 f597, f291, f532;
add.f32 f598, f294, f535;
sub.f32 f600, f294, f535;
add.f32 f2323, f295, f537;
sub.f32 f601, f295, f537;
add.f32 f602, f298, f540;
sub.f32 f604, f298, f540;
add.f32 f2322, f299, f542;
sub.f32 f605, f299, f542;
add.f32 f606, f302, f545;
sub.f32 f608, f302, f545;
add.f32 f2321, f303, f547;
sub.f32 f609, f303, f547;
mov.u32 r22, %tid.x;
shl.b32 r7, r22, 8;
and.b32 r8, r7, -16384;
add.s32 r9, r4, r8;
shl.b32 r10, r22, 3;
cvt.u64.u32 rd2, r10;
and.b64 rd3, rd2, 504;
mov.u64 rd4, %65;
add.s64 rd5, rd4, rd3;
ld.global.v2.f32 {f610, f611}, [rd5];
mul.f32 f615, f611, f2335;
mul.f32 f616, f610, f2335;
mul.f32 f618, f611, f611;
mul.f32 f2320, f610, f610;
sub.f32 f619, f2320, f618;
mul.f32 f620, f611, f610;
fma.rn.f32 f621, f611, f610, f620;
mul.f32 f623, f621, f2334;
mul.f32 f624, f619, f2334;
mul.f32 f626, f611, f621;
mul.f32 f2319, f610, f619;
sub.f32 f627, f2319, f626;
mul.f32 f2318, f619, f554;
mul.f32 f628, f610, f621;
fma.rn.f32 f629, f611, f619, f628;
mul.f32 f631, f629, f2333;
mul.f32 f632, f627, f2333;
mul.f32 f2316, f610, f627;
mul.f32 f2317, f611, f629;
sub.f32 f635, f2316, f2317;
mul.f32 f2315, f627, f558;
mul.f32 f636, f610, f629;
fma.rn.f32 f637, f611, f627, f636;
mul.f32 f639, f637, f2332;
mul.f32 f640, f635, f2332;
mul.f32 f642, f611, f637;
mul.f32 f2314, f610, f635;
sub.f32 f643, f2314, f642;
mul.f32 f2313, f635, f562;
mul.f32 f644, f610, f637;
fma.rn.f32 f645, f611, f635, f644;
mul.f32 f647, f645, f2331;
mul.f32 f648, f643, f2331;
mul.f32 f2311, f610, f643;
mul.f32 f2312, f611, f645;
sub.f32 f651, f2311, f2312;
mul.f32 f2310, f643, f566;
mul.f32 f652, f610, f645;
fma.rn.f32 f653, f611, f643, f652;
mul.f32 f655, f653, f2330;
mul.f32 f656, f651, f2330;
mul.f32 f658, f611, f653;
mul.f32 f2309, f610, f651;
sub.f32 f659, f2309, f658;
mul.f32 f2308, f651, f570;
mul.f32 f660, f610, f653;
fma.rn.f32 f661, f611, f651, f660;
mul.f32 f663, f661, f2329;
mul.f32 f664, f659, f2329;
mul.f32 f666, f611, f661;
mul.f32 f2307, f610, f659;
sub.f32 f667, f2307, f666;
mul.f32 f2306, f659, f574;
mul.f32 f668, f610, f661;
fma.rn.f32 f669, f611, f659, f668;
mul.f32 f671, f669, f2328;
mul.f32 f672, f667, f2328;
mul.f32 f2304, f610, f667;
mul.f32 f2305, f611, f669;
sub.f32 f675, f2304, f2305;
mul.f32 f2303, f667, f578;
mul.f32 f676, f610, f669;
fma.rn.f32 f677, f611, f667, f676;
mul.f32 f679, f677, f2327;
mul.f32 f680, f675, f2327;
mul.f32 f682, f611, f677;
mul.f32 f2302, f610, f675;
sub.f32 f683, f2302, f682;
mul.f32 f2301, f675, f582;
mul.f32 f684, f610, f677;
fma.rn.f32 f685, f611, f675, f684;
mul.f32 f687, f685, f2326;
mul.f32 f688, f683, f2326;
mul.f32 f690, f611, f685;
mul.f32 f2300, f610, f683;
sub.f32 f691, f2300, f690;
mul.f32 f2299, f683, f586;
mul.f32 f692, f610, f685;
fma.rn.f32 f693, f611, f683, f692;
mul.f32 f695, f693, f2325;
mul.f32 f696, f691, f2325;
mul.f32 f2297, f610, f691;
mul.f32 f2298, f611, f693;
sub.f32 f699, f2297, f2298;
mul.f32 f2296, f691, f590;
mul.f32 f700, f610, f693;
fma.rn.f32 f701, f611, f691, f700;
mul.f32 f703, f701, f2324;
mul.f32 f704, f699, f2324;
mul.f32 f706, f611, f701;
mul.f32 f2295, f610, f699;
sub.f32 f707, f2295, f706;
mul.f32 f2294, f699, f594;
mul.f32 f708, f610, f701;
fma.rn.f32 f709, f611, f699, f708;
mul.f32 f711, f709, f2323;
mul.f32 f712, f707, f2323;
mul.f32 f2292, f610, f707;
mul.f32 f2293, f611, f709;
sub.f32 f715, f2292, f2293;
mul.f32 f2291, f707, f598;
mul.f32 f716, f610, f709;
fma.rn.f32 f717, f611, f707, f716;
mul.f32 f719, f717, f2322;
mul.f32 f720, f715, f2322;
mul.f32 f722, f611, f717;
mul.f32 f2290, f610, f715;
sub.f32 f723, f2290, f722;
mul.f32 f2289, f715, f602;
mul.f32 f724, f610, f717;
fma.rn.f32 f725, f611, f715, f724;
mul.f32 f727, f725, f2321;
mul.f32 f728, f723, f2321;
mul.f32 f730, f611, f725;
mul.f32 f2288, f610, f723;
sub.f32 f731, f2288, f730;
mul.f32 f2287, f723, f606;
mul.f32 f732, f610, f725;
fma.rn.f32 f733, f611, f723, f732;
sub.f32 f2286, f2414, f2361;
mul.f32 f735, f733, f2286;
mul.f32 f736, f731, f2286;
mul.f32 f2284, f610, f731;
mul.f32 f2285, f611, f733;
sub.f32 f739, f2284, f2285;
sub.f32 f2283, f272, f447;
mul.f32 f2282, f731, f2283;
mul.f32 f740, f610, f733;
fma.rn.f32 f741, f611, f731, f740;
mul.f32 f743, f741, f553;
mul.f32 f744, f739, f553;
mul.f32 f746, f611, f741;
mul.f32 f2281, f610, f739;
sub.f32 f747, f2281, f746;
mul.f32 f2280, f739, f552;
mul.f32 f748, f610, f741;
fma.rn.f32 f749, f611, f739, f748;
mul.f32 f751, f749, f557;
mul.f32 f752, f747, f557;
mul.f32 f754, f611, f749;
mul.f32 f2279, f610, f747;
sub.f32 f755, f2279, f754;
mul.f32 f2278, f747, f556;
mul.f32 f756, f610, f749;
fma.rn.f32 f757, f611, f747, f756;
mul.f32 f759, f757, f561;
mul.f32 f760, f755, f561;
mul.f32 f2276, f610, f755;
mul.f32 f2277, f611, f757;
sub.f32 f763, f2276, f2277;
mul.f32 f2275, f755, f560;
mul.f32 f764, f610, f757;
fma.rn.f32 f765, f611, f755, f764;
mul.f32 f767, f765, f565;
mul.f32 f768, f763, f565;
mul.f32 f770, f611, f765;
mul.f32 f2274, f610, f763;
sub.f32 f771, f2274, f770;
mul.f32 f2273, f763, f564;
mul.f32 f772, f610, f765;
fma.rn.f32 f773, f611, f763, f772;
mul.f32 f775, f773, f569;
mul.f32 f776, f771, f569;
mul.f32 f2271, f610, f771;
mul.f32 f2272, f611, f773;
sub.f32 f779, f2271, f2272;
mul.f32 f2270, f771, f568;
mul.f32 f780, f610, f773;
fma.rn.f32 f781, f611, f771, f780;
mul.f32 f783, f781, f573;
mul.f32 f784, f779, f573;
mul.f32 f786, f611, f781;
mul.f32 f2269, f610, f779;
sub.f32 f787, f2269, f786;
mul.f32 f2268, f779, f572;
mul.f32 f788, f610, f781;
fma.rn.f32 f789, f611, f779, f788;
mul.f32 f791, f789, f577;
mul.f32 f792, f787, f577;
mul.f32 f794, f611, f789;
mul.f32 f2267, f610, f787;
sub.f32 f795, f2267, f794;
mul.f32 f2266, f787, f576;
mul.f32 f796, f610, f789;
fma.rn.f32 f797, f611, f787, f796;
mul.f32 f799, f797, f581;
mul.f32 f800, f795, f581;
mul.f32 f2264, f610, f795;
mul.f32 f2265, f611, f797;
sub.f32 f803, f2264, f2265;
mul.f32 f2263, f795, f580;
mul.f32 f804, f610, f797;
fma.rn.f32 f805, f611, f795, f804;
mul.f32 f807, f805, f585;
mul.f32 f808, f803, f585;
mul.f32 f810, f611, f805;
mul.f32 f2262, f610, f803;
sub.f32 f811, f2262, f810;
mul.f32 f2261, f803, f584;
mul.f32 f812, f610, f805;
fma.rn.f32 f813, f611, f803, f812;
mul.f32 f815, f813, f589;
mul.f32 f816, f811, f589;
mul.f32 f818, f611, f813;
mul.f32 f2260, f610, f811;
sub.f32 f819, f2260, f818;
mul.f32 f2259, f811, f588;
mul.f32 f820, f610, f813;
fma.rn.f32 f821, f611, f811, f820;
mul.f32 f823, f821, f593;
mul.f32 f824, f819, f593;
mul.f32 f2257, f610, f819;
mul.f32 f2258, f611, f821;
sub.f32 f827, f2257, f2258;
mul.f32 f2256, f819, f592;
mul.f32 f828, f610, f821;
fma.rn.f32 f829, f611, f819, f828;
mul.f32 f831, f829, f597;
mul.f32 f832, f827, f597;
mul.f32 f834, f611, f829;
mul.f32 f2255, f610, f827;
sub.f32 f835, f2255, f834;
mul.f32 f2254, f827, f596;
mul.f32 f836, f610, f829;
fma.rn.f32 f837, f611, f827, f836;
mul.f32 f839, f837, f601;
mul.f32 f840, f835, f601;
mul.f32 f2252, f610, f835;
mul.f32 f2253, f611, f837;
sub.f32 f843, f2252, f2253;
mul.f32 f2251, f835, f600;
mul.f32 f844, f610, f837;
fma.rn.f32 f845, f611, f835, f844;
mul.f32 f847, f845, f605;
mul.f32 f848, f843, f605;
mul.f32 f850, f611, f845;
mul.f32 f2250, f610, f843;
sub.f32 f851, f2250, f850;
mul.f32 f2249, f610, f550;
mul.f32 f852, f610, f845;
mul.f32 f2248, f843, f604;
fma.rn.f32 f853, f611, f843, f852;
mul.f32 f854, f851, f608;
mul.f32 f855, f853, f609;
mul.f32 f856, f851, f609;
mov.u32 r33, %tid.x;
shl.b32 r32, r33, 8;
barrier.sync 0;
and.b32 r11, r32, 16128;
add.s32 r12, r9, r11;
add.f32 f857, f2414, f2361;
sub.f32 f2462, f272, f447;
add.f32 f858, f272, f447;
mov.u32 r40, %tid.x;
shl.b32 r28, r40, 3;
fma.rn.f32 f859, f611, f550, f616;
sub.f32 f860, f2249, f615;
st.shared.v4.f32 [r12], {f858, f857, f860, f859};
fma.rn.f32 f861, f621, f554, f624;
sub.f32 f862, f2318, f623;
fma.rn.f32 f863, f629, f558, f632;
sub.f32 f864, f2315, f631;
st.shared.v4.f32 [r12+16], {f862, f861, f864, f863};
fma.rn.f32 f865, f637, f562, f640;
sub.f32 f866, f2313, f639;
sub.f32 f867, f2310, f647;
fma.rn.f32 f868, f645, f566, f648;
st.shared.v4.f32 [r12+32], {f866, f865, f867, f868};
fma.rn.f32 f869, f653, f570, f656;
sub.f32 f870, f2308, f655;
fma.rn.f32 f871, f661, f574, f664;
sub.f32 f872, f2306, f663;
st.shared.v4.f32 [r12+48], {f870, f869, f872, f871};
fma.rn.f32 f873, f669, f578, f672;
sub.f32 f874, f2303, f671;
fma.rn.f32 f875, f677, f582, f680;
sub.f32 f876, f2301, f679;
st.shared.v4.f32 [r12+64], {f874, f873, f876, f875};
fma.rn.f32 f877, f685, f586, f688;
sub.f32 f878, f2299, f687;
fma.rn.f32 f879, f693, f590, f696;
sub.f32 f880, f2296, f695;
st.shared.v4.f32 [r12+80], {f878, f877, f880, f879};
fma.rn.f32 f881, f701, f594, f704;
sub.f32 f882, f2294, f703;
fma.rn.f32 f883, f709, f598, f712;
sub.f32 f884, f2291, f711;
st.shared.v4.f32 [r12+96], {f882, f881, f884, f883};
fma.rn.f32 f885, f717, f602, f720;
sub.f32 f886, f2289, f719;
fma.rn.f32 f887, f725, f606, f728;
sub.f32 f888, f2287, f727;
st.shared.v4.f32 [r12+112], {f886, f885, f888, f887};
fma.rn.f32 f889, f733, f2462, f736;
sub.f32 f890, f2282, f735;
fma.rn.f32 f891, f741, f552, f744;
sub.f32 f892, f2280, f743;
st.shared.v4.f32 [r12+128], {f890, f889, f892, f891};
fma.rn.f32 f893, f749, f556, f752;
sub.f32 f894, f2278, f751;
fma.rn.f32 f895, f757, f560, f760;
sub.f32 f896, f2275, f759;
st.shared.v4.f32 [r12+144], {f894, f893, f896, f895};
fma.rn.f32 f897, f765, f564, f768;
sub.f32 f898, f2273, f767;
fma.rn.f32 f899, f773, f568, f776;
sub.f32 f900, f2270, f775;
st.shared.v4.f32 [r12+160], {f898, f897, f900, f899};
fma.rn.f32 f901, f781, f572, f784;
sub.f32 f902, f2268, f783;
fma.rn.f32 f903, f789, f576, f792;
sub.f32 f904, f2266, f791;
st.shared.v4.f32 [r12+176], {f902, f901, f904, f903};
fma.rn.f32 f905, f797, f580, f800;
sub.f32 f906, f2263, f799;
fma.rn.f32 f907, f805, f584, f808;
sub.f32 f908, f2261, f807;
st.shared.v4.f32 [r12+192], {f906, f905, f908, f907};
fma.rn.f32 f909, f813, f588, f816;
sub.f32 f910, f2259, f815;
fma.rn.f32 f911, f821, f592, f824;
sub.f32 f912, f2256, f823;
st.shared.v4.f32 [r12+208], {f910, f909, f912, f911};
fma.rn.f32 f913, f829, f596, f832;
sub.f32 f914, f2254, f831;
fma.rn.f32 f915, f837, f600, f840;
sub.f32 f916, f2251, f839;
st.shared.v4.f32 [r12+224], {f914, f913, f916, f915};
fma.rn.f32 f917, f845, f604, f848;
sub.f32 f918, f2248, f847;
fma.rn.f32 f919, f853, f608, f856;
sub.f32 f920, f854, f855;
st.shared.v4.f32 [r12+240], {f918, f917, f920, f919};
barrier.sync 0;
and.b32 r21, r40, 63;
mad.lo.s32 r13, r21, -248, r12;
ld.shared.v2.f32 {f921, f922}, [r13];
ld.shared.v2.f32 {f925, f926}, [r13+512];
ld.shared.v2.f32 {f929, f930}, [r13+1024];
ld.shared.v2.f32 {f933, f934}, [r13+1536];
ld.shared.v2.f32 {f937, f938}, [r13+2048];
ld.shared.v2.f32 {f941, f942}, [r13+2560];
ld.shared.v2.f32 {f945, f946}, [r13+3072];
ld.shared.v2.f32 {f949, f950}, [r13+3584];
ld.shared.v2.f32 {f953, f954}, [r13+4096];
ld.shared.v2.f32 {f957, f958}, [r13+4608];
ld.shared.v2.f32 {f961, f962}, [r13+5120];
ld.shared.v2.f32 {f965, f966}, [r13+5632];
ld.shared.v2.f32 {f969, f970}, [r13+6144];
ld.shared.v2.f32 {f973, f974}, [r13+6656];
ld.shared.v2.f32 {f977, f978}, [r13+7168];
ld.shared.v2.f32 {f981, f982}, [r13+7680];
ld.shared.v2.f32 {f985, f986}, [r13+8192];
ld.shared.v2.f32 {f989, f990}, [r13+8704];
ld.shared.v2.f32 {f993, f994}, [r13+9216];
ld.shared.v2.f32 {f997, f998}, [r13+9728];
ld.shared.v2.f32 {f1001, f1002}, [r13+10240];
ld.shared.v2.f32 {f1005, f1006}, [r13+10752];
ld.shared.v2.f32 {f1009, f1010}, [r13+11264];
ld.shared.v2.f32 {f1013, f1014}, [r13+11776];
ld.shared.v2.f32 {f1017, f1018}, [r13+12288];
ld.shared.v2.f32 {f1021, f1022}, [r13+12800];
ld.shared.v2.f32 {f1025, f1026}, [r13+13312];
ld.shared.v2.f32 {f1029, f1030}, [r13+13824];
ld.shared.v2.f32 {f1033, f1034}, [r13+14336];
ld.shared.v2.f32 {f1037, f1038}, [r13+14848];
ld.shared.v2.f32 {f1041, f1042}, [r13+15360];
ld.shared.v2.f32 {f1045, f1046}, [r13+15872];
add.f32 f1049, f921, f985;
sub.f32 f1051, f921, f985;
add.f32 f2247, f922, f986;
sub.f32 f1052, f922, f986;
add.f32 f1053, f953, f1017;
sub.f32 f1055, f953, f1017;
add.f32 f2246, f954, f1018;
sub.f32 f1056, f954, f1018;
add.f32 f1057, f1049, f1053;
sub.f32 f1059, f1049, f1053;
add.f32 f2245, f2247, f2246;
sub.f32 f1060, f2247, f2246;
add.f32 f1061, f1051, f1056;
sub.f32 f1063, f1051, f1056;
sub.f32 f2244, f1052, f1055;
add.f32 f1064, f1052, f1055;
add.f32 f1065, f937, f1001;
sub.f32 f1067, f937, f1001;
add.f32 f2243, f938, f1002;
sub.f32 f1068, f938, f1002;
add.f32 f1069, f969, f1033;
sub.f32 f1071, f969, f1033;
add.f32 f2242, f970, f1034;
sub.f32 f1072, f970, f1034;
add.f32 f1073, f1065, f1069;
sub.f32 f1075, f1065, f1069;
add.f32 f2241, f2243, f2242;
sub.f32 f1076, f2243, f2242;
add.f32 f1077, f1067, f1072;
sub.f32 f1079, f1067, f1072;
sub.f32 f2240, f1068, f1071;
add.f32 f1080, f1068, f1071;
mul.f32 f1082, f2240, 0fBF3504F3;
mul.f32 f2239, f1077, 0f3F3504F3;
sub.f32 f1083, f2239, f1082;
mul.f32 f1084, f2240, 0f3F3504F3;
fma.rn.f32 f1085, f1077, 0fBF3504F3, f1084;
mul.f32 f1086, f1079, 0fBF3504F3;
mul.f32 f1087, f1080, 0fBF3504F3;
sub.f32 f1088, f1086, f1087;
add.f32 f1089, f1086, f1087;
add.f32 f1090, f1057, f1073;
sub.f32 f1092, f1057, f1073;
add.f32 f2238, f2245, f2241;
sub.f32 f1093, f2245, f2241;
add.f32 f1094, f1061, f1083;
sub.f32 f1096, f1061, f1083;
add.f32 f2237, f2244, f1085;
sub.f32 f1097, f2244, f1085;
add.f32 f1098, f1059, f1076;
sub.f32 f1100, f1059, f1076;
sub.f32 f2236, f1060, f1075;
add.f32 f1101, f1060, f1075;
add.f32 f1102, f1063, f1088;
sub.f32 f1104, f1063, f1088;
add.f32 f2235, f1064, f1089;
sub.f32 f1105, f1064, f1089;
add.f32 f1106, f929, f993;
sub.f32 f1108, f929, f993;
add.f32 f2234, f930, f994;
sub.f32 f1109, f930, f994;
add.f32 f1110, f961, f1025;
sub.f32 f1112, f961, f1025;
add.f32 f2233, f962, f1026;
sub.f32 f1113, f962, f1026;
add.f32 f1114, f1106, f1110;
sub.f32 f1116, f1106, f1110;
add.f32 f2232, f2234, f2233;
sub.f32 f1117, f2234, f2233;
add.f32 f1118, f1108, f1113;
sub.f32 f1120, f1108, f1113;
sub.f32 f2231, f1109, f1112;
add.f32 f1121, f1109, f1112;
add.f32 f1122, f945, f1009;
sub.f32 f1124, f945, f1009;
add.f32 f2230, f946, f1010;
sub.f32 f1125, f946, f1010;
add.f32 f1126, f977, f1041;
sub.f32 f1128, f977, f1041;
add.f32 f2229, f978, f1042;
sub.f32 f1129, f978, f1042;
add.f32 f1130, f1122, f1126;
sub.f32 f1132, f1122, f1126;
add.f32 f2228, f2230, f2229;
sub.f32 f1133, f2230, f2229;
add.f32 f1134, f1124, f1129;
sub.f32 f1136, f1124, f1129;
sub.f32 f2227, f1125, f1128;
add.f32 f1137, f1125, f1128;
mul.f32 f1139, f2227, 0fBF3504F3;
mul.f32 f2226, f1134, 0f3F3504F3;
sub.f32 f1140, f2226, f1139;
mul.f32 f1141, f2227, 0f3F3504F3;
fma.rn.f32 f1142, f1134, 0fBF3504F3, f1141;
mul.f32 f1143, f1136, 0fBF3504F3;
mul.f32 f1144, f1137, 0fBF3504F3;
sub.f32 f1145, f1143, f1144;
add.f32 f1146, f1143, f1144;
add.f32 f1147, f1114, f1130;
sub.f32 f1149, f1114, f1130;
add.f32 f2225, f2232, f2228;
sub.f32 f1150, f2232, f2228;
add.f32 f1151, f1118, f1140;
sub.f32 f1153, f1118, f1140;
add.f32 f2224, f2231, f1142;
sub.f32 f1154, f2231, f1142;
add.f32 f1155, f1116, f1133;
sub.f32 f1157, f1116, f1133;
sub.f32 f2223, f1117, f1132;
add.f32 f1158, f1117, f1132;
add.f32 f1159, f1120, f1145;
sub.f32 f1161, f1120, f1145;
add.f32 f2222, f1121, f1146;
sub.f32 f1162, f1121, f1146;
mul.f32 f2220, f1151, 0f3F6C835E;
mul.f32 f2221, f2224, 0fBEC3EF15;
sub.f32 f1165, f2220, f2221;
mul.f32 f1166, f2224, 0f3F6C835E;
fma.rn.f32 f1167, f1151, 0fBEC3EF15, f1166;
mul.f32 f2218, f1155, 0f3F3504F3;
mul.f32 f2219, f2223, 0fBF3504F3;
sub.f32 f1170, f2218, f2219;
mul.f32 f1171, f2223, 0f3F3504F3;
fma.rn.f32 f1172, f1155, 0fBF3504F3, f1171;
mul.f32 f1174, f2222, 0fBF6C835E;
mul.f32 f2217, f1159, 0f3EC3EF15;
sub.f32 f1175, f2217, f1174;
mul.f32 f1176, f2222, 0f3EC3EF15;
fma.rn.f32 f1177, f1159, 0fBF6C835E, f1176;
mul.f32 f1179, f1154, 0fBF6C835E;
mul.f32 f2216, f1153, 0fBEC3EF15;
sub.f32 f1180, f2216, f1179;
mul.f32 f1181, f1154, 0fBEC3EF15;
fma.rn.f32 f1182, f1153, 0fBF6C835E, f1181;
mul.f32 f1183, f1157, 0fBF3504F3;
mul.f32 f1184, f1158, 0fBF3504F3;
sub.f32 f1185, f1183, f1184;
add.f32 f1186, f1183, f1184;
mul.f32 f2214, f1161, 0fBF6C835E;
mul.f32 f2215, f1162, 0fBEC3EF15;
sub.f32 f1189, f2214, f2215;
mul.f32 f1190, f1162, 0fBF6C835E;
fma.rn.f32 f1191, f1161, 0fBEC3EF15, f1190;
add.f32 f1192, f1090, f1147;
sub.f32 f1194, f1090, f1147;
add.f32 f2213, f2238, f2225;
sub.f32 f1195, f2238, f2225;
add.f32 f1196, f1094, f1165;
sub.f32 f1198, f1094, f1165;
add.f32 f2212, f2237, f1167;
sub.f32 f1199, f2237, f1167;
add.f32 f1200, f1098, f1170;
sub.f32 f1202, f1098, f1170;
add.f32 f2211, f2236, f1172;
sub.f32 f1203, f2236, f1172;
add.f32 f1204, f1102, f1175;
sub.f32 f1206, f1102, f1175;
add.f32 f2210, f2235, f1177;
sub.f32 f1207, f2235, f1177;
add.f32 f1208, f1092, f1150;
sub.f32 f1210, f1092, f1150;
sub.f32 f2209, f1093, f1149;
add.f32 f1211, f1093, f1149;
add.f32 f1212, f1096, f1180;
sub.f32 f1214, f1096, f1180;
add.f32 f2208, f1097, f1182;
sub.f32 f1215, f1097, f1182;
add.f32 f1216, f1100, f1185;
sub.f32 f1218, f1100, f1185;
add.f32 f2207, f1101, f1186;
sub.f32 f1219, f1101, f1186;
add.f32 f1220, f1104, f1189;
sub.f32 f1222, f1104, f1189;
add.f32 f2206, f1105, f1191;
sub.f32 f1223, f1105, f1191;
add.f32 f1224, f925, f989;
sub.f32 f1226, f925, f989;
add.f32 f2205, f926, f990;
sub.f32 f1227, f926, f990;
add.f32 f1228, f957, f1021;
sub.f32 f1230, f957, f1021;
add.f32 f2204, f958, f1022;
sub.f32 f1231, f958, f1022;
add.f32 f1232, f1224, f1228;
sub.f32 f1234, f1224, f1228;
add.f32 f2203, f2205, f2204;
sub.f32 f1235, f2205, f2204;
add.f32 f1236, f1226, f1231;
sub.f32 f1238, f1226, f1231;
sub.f32 f2202, f1227, f1230;
add.f32 f1239, f1227, f1230;
add.f32 f1240, f941, f1005;
sub.f32 f1242, f941, f1005;
add.f32 f2201, f942, f1006;
sub.f32 f1243, f942, f1006;
add.f32 f1244, f973, f1037;
sub.f32 f1246, f973, f1037;
add.f32 f2200, f974, f1038;
sub.f32 f1247, f974, f1038;
add.f32 f1248, f1240, f1244;
sub.f32 f1250, f1240, f1244;
add.f32 f2199, f2201, f2200;
sub.f32 f1251, f2201, f2200;
add.f32 f1252, f1242, f1247;
sub.f32 f1254, f1242, f1247;
sub.f32 f2198, f1243, f1246;
add.f32 f1255, f1243, f1246;
mul.f32 f1257, f2198, 0fBF3504F3;
mul.f32 f2197, f1252, 0f3F3504F3;
sub.f32 f1258, f2197, f1257;
mul.f32 f1259, f2198, 0f3F3504F3;
fma.rn.f32 f1260, f1252, 0fBF3504F3, f1259;
mul.f32 f1261, f1254, 0fBF3504F3;
mul.f32 f1262, f1255, 0fBF3504F3;
sub.f32 f1263, f1261, f1262;
add.f32 f1264, f1261, f1262;
add.f32 f1265, f1232, f1248;
sub.f32 f1267, f1232, f1248;
add.f32 f2196, f2203, f2199;
sub.f32 f1268, f2203, f2199;
add.f32 f1269, f1236, f1258;
sub.f32 f1271, f1236, f1258;
add.f32 f2195, f2202, f1260;
sub.f32 f1272, f2202, f1260;
add.f32 f1273, f1234, f1251;
sub.f32 f1275, f1234, f1251;
sub.f32 f2194, f1235, f1250;
add.f32 f1276, f1235, f1250;
add.f32 f1277, f1238, f1263;
sub.f32 f1279, f1238, f1263;
add.f32 f2193, f1239, f1264;
sub.f32 f1280, f1239, f1264;
add.f32 f1281, f933, f997;
sub.f32 f1283, f933, f997;
add.f32 f2192, f934, f998;
sub.f32 f1284, f934, f998;
add.f32 f1285, f965, f1029;
sub.f32 f1287, f965, f1029;
add.f32 f2191, f966, f1030;
sub.f32 f1288, f966, f1030;
add.f32 f1289, f1281, f1285;
sub.f32 f1291, f1281, f1285;
add.f32 f2190, f2192, f2191;
sub.f32 f1292, f2192, f2191;
add.f32 f1293, f1283, f1288;
sub.f32 f1295, f1283, f1288;
sub.f32 f2189, f1284, f1287;
add.f32 f1296, f1284, f1287;
add.f32 f1297, f949, f1013;
sub.f32 f1299, f949, f1013;
add.f32 f2188, f950, f1014;
sub.f32 f1300, f950, f1014;
add.f32 f1301, f981, f1045;
sub.f32 f1303, f981, f1045;
add.f32 f2187, f982, f1046;
sub.f32 f1304, f982, f1046;
add.f32 f1305, f1297, f1301;
sub.f32 f1307, f1297, f1301;
add.f32 f2186, f2188, f2187;
sub.f32 f1308, f2188, f2187;
add.f32 f1309, f1299, f1304;
sub.f32 f1311, f1299, f1304;
sub.f32 f2185, f1300, f1303;
add.f32 f1312, f1300, f1303;
mul.f32 f1314, f2185, 0fBF3504F3;
mul.f32 f2184, f1309, 0f3F3504F3;
sub.f32 f1315, f2184, f1314;
mul.f32 f1316, f2185, 0f3F3504F3;
fma.rn.f32 f1317, f1309, 0fBF3504F3, f1316;
mul.f32 f1318, f1311, 0fBF3504F3;
mul.f32 f1319, f1312, 0fBF3504F3;
sub.f32 f1320, f1318, f1319;
add.f32 f1321, f1318, f1319;
add.f32 f1322, f1289, f1305;
sub.f32 f1324, f1289, f1305;
add.f32 f2183, f2190, f2186;
sub.f32 f1325, f2190, f2186;
add.f32 f1326, f1293, f1315;
sub.f32 f1328, f1293, f1315;
add.f32 f2182, f2189, f1317;
sub.f32 f1329, f2189, f1317;
add.f32 f1330, f1291, f1308;
sub.f32 f1332, f1291, f1308;
sub.f32 f2181, f1292, f1307;
add.f32 f1333, f1292, f1307;
add.f32 f1334, f1295, f1320;
sub.f32 f1336, f1295, f1320;
add.f32 f2180, f1296, f1321;
sub.f32 f1337, f1296, f1321;
mul.f32 f2178, f1326, 0f3F6C835E;
mul.f32 f2179, f2182, 0fBEC3EF15;
sub.f32 f1340, f2178, f2179;
mul.f32 f1341, f2182, 0f3F6C835E;
fma.rn.f32 f1342, f1326, 0fBEC3EF15, f1341;
mul.f32 f2176, f1330, 0f3F3504F3;
mul.f32 f2177, f2181, 0fBF3504F3;
sub.f32 f1345, f2176, f2177;
mul.f32 f1346, f2181, 0f3F3504F3;
fma.rn.f32 f1347, f1330, 0fBF3504F3, f1346;
mul.f32 f2174, f1334, 0f3EC3EF15;
mul.f32 f2175, f2180, 0fBF6C835E;
sub.f32 f1350, f2174, f2175;
mul.f32 f1351, f2180, 0f3EC3EF15;
fma.rn.f32 f1352, f1334, 0fBF6C835E, f1351;
mul.f32 f2172, f1328, 0fBEC3EF15;
mul.f32 f2173, f1329, 0fBF6C835E;
sub.f32 f1355, f2172, f2173;
mul.f32 f1356, f1329, 0fBEC3EF15;
fma.rn.f32 f1357, f1328, 0fBF6C835E, f1356;
mul.f32 f1358, f1332, 0fBF3504F3;
mul.f32 f1359, f1333, 0fBF3504F3;
sub.f32 f1360, f1358, f1359;
add.f32 f1361, f1358, f1359;
mul.f32 f2170, f1336, 0fBF6C835E;
mul.f32 f2171, f1337, 0fBEC3EF15;
sub.f32 f1364, f2170, f2171;
mul.f32 f1365, f1337, 0fBF6C835E;
fma.rn.f32 f1366, f1336, 0fBEC3EF15, f1365;
add.f32 f1367, f1265, f1322;
sub.f32 f1369, f1265, f1322;
add.f32 f2169, f2196, f2183;
sub.f32 f1370, f2196, f2183;
add.f32 f1371, f1269, f1340;
sub.f32 f1373, f1269, f1340;
add.f32 f2168, f2195, f1342;
sub.f32 f1374, f2195, f1342;
add.f32 f1375, f1273, f1345;
sub.f32 f1377, f1273, f1345;
add.f32 f2167, f2194, f1347;
sub.f32 f1378, f2194, f1347;
add.f32 f1379, f1277, f1350;
sub.f32 f1381, f1277, f1350;
add.f32 f2166, f2193, f1352;
sub.f32 f1382, f2193, f1352;
add.f32 f1383, f1267, f1325;
sub.f32 f1385, f1267, f1325;
sub.f32 f2165, f1268, f1324;
add.f32 f1386, f1268, f1324;
add.f32 f1387, f1271, f1355;
sub.f32 f1389, f1271, f1355;
add.f32 f2164, f1272, f1357;
sub.f32 f1390, f1272, f1357;
add.f32 f1391, f1275, f1360;
sub.f32 f1393, f1275, f1360;
add.f32 f2163, f1276, f1361;
sub.f32 f1394, f1276, f1361;
add.f32 f1395, f1279, f1364;
sub.f32 f1397, f1279, f1364;
add.f32 f2162, f1280, f1366;
sub.f32 f1398, f1280, f1366;
mul.f32 f1400, f2168, 0fBE47C5C2;
mul.f32 f2161, f1371, 0f3F7B14BE;
sub.f32 f1401, f2161, f1400;
mul.f32 f1402, f2168, 0f3F7B14BE;
fma.rn.f32 f1403, f1371, 0fBE47C5C2, f1402;
mul.f32 f1405, f2167, 0fBEC3EF15;
mul.f32 f2160, f1375, 0f3F6C835E;
sub.f32 f1406, f2160, f1405;
mul.f32 f1407, f2167, 0f3F6C835E;
fma.rn.f32 f1408, f1375, 0fBEC3EF15, f1407;
mul.f32 f2158, f1379, 0f3F54DB31;
mul.f32 f2159, f2166, 0fBF0E39DA;
sub.f32 f1411, f2158, f2159;
mul.f32 f1412, f2166, 0f3F54DB31;
fma.rn.f32 f1413, f1379, 0fBF0E39DA, f1412;
mul.f32 f2156, f1383, 0f3F3504F3;
mul.f32 f2157, f2165, 0fBF3504F3;
sub.f32 f1416, f2156, f2157;
mul.f32 f1417, f2165, 0f3F3504F3;
fma.rn.f32 f1418, f1383, 0fBF3504F3, f1417;
mul.f32 f2154, f1387, 0f3F0E39DA;
mul.f32 f2155, f2164, 0fBF54DB31;
sub.f32 f1421, f2154, f2155;
mul.f32 f1422, f2164, 0f3F0E39DA;
fma.rn.f32 f1423, f1387, 0fBF54DB31, f1422;
mul.f32 f2152, f1391, 0f3EC3EF15;
mul.f32 f2153, f2163, 0fBF6C835E;
sub.f32 f1426, f2152, f2153;
mul.f32 f1427, f2163, 0f3EC3EF15;
fma.rn.f32 f1428, f1391, 0fBF6C835E, f1427;
mul.f32 f1430, f2162, 0fBF7B14BE;
mul.f32 f2151, f1395, 0f3E47C5C2;
sub.f32 f1431, f2151, f1430;
mul.f32 f1432, f2162, 0f3E47C5C2;
fma.rn.f32 f1433, f1395, 0fBF7B14BE, f1432;
mul.f32 f1435, f1374, 0fBF7B14BE;
mul.f32 f2150, f1373, 0fBE47C5C2;
sub.f32 f1436, f2150, f1435;
mul.f32 f1437, f1374, 0fBE47C5C2;
fma.rn.f32 f1438, f1373, 0fBF7B14BE, f1437;
mul.f32 f1440, f1378, 0fBF6C835E;
mul.f32 f2149, f1377, 0fBEC3EF15;
sub.f32 f1441, f2149, f1440;
mul.f32 f1442, f1378, 0fBEC3EF15;
fma.rn.f32 f1443, f1377, 0fBF6C835E, f1442;
mul.f32 f1445, f1382, 0fBF54DB31;
mul.f32 f2148, f1381, 0fBF0E39DA;
sub.f32 f1446, f2148, f1445;
mul.f32 f1447, f1382, 0fBF0E39DA;
fma.rn.f32 f1448, f1381, 0fBF54DB31, f1447;
mul.f32 f1449, f1385, 0fBF3504F3;
mul.f32 f1450, f1386, 0fBF3504F3;
sub.f32 f1451, f1449, f1450;
add.f32 f1452, f1449, f1450;
mul.f32 f1454, f1390, 0fBF0E39DA;
mul.f32 f2147, f1389, 0fBF54DB31;
sub.f32 f1455, f2147, f1454;
mul.f32 f1456, f1390, 0fBF54DB31;
fma.rn.f32 f1457, f1389, 0fBF0E39DA, f1456;
mul.f32 f1459, f1394, 0fBEC3EF15;
mul.f32 f2146, f1393, 0fBF6C835E;
sub.f32 f1460, f2146, f1459;
mul.f32 f1461, f1394, 0fBF6C835E;
fma.rn.f32 f1462, f1393, 0fBEC3EF15, f1461;
mul.f32 f1464, f1398, 0fBE47C5C2;
mul.f32 f2145, f1397, 0fBF7B14BE;
sub.f32 f1465, f2145, f1464;
mul.f32 f1466, f1398, 0fBF7B14BE;
fma.rn.f32 f1467, f1397, 0fBE47C5C2, f1466;
add.f32 f1470, f1196, f1401;
sub.f32 f1472, f1196, f1401;
add.f32 f2144, f2212, f1403;
sub.f32 f1473, f2212, f1403;
add.f32 f1474, f1200, f1406;
sub.f32 f1476, f1200, f1406;
add.f32 f2143, f2211, f1408;
sub.f32 f1477, f2211, f1408;
add.f32 f1478, f1204, f1411;
sub.f32 f1480, f1204, f1411;
add.f32 f2142, f2210, f1413;
sub.f32 f1481, f2210, f1413;
add.f32 f1482, f1208, f1416;
sub.f32 f1484, f1208, f1416;
add.f32 f2141, f2209, f1418;
sub.f32 f1485, f2209, f1418;
add.f32 f1486, f1212, f1421;
sub.f32 f1488, f1212, f1421;
add.f32 f2140, f2208, f1423;
sub.f32 f1489, f2208, f1423;
add.f32 f1490, f1216, f1426;
sub.f32 f1492, f1216, f1426;
add.f32 f2139, f2207, f1428;
sub.f32 f1493, f2207, f1428;
add.f32 f1494, f1220, f1431;
sub.f32 f1496, f1220, f1431;
add.f32 f2138, f2206, f1433;
sub.f32 f1497, f2206, f1433;
add.f32 f1498, f1194, f1370;
sub.f32 f1500, f1194, f1370;
sub.f32 f2137, f1195, f1369;
add.f32 f1501, f1195, f1369;
add.f32 f1502, f1198, f1436;
sub.f32 f1504, f1198, f1436;
add.f32 f2136, f1199, f1438;
sub.f32 f1505, f1199, f1438;
add.f32 f1506, f1202, f1441;
sub.f32 f1508, f1202, f1441;
add.f32 f2135, f1203, f1443;
sub.f32 f1509, f1203, f1443;
add.f32 f1510, f1206, f1446;
sub.f32 f1512, f1206, f1446;
add.f32 f2134, f1207, f1448;
sub.f32 f1513, f1207, f1448;
add.f32 f1514, f1210, f1451;
sub.f32 f1516, f1210, f1451;
add.f32 f2133, f1211, f1452;
sub.f32 f1517, f1211, f1452;
add.f32 f1518, f1214, f1455;
sub.f32 f1520, f1214, f1455;
add.f32 f2132, f1215, f1457;
sub.f32 f1521, f1215, f1457;
add.f32 f1522, f1218, f1460;
sub.f32 f1524, f1218, f1460;
add.f32 f2131, f1219, f1462;
sub.f32 f1525, f1219, f1462;
add.f32 f1526, f1222, f1465;
sub.f32 f1528, f1222, f1465;
add.f32 f2130, f1223, f1467;
sub.f32 f1529, f1223, f1467;
and.b32 r14, r40, 32;
bfe.u32 r15, r40, 5, 1;
mul.wide.u32 rd6, r15, 8;
mov.u64 rd7, %66;
add.s64 rd8, rd7, rd6;
ld.global.v2.f32 {f1530, f1531}, [rd8];
mul.f32 f1535, f1531, f2144;
mul.f32 f1536, f1530, f2144;
mul.f32 f2128, f1530, f1530;
mul.f32 f2129, f1531, f1531;
sub.f32 f1539, f2128, f2129;
mul.f32 f1540, f1531, f1530;
fma.rn.f32 f1541, f1531, f1530, f1540;
mul.f32 f1543, f1541, f2143;
mul.f32 f1544, f1539, f2143;
mul.f32 f1546, f1531, f1541;
mul.f32 f2127, f1530, f1539;
sub.f32 f1547, f2127, f1546;
mul.f32 f2126, f1539, f1474;
mul.f32 f1548, f1530, f1541;
fma.rn.f32 f1549, f1531, f1539, f1548;
mul.f32 f1551, f1549, f2142;
mul.f32 f1552, f1547, f2142;
mul.f32 f1554, f1531, f1549;
mul.f32 f2125, f1530, f1547;
sub.f32 f1555, f2125, f1554;
mul.f32 f2124, f1547, f1478;
mul.f32 f1556, f1530, f1549;
fma.rn.f32 f1557, f1531, f1547, f1556;
mul.f32 f1559, f1557, f2141;
mul.f32 f1560, f1555, f2141;
mul.f32 f2122, f1530, f1555;
mul.f32 f2123, f1531, f1557;
sub.f32 f1563, f2122, f2123;
mul.f32 f2121, f1555, f1482;
mul.f32 f1564, f1530, f1557;
fma.rn.f32 f1565, f1531, f1555, f1564;
mul.f32 f1567, f1565, f2140;
mul.f32 f1568, f1563, f2140;
mul.f32 f1570, f1531, f1565;
mul.f32 f2120, f1530, f1563;
sub.f32 f1571, f2120, f1570;
mul.f32 f2119, f1563, f1486;
mul.f32 f1572, f1530, f1565;
fma.rn.f32 f1573, f1531, f1563, f1572;
mul.f32 f1575, f1573, f2139;
mul.f32 f1576, f1571, f2139;
mul.f32 f1578, f1531, f1573;
mul.f32 f2118, f1530, f1571;
sub.f32 f1579, f2118, f1578;
mul.f32 f2117, f1571, f1490;
mul.f32 f1580, f1530, f1573;
fma.rn.f32 f1581, f1531, f1571, f1580;
mul.f32 f1583, f1581, f2138;
mul.f32 f1584, f1579, f2138;
mul.f32 f2115, f1530, f1579;
mul.f32 f2116, f1531, f1581;
sub.f32 f1587, f2115, f2116;
mul.f32 f2114, f1579, f1494;
mul.f32 f1588, f1530, f1581;
fma.rn.f32 f1589, f1531, f1579, f1588;
mul.f32 f1591, f1589, f2137;
mul.f32 f1592, f1587, f2137;
mul.f32 f1594, f1531, f1589;
mul.f32 f2113, f1530, f1587;
sub.f32 f1595, f2113, f1594;
mul.f32 f2112, f1587, f1498;
mul.f32 f1596, f1530, f1589;
fma.rn.f32 f1597, f1531, f1587, f1596;
mul.f32 f1599, f1597, f2136;
mul.f32 f1600, f1595, f2136;
mul.f32 f2110, f1530, f1595;
mul.f32 f2111, f1531, f1597;
sub.f32 f1603, f2110, f2111;
mul.f32 f2109, f1595, f1502;
mul.f32 f1604, f1530, f1597;
fma.rn.f32 f1605, f1531, f1595, f1604;
mul.f32 f1607, f1605, f2135;
mul.f32 f1608, f1603, f2135;
mul.f32 f1610, f1531, f1605;
mul.f32 f2108, f1530, f1603;
sub.f32 f1611, f2108, f1610;
mul.f32 f2107, f1603, f1506;
mul.f32 f1612, f1530, f1605;
fma.rn.f32 f1613, f1531, f1603, f1612;
mul.f32 f1615, f1613, f2134;
mul.f32 f1616, f1611, f2134;
mul.f32 f1618, f1531, f1613;
mul.f32 f2106, f1530, f1611;
sub.f32 f1619, f2106, f1618;
mul.f32 f2105, f1611, f1510;
mul.f32 f1620, f1530, f1613;
fma.rn.f32 f1621, f1531, f1611, f1620;
mul.f32 f1623, f1621, f2133;
mul.f32 f1624, f1619, f2133;
mul.f32 f2103, f1530, f1619;
mul.f32 f2104, f1531, f1621;
sub.f32 f1627, f2103, f2104;
mul.f32 f2102, f1619, f1514;
mul.f32 f1628, f1530, f1621;
fma.rn.f32 f1629, f1531, f1619, f1628;
mul.f32 f1631, f1629, f2132;
mul.f32 f1632, f1627, f2132;
mul.f32 f1634, f1531, f1629;
mul.f32 f2101, f1530, f1627;
sub.f32 f1635, f2101, f1634;
mul.f32 f2100, f1627, f1518;
mul.f32 f1636, f1530, f1629;
fma.rn.f32 f1637, f1531, f1627, f1636;
mul.f32 f1639, f1637, f2131;
mul.f32 f1640, f1635, f2131;
mul.f32 f1642, f1531, f1637;
mul.f32 f2099, f1530, f1635;
sub.f32 f1643, f2099, f1642;
mul.f32 f2098, f1635, f1522;
mul.f32 f1644, f1530, f1637;
fma.rn.f32 f1645, f1531, f1635, f1644;
mul.f32 f1647, f1645, f2130;
mul.f32 f1648, f1643, f2130;
mul.f32 f2096, f1530, f1643;
mul.f32 f2097, f1531, f1645;
sub.f32 f1651, f2096, f2097;
mul.f32 f2095, f1643, f1526;
mul.f32 f1652, f1530, f1645;
fma.rn.f32 f1653, f1531, f1643, f1652;
sub.f32 f2094, f2213, f2169;
mul.f32 f1655, f1653, f2094;
mul.f32 f1656, f1651, f2094;
mul.f32 f1658, f1531, f1653;
mul.f32 f2093, f1530, f1651;
sub.f32 f1659, f2093, f1658;
sub.f32 f2092, f1192, f1367;
mul.f32 f2091, f1651, f2092;
mul.f32 f1660, f1530, f1653;
fma.rn.f32 f1661, f1531, f1651, f1660;
mul.f32 f1663, f1661, f1473;
mul.f32 f1664, f1659, f1473;
mul.f32 f2089, f1530, f1659;
mul.f32 f2090, f1531, f1661;
sub.f32 f1667, f2089, f2090;
mul.f32 f2088, f1659, f1472;
mul.f32 f1668, f1530, f1661;
fma.rn.f32 f1669, f1531, f1659, f1668;
mul.f32 f1671, f1669, f1477;
mul.f32 f1672, f1667, f1477;
mul.f32 f1674, f1531, f1669;
mul.f32 f2087, f1530, f1667;
sub.f32 f1675, f2087, f1674;
mul.f32 f2086, f1667, f1476;
mul.f32 f1676, f1530, f1669;
fma.rn.f32 f1677, f1531, f1667, f1676;
mul.f32 f1679, f1677, f1481;
mul.f32 f1680, f1675, f1481;
mul.f32 f1682, f1531, f1677;
mul.f32 f2085, f1530, f1675;
sub.f32 f1683, f2085, f1682;
mul.f32 f2084, f1675, f1480;
mul.f32 f1684, f1530, f1677;
fma.rn.f32 f1685, f1531, f1675, f1684;
mul.f32 f1687, f1685, f1485;
mul.f32 f1688, f1683, f1485;
mul.f32 f2082, f1530, f1683;
mul.f32 f2083, f1531, f1685;
sub.f32 f1691, f2082, f2083;
mul.f32 f2081, f1683, f1484;
mul.f32 f1692, f1530, f1685;
fma.rn.f32 f1693, f1531, f1683, f1692;
mul.f32 f1695, f1693, f1489;
mul.f32 f1696, f1691, f1489;
mul.f32 f1698, f1531, f1693;
mul.f32 f2080, f1530, f1691;
sub.f32 f1699, f2080, f1698;
mul.f32 f2079, f1691, f1488;
mul.f32 f1700, f1530, f1693;
fma.rn.f32 f1701, f1531, f1691, f1700;
mul.f32 f1703, f1701, f1493;
mul.f32 f1704, f1699, f1493;
mul.f32 f1706, f1531, f1701;
mul.f32 f2078, f1530, f1699;
sub.f32 f1707, f2078, f1706;
mul.f32 f2077, f1699, f1492;
mul.f32 f1708, f1530, f1701;
fma.rn.f32 f1709, f1531, f1699, f1708;
mul.f32 f1711, f1709, f1497;
mul.f32 f1712, f1707, f1497;
mul.f32 f2075, f1530, f1707;
mul.f32 f2076, f1531, f1709;
sub.f32 f1715, f2075, f2076;
mul.f32 f2074, f1707, f1496;
mul.f32 f1716, f1530, f1709;
fma.rn.f32 f1717, f1531, f1707, f1716;
mul.f32 f1719, f1717, f1501;
mul.f32 f1720, f1715, f1501;
mul.f32 f1722, f1531, f1717;
mul.f32 f2073, f1530, f1715;
sub.f32 f1723, f2073, f1722;
mul.f32 f2072, f1715, f1500;
mul.f32 f1724, f1530, f1717;
fma.rn.f32 f1725, f1531, f1715, f1724;
mul.f32 f1727, f1725, f1505;
mul.f32 f1728, f1723, f1505;
mul.f32 f2070, f1530, f1723;
mul.f32 f2071, f1531, f1725;
sub.f32 f1731, f2070, f2071;
mul.f32 f2069, f1723, f1504;
mul.f32 f1732, f1530, f1725;
fma.rn.f32 f1733, f1531, f1723, f1732;
mul.f32 f1735, f1733, f1509;
mul.f32 f1736, f1731, f1509;
mul.f32 f1738, f1531, f1733;
mul.f32 f2068, f1530, f1731;
sub.f32 f1739, f2068, f1738;
mul.f32 f2067, f1731, f1508;
mul.f32 f1740, f1530, f1733;
fma.rn.f32 f1741, f1531, f1731, f1740;
mul.f32 f1743, f1741, f1513;
mul.f32 f1744, f1739, f1513;
mul.f32 f1746, f1531, f1741;
mul.f32 f2066, f1530, f1739;
sub.f32 f1747, f2066, f1746;
mul.f32 f2065, f1739, f1512;
mul.f32 f1748, f1530, f1741;
fma.rn.f32 f1749, f1531, f1739, f1748;
mul.f32 f1751, f1749, f1517;
mul.f32 f1752, f1747, f1517;
mul.f32 f2063, f1530, f1747;
mul.f32 f2064, f1531, f1749;
sub.f32 f1755, f2063, f2064;
mul.f32 f2062, f1747, f1516;
mul.f32 f1756, f1530, f1749;
fma.rn.f32 f1757, f1531, f1747, f1756;
mul.f32 f1759, f1757, f1521;
mul.f32 f1760, f1755, f1521;
mul.f32 f1762, f1531, f1757;
mul.f32 f2061, f1530, f1755;
sub.f32 f1763, f2061, f1762;
mul.f32 f2060, f1755, f1520;
mul.f32 f1764, f1530, f1757;
fma.rn.f32 f1765, f1531, f1755, f1764;
mul.f32 f1767, f1765, f1525;
mul.f32 f1768, f1763, f1525;
mul.f32 f1770, f1531, f1765;
mul.f32 f2059, f1530, f1763;
sub.f32 f1771, f2059, f1770;
mul.f32 f2058, f1530, f1470;
mul.f32 f1772, f1530, f1765;
mul.f32 f2057, f1763, f1524;
fma.rn.f32 f1773, f1531, f1763, f1772;
mul.f32 f1774, f1771, f1528;
mul.f32 f1775, f1773, f1529;
mul.f32 f1776, f1771, f1529;
mov.u32 r24, %tid.x;
shl.b32 r23, r24, 8;
and.b32 r16, r28, 248;
add.s32 r17, r9, r16;
sub.f32 f2465, f2213, f2169;
mul.f32 f2464, f1653, f2465;
barrier.sync 0;
and.b32 r18, r23, 8192;
add.s32 r19, r17, r18;
mov.u32 r27, %tid.x;
and.b32 r26, r27, 32;
add.f32 f1777, f2213, f2169;
sub.f32 f2466, f1192, f1367;
add.f32 f1778, f1192, f1367;
st.shared.v2.f32 [r19], {f1778, f1777};
mov.u32 r31, %tid.x;
and.b32 r30, r31, 32;
fma.rn.f32 f1779, f1531, f1470, f1536;
sub.f32 f1780, f2058, f1535;
st.shared.v2.f32 [r19+256], {f1780, f1779};
fma.rn.f32 f1781, f1541, f1474, f1544;
sub.f32 f1782, f2126, f1543;
st.shared.v2.f32 [r19+512], {f1782, f1781};
fma.rn.f32 f1783, f1549, f1478, f1552;
sub.f32 f1784, f2124, f1551;
st.shared.v2.f32 [r19+768], {f1784, f1783};
fma.rn.f32 f1785, f1557, f1482, f1560;
sub.f32 f1786, f2121, f1559;
st.shared.v2.f32 [r19+1024], {f1786, f1785};
fma.rn.f32 f1787, f1565, f1486, f1568;
sub.f32 f1788, f2119, f1567;
st.shared.v2.f32 [r19+1280], {f1788, f1787};
sub.f32 f1789, f2117, f1575;
fma.rn.f32 f1790, f1573, f1490, f1576;
st.shared.v2.f32 [r19+1536], {f1789, f1790};
fma.rn.f32 f1791, f1581, f1494, f1584;
sub.f32 f1792, f2114, f1583;
st.shared.v2.f32 [r19+1792], {f1792, f1791};
fma.rn.f32 f1793, f1589, f1498, f1592;
sub.f32 f1794, f2112, f1591;
st.shared.v2.f32 [r19+2048], {f1794, f1793};
fma.rn.f32 f1795, f1597, f1502, f1600;
sub.f32 f1796, f2109, f1599;
st.shared.v2.f32 [r19+2304], {f1796, f1795};
fma.rn.f32 f1797, f1605, f1506, f1608;
sub.f32 f1798, f2107, f1607;
st.shared.v2.f32 [r19+2560], {f1798, f1797};
fma.rn.f32 f1799, f1613, f1510, f1616;
sub.f32 f1800, f2105, f1615;
st.shared.v2.f32 [r19+2816], {f1800, f1799};
fma.rn.f32 f1801, f1621, f1514, f1624;
sub.f32 f1802, f2102, f1623;
st.shared.v2.f32 [r19+3072], {f1802, f1801};
fma.rn.f32 f1803, f1629, f1518, f1632;
sub.f32 f1804, f2100, f1631;
st.shared.v2.f32 [r19+3328], {f1804, f1803};
fma.rn.f32 f1805, f1637, f1522, f1640;
sub.f32 f1806, f2098, f1639;
st.shared.v2.f32 [r19+3584], {f1806, f1805};
fma.rn.f32 f1807, f1645, f1526, f1648;
sub.f32 f1808, f2095, f1647;
st.shared.v2.f32 [r19+3840], {f1808, f1807};
fma.rn.f32 f1809, f1653, f2466, f1656;
sub.f32 f1810, f2091, f2464;
st.shared.v2.f32 [r19+4096], {f1810, f1809};
fma.rn.f32 f1811, f1661, f1472, f1664;
sub.f32 f1812, f2088, f1663;
st.shared.v2.f32 [r19+4352], {f1812, f1811};
fma.rn.f32 f1813, f1669, f1476, f1672;
sub.f32 f1814, f2086, f1671;
st.shared.v2.f32 [r19+4608], {f1814, f1813};
fma.rn.f32 f1815, f1677, f1480, f1680;
sub.f32 f1816, f2084, f1679;
st.shared.v2.f32 [r19+4864], {f1816, f1815};
fma.rn.f32 f1817, f1685, f1484, f1688;
sub.f32 f1818, f2081, f1687;
st.shared.v2.f32 [r19+5120], {f1818, f1817};
fma.rn.f32 f1819, f1693, f1488, f1696;
sub.f32 f1820, f2079, f1695;
st.shared.v2.f32 [r19+5376], {f1820, f1819};
fma.rn.f32 f1821, f1701, f1492, f1704;
sub.f32 f1822, f2077, f1703;
st.shared.v2.f32 [r19+5632], {f1822, f1821};
fma.rn.f32 f1823, f1709, f1496, f1712;
sub.f32 f1824, f2074, f1711;
st.shared.v2.f32 [r19+5888], {f1824, f1823};
fma.rn.f32 f1825, f1717, f1500, f1720;
sub.f32 f1826, f2072, f1719;
st.shared.v2.f32 [r19+6144], {f1826, f1825};
fma.rn.f32 f1827, f1725, f1504, f1728;
sub.f32 f1828, f2069, f1727;
st.shared.v2.f32 [r19+6400], {f1828, f1827};
fma.rn.f32 f1829, f1733, f1508, f1736;
sub.f32 f1830, f2067, f1735;
st.shared.v2.f32 [r19+6656], {f1830, f1829};
fma.rn.f32 f1831, f1741, f1512, f1744;
sub.f32 f1832, f2065, f1743;
st.shared.v2.f32 [r19+6912], {f1832, f1831};
fma.rn.f32 f1833, f1749, f1516, f1752;
sub.f32 f1834, f2062, f1751;
st.shared.v2.f32 [r19+7168], {f1834, f1833};
fma.rn.f32 f1835, f1757, f1520, f1760;
sub.f32 f1836, f2060, f1759;
st.shared.v2.f32 [r19+7424], {f1836, f1835};
fma.rn.f32 f1837, f1765, f1524, f1768;
sub.f32 f1838, f2057, f1767;
st.shared.v2.f32 [r19+7680], {f1838, f1837};
fma.rn.f32 f1839, f1773, f1528, f1776;
sub.f32 f1840, f1774, f1775;
st.shared.v2.f32 [r19+7936], {f1840, f1839};
barrier.sync 0;
mad.lo.s32 r20, r30, -248, r19;
ld.shared.v2.f32 {f1841, f1842}, [r20];
ld.shared.v2.f32 {f1845, f1846}, [r20+512];
ld.shared.v2.f32 {f1849, f1850}, [r20+1024];
ld.shared.v2.f32 {f1853, f1854}, [r20+1536];
ld.shared.v2.f32 {f1857, f1858}, [r20+2048];
ld.shared.v2.f32 {f1861, f1862}, [r20+2560];
ld.shared.v2.f32 {f1865, f1866}, [r20+3072];
ld.shared.v2.f32 {f1869, f1870}, [r20+3584];
ld.shared.v2.f32 {f1873, f1874}, [r20+4096];
ld.shared.v2.f32 {f1877, f1878}, [r20+4608];
ld.shared.v2.f32 {f1881, f1882}, [r20+5120];
ld.shared.v2.f32 {f1885, f1886}, [r20+5632];
ld.shared.v2.f32 {f1889, f1890}, [r20+6144];
ld.shared.v2.f32 {f1893, f1894}, [r20+6656];
ld.shared.v2.f32 {f1897, f1898}, [r20+7168];
ld.shared.v2.f32 {f1901, f1902}, [r20+7680];
ld.shared.v2.f32 {f1905, f1906}, [r20+8192];
ld.shared.v2.f32 {f1909, f1910}, [r20+8704];
ld.shared.v2.f32 {f1913, f1914}, [r20+9216];
ld.shared.v2.f32 {f1917, f1918}, [r20+9728];
ld.shared.v2.f32 {f1921, f1922}, [r20+10240];
ld.shared.v2.f32 {f1925, f1926}, [r20+10752];
ld.shared.v2.f32 {f1929, f1930}, [r20+11264];
ld.shared.v2.f32 {f1933, f1934}, [r20+11776];
ld.shared.v2.f32 {f1937, f1938}, [r20+12288];
ld.shared.v2.f32 {f1941, f1942}, [r20+12800];
ld.shared.v2.f32 {f1945, f1946}, [r20+13312];
ld.shared.v2.f32 {f1949, f1950}, [r20+13824];
ld.shared.v2.f32 {f1953, f1954}, [r20+14336];
ld.shared.v2.f32 {f1957, f1958}, [r20+14848];
ld.shared.v2.f32 {f1961, f1962}, [r20+15360];
ld.shared.v2.f32 {f1965, f1966}, [r20+15872];
add.f32 %0, f1841, f1905;
add.f32 %1, f1842, f1906;
add.f32 %3, f1846, f1910;
add.f32 %2, f1845, f1909;
add.f32 %5, f1850, f1914;
add.f32 %4, f1849, f1913;
add.f32 %7, f1854, f1918;
add.f32 %6, f1853, f1917;
add.f32 %8, f1857, f1921;
add.f32 %9, f1858, f1922;
add.f32 %10, f1861, f1925;
add.f32 %11, f1862, f1926;
add.f32 %12, f1865, f1929;
add.f32 %13, f1866, f1930;
add.f32 %15, f1870, f1934;
add.f32 %14, f1869, f1933;
add.f32 %17, f1874, f1938;
add.f32 %16, f1873, f1937;
add.f32 %19, f1878, f1942;
add.f32 %18, f1877, f1941;
add.f32 %20, f1881, f1945;
add.f32 %21, f1882, f1946;
add.f32 %22, f1885, f1949;
add.f32 %23, f1886, f1950;
add.f32 %24, f1889, f1953;
add.f32 %25, f1890, f1954;
add.f32 %26, f1893, f1957;
add.f32 %27, f1894, f1958;
add.f32 %29, f1898, f1962;
add.f32 %28, f1897, f1961;
add.f32 %31, f1902, f1966;
add.f32 %30, f1901, f1965;
sub.f32 %33, f1842, f1906;
sub.f32 %32, f1841, f1905;
sub.f32 %35, f1846, f1910;
sub.f32 %34, f1845, f1909;
sub.f32 %37, f1850, f1914;
sub.f32 %36, f1849, f1913;
sub.f32 %39, f1854, f1918;
sub.f32 %38, f1853, f1917;
sub.f32 %41, f1858, f1922;
sub.f32 %40, f1857, f1921;
sub.f32 %43, f1862, f1926;
sub.f32 %42, f1861, f1925;
sub.f32 %45, f1866, f1930;
sub.f32 %44, f1865, f1929;
sub.f32 %47, f1870, f1934;
sub.f32 %46, f1869, f1933;
sub.f32 %49, f1874, f1938;
sub.f32 %48, f1873, f1937;
sub.f32 %51, f1878, f1942;
sub.f32 %50, f1877, f1941;
sub.f32 %53, f1882, f1946;
sub.f32 %52, f1881, f1945;
sub.f32 %55, f1886, f1950;
sub.f32 %54, f1885, f1949;
sub.f32 %57, f1890, f1954;
sub.f32 %56, f1889, f1953;
sub.f32 %59, f1894, f1958;
sub.f32 %58, f1893, f1957;
sub.f32 %61, f1898, f1962;
sub.f32 %60, f1897, f1961;
sub.f32 %63, f1902, f1966;
sub.f32 %62, f1901, f1965;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y), "=f"(rmem[2].x), "=f"(rmem[2].y), "=f"(rmem[3].x), "=f"(rmem[3].y), "=f"(rmem[4].x), "=f"(rmem[4].y), "=f"(rmem[5].x), "=f"(rmem[5].y), "=f"(rmem[6].x), "=f"(rmem[6].y), "=f"(rmem[7].x), "=f"(rmem[7].y), "=f"(rmem[8].x), "=f"(rmem[8].y), "=f"(rmem[9].x), "=f"(rmem[9].y), "=f"(rmem[10].x), "=f"(rmem[10].y), "=f"(rmem[11].x), "=f"(rmem[11].y), "=f"(rmem[12].x), "=f"(rmem[12].y), "=f"(rmem[13].x), "=f"(rmem[13].y), "=f"(rmem[14].x), "=f"(rmem[14].y), "=f"(rmem[15].x), "=f"(rmem[15].y), "=f"(rmem[16].x), "=f"(rmem[16].y), "=f"(rmem[17].x), "=f"(rmem[17].y), "=f"(rmem[18].x), "=f"(rmem[18].y), "=f"(rmem[19].x), "=f"(rmem[19].y), "=f"(rmem[20].x), "=f"(rmem[20].y), "=f"(rmem[21].x), "=f"(rmem[21].y), "=f"(rmem[22].x), "=f"(rmem[22].y), "=f"(rmem[23].x), "=f"(rmem[23].y), "=f"(rmem[24].x), "=f"(rmem[24].y), "=f"(rmem[25].x), "=f"(rmem[25].y), "=f"(rmem[26].x), "=f"(rmem[26].y), "=f"(rmem[27].x), "=f"(rmem[27].y), "=f"(rmem[28].x), "=f"(rmem[28].y), "=f"(rmem[29].x), "=f"(rmem[29].y), "=f"(rmem[30].x), "=f"(rmem[30].y), "=f"(rmem[31].x), "=f"(rmem[31].y): "r"(smem), "l"(lut_sp_32_2048), "l"(lut_sp_32_64), "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y), "f"(rmem[2].x), "f"(rmem[2].y), "f"(rmem[3].x), "f"(rmem[3].y), "f"(rmem[4].x), "f"(rmem[4].y), "f"(rmem[5].x), "f"(rmem[5].y), "f"(rmem[6].x), "f"(rmem[6].y), "f"(rmem[7].x), "f"(rmem[7].y), "f"(rmem[8].x), "f"(rmem[8].y), "f"(rmem[9].x), "f"(rmem[9].y), "f"(rmem[10].x), "f"(rmem[10].y), "f"(rmem[11].x), "f"(rmem[11].y), "f"(rmem[12].x), "f"(rmem[12].y), "f"(rmem[13].x), "f"(rmem[13].y), "f"(rmem[14].x), "f"(rmem[14].y), "f"(rmem[15].x), "f"(rmem[15].y), "f"(rmem[16].x), "f"(rmem[16].y), "f"(rmem[17].x), "f"(rmem[17].y), "f"(rmem[18].x), "f"(rmem[18].y), "f"(rmem[19].x), "f"(rmem[19].y), "f"(rmem[20].x), "f"(rmem[20].y), "f"(rmem[21].x), "f"(rmem[21].y), "f"(rmem[22].x), "f"(rmem[22].y), "f"(rmem[23].x), "f"(rmem[23].y), "f"(rmem[24].x), "f"(rmem[24].y), "f"(rmem[25].x), "f"(rmem[25].y), "f"(rmem[26].x), "f"(rmem[26].y), "f"(rmem[27].x), "f"(rmem[27].y), "f"(rmem[28].x), "f"(rmem[28].y), "f"(rmem[29].x), "f"(rmem[29].y), "f"(rmem[30].x), "f"(rmem[30].y), "f"(rmem[31].x), "f"(rmem[31].y), "f"(rmem[16].y), "f"(rmem[8].y), "f"(rmem[4].y), "f"(rmem[20].y), "f"(rmem[28].y), "f"(rmem[2].y), "f"(rmem[26].y), "f"(rmem[10].y), "f"(rmem[22].y), "f"(rmem[14].y), "f"(rmem[17].y), "f"(rmem[1].y), "f"(rmem[25].y), "f"(rmem[5].y), "f"(rmem[29].y), "f"(rmem[13].y), "f"(rmem[19].y), "f"(rmem[11].y), "f"(rmem[7].y), "f"(rmem[23].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<96, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<2361>;
.reg .b32 r<36>;
.reg .b64 rd<12>;
mov.u32 r1, %tid.y;
shl.b32 r2, r1, 13;
mov.u32 r3, %64;
add.s32 r4, r3, r2;
add.f32 f129, %67, %99;
sub.f32 f131, %67, %99;
add.f32 f2359, %68, %131;
sub.f32 f132, %68, %131;
add.f32 f133, %83, %115;
sub.f32 f135, %83, %115;
add.f32 f2357, %132, %116;
sub.f32 f136, %132, %116;
add.f32 f137, f129, f133;
sub.f32 f139, f129, f133;
add.f32 f2356, f2359, f2357;
sub.f32 f140, f2359, f2357;
add.f32 f141, f131, f136;
sub.f32 f143, f131, f136;
sub.f32 f2355, f132, f135;
add.f32 f144, f132, f135;
add.f32 f145, %75, %107;
sub.f32 f147, %75, %107;
add.f32 f2352, %133, %134;
sub.f32 f148, %133, %134;
add.f32 f149, %91, %123;
sub.f32 f151, %91, %123;
add.f32 f2350, %92, %135;
sub.f32 f152, %92, %135;
add.f32 f153, f145, f149;
sub.f32 f155, f145, f149;
add.f32 f2349, f2352, f2350;
sub.f32 f156, f2352, f2350;
add.f32 f157, f147, f152;
sub.f32 f159, f147, f152;
sub.f32 f2348, f148, f151;
add.f32 f160, f148, f151;
mul.f32 f162, f2348, 0fBF3504F3;
mul.f32 f2347, f157, 0f3F3504F3;
sub.f32 f163, f2347, f162;
mul.f32 f164, f2348, 0f3F3504F3;
fma.rn.f32 f165, f157, 0fBF3504F3, f164;
mul.f32 f166, f159, 0fBF3504F3;
mul.f32 f167, f160, 0fBF3504F3;
sub.f32 f168, f166, f167;
add.f32 f169, f166, f167;
add.f32 f170, f137, f153;
sub.f32 f172, f137, f153;
add.f32 f2346, f2356, f2349;
sub.f32 f173, f2356, f2349;
add.f32 f174, f141, f163;
sub.f32 f176, f141, f163;
add.f32 f2345, f2355, f165;
sub.f32 f177, f2355, f165;
add.f32 f178, f139, f156;
sub.f32 f180, f139, f156;
sub.f32 f2344, f140, f155;
add.f32 f181, f140, f155;
add.f32 f182, f143, f168;
sub.f32 f184, f143, f168;
add.f32 f2343, f144, f169;
sub.f32 f185, f144, f169;
add.f32 f186, %71, %103;
sub.f32 f188, %71, %103;
add.f32 f2341, %136, %104;
sub.f32 f189, %136, %104;
add.f32 f190, %87, %119;
sub.f32 f192, %87, %119;
add.f32 f2338, %138, %137;
sub.f32 f193, %138, %137;
add.f32 f194, f186, f190;
sub.f32 f196, f186, f190;
add.f32 f2337, f2341, f2338;
sub.f32 f197, f2341, f2338;
add.f32 f198, f188, f193;
sub.f32 f200, f188, f193;
sub.f32 f2336, f189, f192;
add.f32 f201, f189, f192;
add.f32 f202, %79, %111;
sub.f32 f204, %79, %111;
add.f32 f2334, %80, %139;
sub.f32 f205, %80, %139;
add.f32 f206, %95, %127;
sub.f32 f208, %95, %127;
add.f32 f2332, %140, %128;
sub.f32 f209, %140, %128;
add.f32 f210, f202, f206;
sub.f32 f212, f202, f206;
add.f32 f2331, f2334, f2332;
sub.f32 f213, f2334, f2332;
add.f32 f214, f204, f209;
sub.f32 f216, f204, f209;
sub.f32 f2330, f205, f208;
add.f32 f217, f205, f208;
mul.f32 f219, f2330, 0fBF3504F3;
mul.f32 f2329, f214, 0f3F3504F3;
sub.f32 f220, f2329, f219;
mul.f32 f221, f2330, 0f3F3504F3;
fma.rn.f32 f222, f214, 0fBF3504F3, f221;
mul.f32 f223, f216, 0fBF3504F3;
mul.f32 f224, f217, 0fBF3504F3;
sub.f32 f225, f223, f224;
add.f32 f226, f223, f224;
add.f32 f227, f194, f210;
sub.f32 f229, f194, f210;
add.f32 f2328, f2337, f2331;
sub.f32 f230, f2337, f2331;
add.f32 f231, f198, f220;
sub.f32 f233, f198, f220;
add.f32 f2327, f2336, f222;
sub.f32 f234, f2336, f222;
add.f32 f235, f196, f213;
sub.f32 f237, f196, f213;
sub.f32 f2326, f197, f212;
add.f32 f238, f197, f212;
add.f32 f239, f200, f225;
sub.f32 f241, f200, f225;
add.f32 f2325, f201, f226;
sub.f32 f242, f201, f226;
mul.f32 f2323, f231, 0f3F6C835E;
mul.f32 f2324, f2327, 0fBEC3EF15;
sub.f32 f245, f2323, f2324;
mul.f32 f246, f2327, 0f3F6C835E;
fma.rn.f32 f247, f231, 0fBEC3EF15, f246;
mul.f32 f2321, f235, 0f3F3504F3;
mul.f32 f2322, f2326, 0fBF3504F3;
sub.f32 f250, f2321, f2322;
mul.f32 f251, f2326, 0f3F3504F3;
fma.rn.f32 f252, f235, 0fBF3504F3, f251;
mul.f32 f2319, f239, 0f3EC3EF15;
mul.f32 f2320, f2325, 0fBF6C835E;
sub.f32 f255, f2319, f2320;
mul.f32 f256, f2325, 0f3EC3EF15;
fma.rn.f32 f257, f239, 0fBF6C835E, f256;
mul.f32 f2317, f233, 0fBEC3EF15;
mul.f32 f2318, f234, 0fBF6C835E;
sub.f32 f260, f2317, f2318;
mul.f32 f261, f234, 0fBEC3EF15;
fma.rn.f32 f262, f233, 0fBF6C835E, f261;
mul.f32 f263, f237, 0fBF3504F3;
mul.f32 f264, f238, 0fBF3504F3;
sub.f32 f265, f263, f264;
add.f32 f266, f263, f264;
mul.f32 f2315, f241, 0fBF6C835E;
mul.f32 f2316, f242, 0fBEC3EF15;
sub.f32 f269, f2315, f2316;
mul.f32 f270, f242, 0fBF6C835E;
fma.rn.f32 f271, f241, 0fBEC3EF15, f270;
add.f32 f272, f170, f227;
sub.f32 f274, f170, f227;
add.f32 f2314, f2346, f2328;
sub.f32 f275, f2346, f2328;
add.f32 f276, f174, f245;
sub.f32 f278, f174, f245;
add.f32 f2313, f2345, f247;
sub.f32 f279, f2345, f247;
add.f32 f280, f178, f250;
sub.f32 f282, f178, f250;
add.f32 f2312, f2344, f252;
sub.f32 f283, f2344, f252;
add.f32 f284, f182, f255;
sub.f32 f286, f182, f255;
add.f32 f2311, f2343, f257;
sub.f32 f287, f2343, f257;
add.f32 f288, f172, f230;
sub.f32 f290, f172, f230;
sub.f32 f2310, f173, f229;
add.f32 f291, f173, f229;
add.f32 f292, f176, f260;
sub.f32 f294, f176, f260;
add.f32 f2309, f177, f262;
sub.f32 f295, f177, f262;
add.f32 f296, f180, f265;
sub.f32 f298, f180, f265;
add.f32 f2308, f181, f266;
sub.f32 f299, f181, f266;
add.f32 f300, f184, f269;
sub.f32 f302, f184, f269;
add.f32 f2307, f185, f271;
sub.f32 f303, f185, f271;
add.f32 f304, %69, %101;
sub.f32 f306, %69, %101;
add.f32 f2304, %142, %141;
sub.f32 f307, %142, %141;
add.f32 f308, %85, %117;
sub.f32 f310, %85, %117;
add.f32 f2302, %86, %143;
sub.f32 f311, %86, %143;
add.f32 f312, f304, f308;
sub.f32 f314, f304, f308;
add.f32 f2301, f2304, f2302;
sub.f32 f315, f2304, f2302;
add.f32 f316, f306, f311;
sub.f32 f318, f306, f311;
sub.f32 f2300, f307, f310;
add.f32 f319, f307, f310;
add.f32 f320, %77, %109;
sub.f32 f322, %77, %109;
add.f32 f2298, %144, %110;
sub.f32 f323, %144, %110;
add.f32 f324, %93, %125;
sub.f32 f326, %93, %125;
add.f32 f2295, %146, %145;
sub.f32 f327, %146, %145;
add.f32 f328, f320, f324;
sub.f32 f330, f320, f324;
add.f32 f2294, f2298, f2295;
sub.f32 f331, f2298, f2295;
add.f32 f332, f322, f327;
sub.f32 f334, f322, f327;
sub.f32 f2293, f323, f326;
add.f32 f335, f323, f326;
mul.f32 f2291, f332, 0f3F3504F3;
mul.f32 f2292, f2293, 0fBF3504F3;
sub.f32 f338, f2291, f2292;
mul.f32 f339, f2293, 0f3F3504F3;
fma.rn.f32 f340, f332, 0fBF3504F3, f339;
mul.f32 f341, f334, 0fBF3504F3;
mul.f32 f342, f335, 0fBF3504F3;
sub.f32 f343, f341, f342;
add.f32 f344, f341, f342;
add.f32 f345, f312, f328;
sub.f32 f347, f312, f328;
add.f32 f2290, f2301, f2294;
sub.f32 f348, f2301, f2294;
add.f32 f349, f316, f338;
sub.f32 f351, f316, f338;
add.f32 f2289, f2300, f340;
sub.f32 f352, f2300, f340;
add.f32 f353, f314, f331;
sub.f32 f355, f314, f331;
sub.f32 f2288, f315, f330;
add.f32 f356, f315, f330;
add.f32 f357, f318, f343;
sub.f32 f359, f318, f343;
add.f32 f2287, f319, f344;
sub.f32 f360, f319, f344;
add.f32 f361, %73, %105;
sub.f32 f363, %73, %105;
add.f32 f2285, %74, %147;
sub.f32 f364, %74, %147;
add.f32 f365, %89, %121;
sub.f32 f367, %89, %121;
add.f32 f2283, %148, %122;
sub.f32 f368, %148, %122;
add.f32 f369, f361, f365;
sub.f32 f371, f361, f365;
add.f32 f2282, f2285, f2283;
sub.f32 f372, f2285, f2283;
add.f32 f373, f363, f368;
sub.f32 f375, f363, f368;
sub.f32 f2281, f364, f367;
add.f32 f376, f364, f367;
add.f32 f377, %81, %113;
sub.f32 f379, %81, %113;
add.f32 f2278, %149, %150;
sub.f32 f380, %149, %150;
add.f32 f381, %97, %129;
sub.f32 f383, %97, %129;
add.f32 f2277, %98, %130;
sub.f32 f384, %98, %130;
add.f32 f385, f377, f381;
sub.f32 f387, f377, f381;
add.f32 f2276, f2278, f2277;
sub.f32 f388, f2278, f2277;
add.f32 f389, f379, f384;
sub.f32 f391, f379, f384;
sub.f32 f2275, f380, f383;
add.f32 f392, f380, f383;
mul.f32 f2273, f389, 0f3F3504F3;
mul.f32 f2274, f2275, 0fBF3504F3;
sub.f32 f395, f2273, f2274;
mul.f32 f396, f2275, 0f3F3504F3;
fma.rn.f32 f397, f389, 0fBF3504F3, f396;
mul.f32 f398, f391, 0fBF3504F3;
mul.f32 f399, f392, 0fBF3504F3;
sub.f32 f400, f398, f399;
add.f32 f401, f398, f399;
add.f32 f402, f369, f385;
sub.f32 f404, f369, f385;
add.f32 f2272, f2282, f2276;
sub.f32 f405, f2282, f2276;
add.f32 f406, f373, f395;
sub.f32 f408, f373, f395;
add.f32 f2271, f2281, f397;
sub.f32 f409, f2281, f397;
add.f32 f410, f371, f388;
sub.f32 f412, f371, f388;
sub.f32 f2270, f372, f387;
add.f32 f413, f372, f387;
add.f32 f414, f375, f400;
sub.f32 f416, f375, f400;
add.f32 f2269, f376, f401;
sub.f32 f417, f376, f401;
mul.f32 f419, f2271, 0fBEC3EF15;
mul.f32 f2268, f406, 0f3F6C835E;
sub.f32 f420, f2268, f419;
mul.f32 f421, f2271, 0f3F6C835E;
fma.rn.f32 f422, f406, 0fBEC3EF15, f421;
mul.f32 f424, f2270, 0fBF3504F3;
mul.f32 f2267, f410, 0f3F3504F3;
sub.f32 f425, f2267, f424;
mul.f32 f426, f2270, 0f3F3504F3;
fma.rn.f32 f427, f410, 0fBF3504F3, f426;
mul.f32 f2265, f414, 0f3EC3EF15;
mul.f32 f2266, f2269, 0fBF6C835E;
sub.f32 f430, f2265, f2266;
mul.f32 f431, f2269, 0f3EC3EF15;
fma.rn.f32 f432, f414, 0fBF6C835E, f431;
mul.f32 f2263, f408, 0fBEC3EF15;
mul.f32 f2264, f409, 0fBF6C835E;
sub.f32 f435, f2263, f2264;
mul.f32 f436, f409, 0fBEC3EF15;
fma.rn.f32 f437, f408, 0fBF6C835E, f436;
mul.f32 f438, f412, 0fBF3504F3;
mul.f32 f439, f413, 0fBF3504F3;
sub.f32 f440, f438, f439;
add.f32 f441, f438, f439;
mul.f32 f443, f417, 0fBEC3EF15;
mul.f32 f2262, f416, 0fBF6C835E;
sub.f32 f444, f2262, f443;
mul.f32 f445, f417, 0fBF6C835E;
fma.rn.f32 f446, f416, 0fBEC3EF15, f445;
add.f32 f447, f345, f402;
sub.f32 f449, f345, f402;
add.f32 f2261, f2290, f2272;
sub.f32 f450, f2290, f2272;
add.f32 f451, f349, f420;
sub.f32 f453, f349, f420;
add.f32 f2260, f2289, f422;
sub.f32 f454, f2289, f422;
add.f32 f455, f353, f425;
sub.f32 f457, f353, f425;
add.f32 f2259, f2288, f427;
sub.f32 f458, f2288, f427;
add.f32 f459, f357, f430;
sub.f32 f461, f357, f430;
add.f32 f2258, f2287, f432;
sub.f32 f462, f2287, f432;
add.f32 f463, f347, f405;
sub.f32 f465, f347, f405;
sub.f32 f2257, f348, f404;
add.f32 f466, f348, f404;
add.f32 f467, f351, f435;
sub.f32 f469, f351, f435;
add.f32 f2256, f352, f437;
sub.f32 f470, f352, f437;
add.f32 f471, f355, f440;
sub.f32 f473, f355, f440;
add.f32 f2255, f356, f441;
sub.f32 f474, f356, f441;
add.f32 f475, f359, f444;
sub.f32 f477, f359, f444;
add.f32 f2254, f360, f446;
sub.f32 f478, f360, f446;
mul.f32 f480, f2260, 0fBE47C5C2;
mul.f32 f2253, f451, 0f3F7B14BE;
sub.f32 f481, f2253, f480;
mul.f32 f482, f2260, 0f3F7B14BE;
fma.rn.f32 f483, f451, 0fBE47C5C2, f482;
mul.f32 f485, f2259, 0fBEC3EF15;
mul.f32 f2252, f455, 0f3F6C835E;
sub.f32 f486, f2252, f485;
mul.f32 f487, f2259, 0f3F6C835E;
fma.rn.f32 f488, f455, 0fBEC3EF15, f487;
mul.f32 f490, f2258, 0fBF0E39DA;
mul.f32 f2251, f459, 0f3F54DB31;
sub.f32 f491, f2251, f490;
mul.f32 f492, f2258, 0f3F54DB31;
fma.rn.f32 f493, f459, 0fBF0E39DA, f492;
mul.f32 f495, f2257, 0fBF3504F3;
mul.f32 f2250, f463, 0f3F3504F3;
sub.f32 f496, f2250, f495;
mul.f32 f497, f2257, 0f3F3504F3;
fma.rn.f32 f498, f463, 0fBF3504F3, f497;
mul.f32 f2248, f467, 0f3F0E39DA;
mul.f32 f2249, f2256, 0fBF54DB31;
sub.f32 f501, f2248, f2249;
mul.f32 f502, f2256, 0f3F0E39DA;
fma.rn.f32 f503, f467, 0fBF54DB31, f502;
mul.f32 f2246, f471, 0f3EC3EF15;
mul.f32 f2247, f2255, 0fBF6C835E;
sub.f32 f506, f2246, f2247;
mul.f32 f507, f2255, 0f3EC3EF15;
fma.rn.f32 f508, f471, 0fBF6C835E, f507;
mul.f32 f2244, f475, 0f3E47C5C2;
mul.f32 f2245, f2254, 0fBF7B14BE;
sub.f32 f511, f2244, f2245;
mul.f32 f512, f2254, 0f3E47C5C2;
fma.rn.f32 f513, f475, 0fBF7B14BE, f512;
mul.f32 f2242, f453, 0fBE47C5C2;
mul.f32 f2243, f454, 0fBF7B14BE;
sub.f32 f516, f2242, f2243;
mul.f32 f517, f454, 0fBE47C5C2;
fma.rn.f32 f518, f453, 0fBF7B14BE, f517;
mul.f32 f520, f458, 0fBF6C835E;
mul.f32 f2241, f457, 0fBEC3EF15;
sub.f32 f521, f2241, f520;
mul.f32 f522, f458, 0fBEC3EF15;
fma.rn.f32 f523, f457, 0fBF6C835E, f522;
mul.f32 f525, f462, 0fBF54DB31;
mul.f32 f2240, f461, 0fBF0E39DA;
sub.f32 f526, f2240, f525;
mul.f32 f527, f462, 0fBF0E39DA;
fma.rn.f32 f528, f461, 0fBF54DB31, f527;
mul.f32 f529, f465, 0fBF3504F3;
mul.f32 f530, f466, 0fBF3504F3;
sub.f32 f531, f529, f530;
add.f32 f532, f529, f530;
mul.f32 f2238, f469, 0fBF54DB31;
mul.f32 f2239, f470, 0fBF0E39DA;
sub.f32 f535, f2238, f2239;
mul.f32 f536, f470, 0fBF54DB31;
fma.rn.f32 f537, f469, 0fBF0E39DA, f536;
mul.f32 f539, f474, 0fBEC3EF15;
mul.f32 f2237, f473, 0fBF6C835E;
sub.f32 f540, f2237, f539;
mul.f32 f541, f474, 0fBF6C835E;
fma.rn.f32 f542, f473, 0fBEC3EF15, f541;
mul.f32 f544, f478, 0fBE47C5C2;
mul.f32 f2236, f477, 0fBF7B14BE;
sub.f32 f545, f2236, f544;
mul.f32 f546, f478, 0fBF7B14BE;
fma.rn.f32 f547, f477, 0fBE47C5C2, f546;
add.f32 f548, f272, f447;
sub.f32 f550, f272, f447;
add.f32 f2235, f2314, f2261;
sub.f32 f551, f2314, f2261;
add.f32 f552, f276, f481;
sub.f32 f554, f276, f481;
add.f32 f2234, f2313, f483;
sub.f32 f555, f2313, f483;
add.f32 f556, f280, f486;
sub.f32 f558, f280, f486;
add.f32 f2233, f2312, f488;
sub.f32 f559, f2312, f488;
add.f32 f560, f284, f491;
sub.f32 f562, f284, f491;
add.f32 f2232, f2311, f493;
sub.f32 f563, f2311, f493;
add.f32 f564, f288, f496;
sub.f32 f566, f288, f496;
add.f32 f2231, f2310, f498;
sub.f32 f567, f2310, f498;
add.f32 f568, f292, f501;
sub.f32 f570, f292, f501;
add.f32 f2230, f2309, f503;
sub.f32 f571, f2309, f503;
add.f32 f572, f296, f506;
sub.f32 f574, f296, f506;
add.f32 f2229, f2308, f508;
sub.f32 f575, f2308, f508;
add.f32 f576, f300, f511;
sub.f32 f578, f300, f511;
add.f32 f2228, f2307, f513;
sub.f32 f579, f2307, f513;
add.f32 f580, f274, f450;
sub.f32 f582, f274, f450;
sub.f32 f2227, f275, f449;
add.f32 f583, f275, f449;
add.f32 f584, f278, f516;
sub.f32 f586, f278, f516;
add.f32 f2226, f279, f518;
sub.f32 f587, f279, f518;
add.f32 f588, f282, f521;
sub.f32 f590, f282, f521;
add.f32 f2225, f283, f523;
sub.f32 f591, f283, f523;
add.f32 f592, f286, f526;
sub.f32 f594, f286, f526;
add.f32 f2224, f287, f528;
sub.f32 f595, f287, f528;
add.f32 f596, f290, f531;
sub.f32 f598, f290, f531;
add.f32 f2223, f291, f532;
sub.f32 f599, f291, f532;
add.f32 f600, f294, f535;
sub.f32 f602, f294, f535;
add.f32 f2222, f295, f537;
sub.f32 f603, f295, f537;
add.f32 f604, f298, f540;
sub.f32 f606, f298, f540;
add.f32 f2221, f299, f542;
sub.f32 f607, f299, f542;
add.f32 f608, f302, f545;
sub.f32 f610, f302, f545;
add.f32 f2220, f303, f547;
sub.f32 f611, f303, f547;
mov.u32 r24, %tid.x;
shl.b32 r7, r24, 3;
cvt.u64.u32 rd2, r7;
and.b64 rd3, rd2, 504;
mov.u64 rd4, %65;
add.s64 rd5, rd4, rd3;
ld.global.v2.f32 {f612, f613}, [rd5];
mul.f32 f617, f613, f2234;
mul.f32 f2219, f612, f552;
sub.f32 f618, f2219, f617;
mul.f32 f619, f612, f2234;
fma.rn.f32 f620, f613, f552, f619;
mul.f32 f2217, f612, f612;
mul.f32 f2218, f613, f613;
sub.f32 f623, f2217, f2218;
mul.f32 f624, f613, f612;
fma.rn.f32 f625, f613, f612, f624;
mul.f32 f2215, f623, f556;
mul.f32 f2216, f625, f2233;
sub.f32 f628, f2215, f2216;
mul.f32 f629, f623, f2233;
fma.rn.f32 f630, f625, f556, f629;
mul.f32 f2213, f612, f623;
mul.f32 f2214, f613, f625;
sub.f32 f633, f2213, f2214;
mul.f32 f634, f612, f625;
fma.rn.f32 f635, f613, f623, f634;
mul.f32 f2211, f633, f560;
mul.f32 f2212, f635, f2232;
sub.f32 f638, f2211, f2212;
mul.f32 f639, f633, f2232;
fma.rn.f32 f640, f635, f560, f639;
mul.f32 f642, f613, f635;
mul.f32 f2210, f612, f633;
sub.f32 f643, f2210, f642;
mul.f32 f644, f612, f635;
fma.rn.f32 f645, f613, f633, f644;
mul.f32 f647, f645, f2231;
mul.f32 f2209, f643, f564;
sub.f32 f648, f2209, f647;
mul.f32 f649, f643, f2231;
fma.rn.f32 f650, f645, f564, f649;
mul.f32 f652, f613, f645;
mul.f32 f2208, f612, f643;
sub.f32 f653, f2208, f652;
mul.f32 f654, f612, f645;
fma.rn.f32 f655, f613, f643, f654;
mul.f32 f657, f655, f2230;
mul.f32 f2207, f653, f568;
sub.f32 f658, f2207, f657;
mul.f32 f659, f653, f2230;
fma.rn.f32 f660, f655, f568, f659;
mul.f32 f662, f613, f655;
mul.f32 f2206, f612, f653;
sub.f32 f663, f2206, f662;
mul.f32 f664, f612, f655;
fma.rn.f32 f665, f613, f653, f664;
mul.f32 f2204, f663, f572;
mul.f32 f2205, f665, f2229;
sub.f32 f668, f2204, f2205;
mul.f32 f669, f663, f2229;
fma.rn.f32 f670, f665, f572, f669;
mul.f32 f2202, f612, f663;
mul.f32 f2203, f613, f665;
sub.f32 f673, f2202, f2203;
mul.f32 f674, f612, f665;
fma.rn.f32 f675, f613, f663, f674;
mul.f32 f2200, f673, f576;
mul.f32 f2201, f675, f2228;
sub.f32 f678, f2200, f2201;
mul.f32 f679, f673, f2228;
fma.rn.f32 f680, f675, f576, f679;
mul.f32 f2198, f612, f673;
mul.f32 f2199, f613, f675;
sub.f32 f683, f2198, f2199;
mul.f32 f684, f612, f675;
fma.rn.f32 f685, f613, f673, f684;
mul.f32 f687, f685, f2227;
mul.f32 f2197, f683, f580;
sub.f32 f688, f2197, f687;
mul.f32 f689, f683, f2227;
fma.rn.f32 f690, f685, f580, f689;
mul.f32 f692, f613, f685;
mul.f32 f2196, f612, f683;
sub.f32 f693, f2196, f692;
mul.f32 f694, f612, f685;
fma.rn.f32 f695, f613, f683, f694;
mul.f32 f697, f695, f2226;
mul.f32 f2195, f693, f584;
sub.f32 f698, f2195, f697;
mul.f32 f699, f693, f2226;
fma.rn.f32 f700, f695, f584, f699;
mul.f32 f702, f613, f695;
mul.f32 f2194, f612, f693;
sub.f32 f703, f2194, f702;
mul.f32 f704, f612, f695;
fma.rn.f32 f705, f613, f693, f704;
mul.f32 f707, f705, f2225;
mul.f32 f2193, f703, f588;
sub.f32 f708, f2193, f707;
mul.f32 f709, f703, f2225;
fma.rn.f32 f710, f705, f588, f709;
mul.f32 f2191, f612, f703;
mul.f32 f2192, f613, f705;
sub.f32 f713, f2191, f2192;
mul.f32 f714, f612, f705;
fma.rn.f32 f715, f613, f703, f714;
mul.f32 f2189, f713, f592;
mul.f32 f2190, f715, f2224;
sub.f32 f718, f2189, f2190;
mul.f32 f719, f713, f2224;
fma.rn.f32 f720, f715, f592, f719;
mul.f32 f2187, f612, f713;
mul.f32 f2188, f613, f715;
sub.f32 f723, f2187, f2188;
mul.f32 f724, f612, f715;
fma.rn.f32 f725, f613, f713, f724;
mul.f32 f2185, f723, f596;
mul.f32 f2186, f725, f2223;
sub.f32 f728, f2185, f2186;
mul.f32 f729, f723, f2223;
fma.rn.f32 f730, f725, f596, f729;
mul.f32 f732, f613, f725;
mul.f32 f2184, f612, f723;
sub.f32 f733, f2184, f732;
mul.f32 f734, f612, f725;
fma.rn.f32 f735, f613, f723, f734;
mul.f32 f737, f735, f2222;
mul.f32 f2183, f733, f600;
sub.f32 f738, f2183, f737;
mul.f32 f739, f733, f2222;
fma.rn.f32 f740, f735, f600, f739;
mul.f32 f742, f613, f735;
mul.f32 f2182, f612, f733;
sub.f32 f743, f2182, f742;
mul.f32 f744, f612, f735;
fma.rn.f32 f745, f613, f733, f744;
mul.f32 f747, f745, f2221;
mul.f32 f2181, f743, f604;
sub.f32 f748, f2181, f747;
mul.f32 f749, f743, f2221;
fma.rn.f32 f750, f745, f604, f749;
mul.f32 f752, f613, f745;
mul.f32 f2180, f612, f743;
sub.f32 f753, f2180, f752;
mul.f32 f754, f612, f745;
fma.rn.f32 f755, f613, f743, f754;
mul.f32 f757, f755, f2220;
mul.f32 f2179, f753, f608;
sub.f32 f758, f2179, f757;
mul.f32 f759, f753, f2220;
fma.rn.f32 f760, f755, f608, f759;
mul.f32 f2177, f612, f753;
mul.f32 f2178, f613, f755;
sub.f32 f763, f2177, f2178;
mul.f32 f764, f612, f755;
fma.rn.f32 f765, f613, f753, f764;
mul.f32 f2175, f763, f550;
mul.f32 f2176, f765, f551;
sub.f32 f768, f2175, f2176;
mul.f32 f769, f763, f551;
fma.rn.f32 f770, f765, f550, f769;
mul.f32 f2173, f612, f763;
mul.f32 f2174, f613, f765;
sub.f32 f773, f2173, f2174;
mul.f32 f774, f612, f765;
fma.rn.f32 f775, f613, f763, f774;
mul.f32 f777, f775, f555;
mul.f32 f2172, f773, f554;
sub.f32 f778, f2172, f777;
mul.f32 f779, f773, f555;
fma.rn.f32 f780, f775, f554, f779;
mul.f32 f782, f613, f775;
mul.f32 f2171, f612, f773;
sub.f32 f783, f2171, f782;
mul.f32 f784, f612, f775;
fma.rn.f32 f785, f613, f773, f784;
mul.f32 f787, f785, f559;
mul.f32 f2170, f783, f558;
sub.f32 f788, f2170, f787;
mul.f32 f789, f783, f559;
fma.rn.f32 f790, f785, f558, f789;
mul.f32 f792, f613, f785;
mul.f32 f2169, f612, f783;
sub.f32 f793, f2169, f792;
mul.f32 f794, f612, f785;
fma.rn.f32 f795, f613, f783, f794;
mul.f32 f797, f795, f563;
mul.f32 f2168, f793, f562;
sub.f32 f798, f2168, f797;
mul.f32 f799, f793, f563;
fma.rn.f32 f800, f795, f562, f799;
mul.f32 f802, f613, f795;
mul.f32 f2167, f612, f793;
sub.f32 f803, f2167, f802;
mul.f32 f804, f612, f795;
fma.rn.f32 f805, f613, f793, f804;
mul.f32 f2165, f803, f566;
mul.f32 f2166, f805, f567;
sub.f32 f808, f2165, f2166;
mul.f32 f809, f803, f567;
fma.rn.f32 f810, f805, f566, f809;
mul.f32 f2163, f612, f803;
mul.f32 f2164, f613, f805;
sub.f32 f813, f2163, f2164;
mul.f32 f814, f612, f805;
fma.rn.f32 f815, f613, f803, f814;
mul.f32 f2161, f813, f570;
mul.f32 f2162, f815, f571;
sub.f32 f818, f2161, f2162;
mul.f32 f819, f813, f571;
fma.rn.f32 f820, f815, f570, f819;
mul.f32 f2159, f612, f813;
mul.f32 f2160, f613, f815;
sub.f32 f823, f2159, f2160;
mul.f32 f824, f612, f815;
fma.rn.f32 f825, f613, f813, f824;
mul.f32 f827, f825, f575;
mul.f32 f2158, f823, f574;
sub.f32 f828, f2158, f827;
mul.f32 f829, f823, f575;
fma.rn.f32 f830, f825, f574, f829;
mul.f32 f832, f613, f825;
mul.f32 f2157, f612, f823;
sub.f32 f833, f2157, f832;
mul.f32 f834, f612, f825;
fma.rn.f32 f835, f613, f823, f834;
mul.f32 f837, f835, f579;
mul.f32 f2156, f833, f578;
sub.f32 f838, f2156, f837;
mul.f32 f839, f833, f579;
fma.rn.f32 f840, f835, f578, f839;
mul.f32 f842, f613, f835;
mul.f32 f2155, f612, f833;
sub.f32 f843, f2155, f842;
mul.f32 f844, f612, f835;
fma.rn.f32 f845, f613, f833, f844;
mul.f32 f847, f845, f583;
mul.f32 f2154, f843, f582;
sub.f32 f848, f2154, f847;
mul.f32 f849, f843, f583;
fma.rn.f32 f850, f845, f582, f849;
mul.f32 f2152, f612, f843;
mul.f32 f2153, f613, f845;
sub.f32 f853, f2152, f2153;
mul.f32 f854, f612, f845;
fma.rn.f32 f855, f613, f843, f854;
mul.f32 f2150, f853, f586;
mul.f32 f2151, f855, f587;
sub.f32 f858, f2150, f2151;
mul.f32 f859, f853, f587;
fma.rn.f32 f860, f855, f586, f859;
mul.f32 f2148, f612, f853;
mul.f32 f2149, f613, f855;
sub.f32 f863, f2148, f2149;
mul.f32 f864, f612, f855;
fma.rn.f32 f865, f613, f853, f864;
mul.f32 f2146, f863, f590;
mul.f32 f2147, f865, f591;
sub.f32 f868, f2146, f2147;
mul.f32 f869, f863, f591;
fma.rn.f32 f870, f865, f590, f869;
mul.f32 f872, f613, f865;
mul.f32 f2145, f612, f863;
sub.f32 f873, f2145, f872;
mul.f32 f874, f612, f865;
fma.rn.f32 f875, f613, f863, f874;
mul.f32 f877, f875, f595;
mul.f32 f2144, f873, f594;
sub.f32 f878, f2144, f877;
mul.f32 f879, f873, f595;
fma.rn.f32 f880, f875, f594, f879;
mul.f32 f882, f613, f875;
mul.f32 f2143, f612, f873;
sub.f32 f883, f2143, f882;
mul.f32 f884, f612, f875;
fma.rn.f32 f885, f613, f873, f884;
mul.f32 f887, f885, f599;
mul.f32 f2142, f883, f598;
sub.f32 f888, f2142, f887;
mul.f32 f889, f883, f599;
fma.rn.f32 f890, f885, f598, f889;
mul.f32 f892, f613, f885;
mul.f32 f2141, f612, f883;
sub.f32 f893, f2141, f892;
mul.f32 f894, f612, f885;
fma.rn.f32 f895, f613, f883, f894;
mul.f32 f2139, f893, f602;
mul.f32 f2140, f895, f603;
sub.f32 f898, f2139, f2140;
mul.f32 f899, f893, f603;
fma.rn.f32 f900, f895, f602, f899;
mul.f32 f2137, f612, f893;
mul.f32 f2138, f613, f895;
sub.f32 f903, f2137, f2138;
mul.f32 f904, f612, f895;
fma.rn.f32 f905, f613, f893, f904;
mul.f32 f2135, f903, f606;
mul.f32 f2136, f905, f607;
sub.f32 f908, f2135, f2136;
mul.f32 f909, f903, f607;
fma.rn.f32 f910, f905, f606, f909;
mul.f32 f2133, f612, f903;
mul.f32 f2134, f613, f905;
sub.f32 f913, f2133, f2134;
mov.u32 r32, %tid.x;
mul.f32 f914, f612, f905;
fma.rn.f32 f915, f613, f903, f914;
mul.f32 f917, f915, f611;
mul.f32 f2132, f913, f610;
sub.f32 f918, f2132, f917;
mul.f32 f919, f913, f611;
fma.rn.f32 f920, f915, f610, f919;
shl.b32 r8, r32, 7;
and.b32 r9, r8, -8192;
add.s32 r10, r4, r9;
barrier.sync 0;
and.b32 r11, r8, 8064;
add.s32 r12, r10, r11;
st.shared.v4.f32 [r12], {f548, f618, f628, f638};
st.shared.v4.f32 [r12+16], {f648, f658, f668, f678};
st.shared.v4.f32 [r12+32], {f688, f698, f708, f718};
st.shared.v4.f32 [r12+48], {f728, f738, f748, f758};
st.shared.v4.f32 [r12+64], {f768, f778, f788, f798};
st.shared.v4.f32 [r12+80], {f808, f818, f828, f838};
st.shared.v4.f32 [r12+96], {f848, f858, f868, f878};
st.shared.v4.f32 [r12+112], {f888, f898, f908, f918};
barrier.sync 0;
and.b32 r23, r32, 63;
mad.lo.s32 r13, r23, -124, r12;
ld.shared.f32 f921, [r13];
ld.shared.f32 f922, [r13+256];
ld.shared.f32 f923, [r13+512];
ld.shared.f32 f924, [r13+768];
ld.shared.f32 f925, [r13+1024];
ld.shared.f32 f926, [r13+1280];
ld.shared.f32 f927, [r13+1536];
ld.shared.f32 f928, [r13+1792];
ld.shared.f32 f929, [r13+2048];
ld.shared.f32 f930, [r13+2304];
ld.shared.f32 f931, [r13+2560];
ld.shared.f32 f932, [r13+2816];
ld.shared.f32 f933, [r13+3072];
ld.shared.f32 f934, [r13+3328];
ld.shared.f32 f935, [r13+3584];
ld.shared.f32 f936, [r13+3840];
ld.shared.f32 f937, [r13+4096];
ld.shared.f32 f938, [r13+4352];
ld.shared.f32 f939, [r13+4608];
ld.shared.f32 f940, [r13+4864];
ld.shared.f32 f941, [r13+5120];
ld.shared.f32 f942, [r13+5376];
ld.shared.f32 f943, [r13+5632];
ld.shared.f32 f944, [r13+5888];
ld.shared.f32 f945, [r13+6144];
ld.shared.f32 f946, [r13+6400];
ld.shared.f32 f947, [r13+6656];
ld.shared.f32 f948, [r13+6912];
ld.shared.f32 f949, [r13+7168];
ld.shared.f32 f950, [r13+7424];
ld.shared.f32 f951, [r13+7680];
ld.shared.f32 f952, [r13+7936];
barrier.sync 0;
st.shared.v4.f32 [r12], {f2235, f620, f630, f640};
st.shared.v4.f32 [r12+16], {f650, f660, f670, f680};
st.shared.v4.f32 [r12+32], {f690, f700, f710, f720};
st.shared.v4.f32 [r12+48], {f730, f740, f750, f760};
st.shared.v4.f32 [r12+64], {f770, f780, f790, f800};
st.shared.v4.f32 [r12+80], {f810, f820, f830, f840};
st.shared.v4.f32 [r12+96], {f850, f860, f870, f880};
st.shared.v4.f32 [r12+112], {f890, f900, f910, f920};
barrier.sync 0;
ld.shared.f32 f953, [r13];
ld.shared.f32 f954, [r13+256];
ld.shared.f32 f955, [r13+512];
ld.shared.f32 f956, [r13+768];
ld.shared.f32 f957, [r13+1024];
ld.shared.f32 f958, [r13+1280];
ld.shared.f32 f959, [r13+1536];
ld.shared.f32 f960, [r13+1792];
ld.shared.f32 f961, [r13+2048];
ld.shared.f32 f962, [r13+2304];
ld.shared.f32 f963, [r13+2560];
ld.shared.f32 f964, [r13+2816];
ld.shared.f32 f965, [r13+3072];
ld.shared.f32 f966, [r13+3328];
ld.shared.f32 f967, [r13+3584];
ld.shared.f32 f968, [r13+3840];
ld.shared.f32 f969, [r13+4096];
ld.shared.f32 f970, [r13+4352];
ld.shared.f32 f971, [r13+4608];
ld.shared.f32 f972, [r13+4864];
ld.shared.f32 f973, [r13+5120];
ld.shared.f32 f974, [r13+5376];
ld.shared.f32 f975, [r13+5632];
ld.shared.f32 f976, [r13+5888];
ld.shared.f32 f977, [r13+6144];
ld.shared.f32 f978, [r13+6400];
ld.shared.f32 f979, [r13+6656];
ld.shared.f32 f980, [r13+6912];
ld.shared.f32 f981, [r13+7168];
ld.shared.f32 f982, [r13+7424];
ld.shared.f32 f983, [r13+7680];
ld.shared.f32 f984, [r13+7936];
add.f32 f985, f921, f937;
sub.f32 f987, f921, f937;
add.f32 f2131, f953, f969;
sub.f32 f988, f953, f969;
add.f32 f989, f929, f945;
sub.f32 f991, f929, f945;
add.f32 f2130, f961, f977;
sub.f32 f992, f961, f977;
add.f32 f993, f985, f989;
sub.f32 f995, f985, f989;
add.f32 f2129, f2131, f2130;
sub.f32 f996, f2131, f2130;
add.f32 f997, f987, f992;
sub.f32 f999, f987, f992;
sub.f32 f2128, f988, f991;
add.f32 f1000, f988, f991;
add.f32 f1001, f925, f941;
sub.f32 f1003, f925, f941;
add.f32 f2127, f957, f973;
sub.f32 f1004, f957, f973;
add.f32 f1005, f933, f949;
sub.f32 f1007, f933, f949;
add.f32 f2126, f965, f981;
sub.f32 f1008, f965, f981;
add.f32 f1009, f1001, f1005;
sub.f32 f1011, f1001, f1005;
add.f32 f2125, f2127, f2126;
sub.f32 f1012, f2127, f2126;
add.f32 f1013, f1003, f1008;
sub.f32 f1015, f1003, f1008;
sub.f32 f2124, f1004, f1007;
add.f32 f1016, f1004, f1007;
mul.f32 f1018, f2124, 0fBF3504F3;
mul.f32 f2123, f1013, 0f3F3504F3;
sub.f32 f1019, f2123, f1018;
mul.f32 f1020, f2124, 0f3F3504F3;
fma.rn.f32 f1021, f1013, 0fBF3504F3, f1020;
mul.f32 f1022, f1015, 0fBF3504F3;
mul.f32 f1023, f1016, 0fBF3504F3;
sub.f32 f1024, f1022, f1023;
add.f32 f1025, f1022, f1023;
add.f32 f1026, f993, f1009;
sub.f32 f1028, f993, f1009;
add.f32 f2122, f2129, f2125;
sub.f32 f1029, f2129, f2125;
add.f32 f1030, f997, f1019;
sub.f32 f1032, f997, f1019;
add.f32 f2121, f2128, f1021;
sub.f32 f1033, f2128, f1021;
add.f32 f1034, f995, f1012;
sub.f32 f1036, f995, f1012;
sub.f32 f2120, f996, f1011;
add.f32 f1037, f996, f1011;
add.f32 f1038, f999, f1024;
sub.f32 f1040, f999, f1024;
add.f32 f2119, f1000, f1025;
sub.f32 f1041, f1000, f1025;
add.f32 f1042, f923, f939;
sub.f32 f1044, f923, f939;
add.f32 f2118, f955, f971;
sub.f32 f1045, f955, f971;
add.f32 f1046, f931, f947;
sub.f32 f1048, f931, f947;
add.f32 f2117, f963, f979;
sub.f32 f1049, f963, f979;
add.f32 f1050, f1042, f1046;
sub.f32 f1052, f1042, f1046;
add.f32 f2116, f2118, f2117;
sub.f32 f1053, f2118, f2117;
add.f32 f1054, f1044, f1049;
sub.f32 f1056, f1044, f1049;
sub.f32 f2115, f1045, f1048;
add.f32 f1057, f1045, f1048;
add.f32 f1058, f927, f943;
sub.f32 f1060, f927, f943;
add.f32 f2114, f959, f975;
sub.f32 f1061, f959, f975;
add.f32 f1062, f935, f951;
sub.f32 f1064, f935, f951;
add.f32 f2113, f967, f983;
sub.f32 f1065, f967, f983;
add.f32 f1066, f1058, f1062;
sub.f32 f1068, f1058, f1062;
add.f32 f2112, f2114, f2113;
sub.f32 f1069, f2114, f2113;
add.f32 f1070, f1060, f1065;
sub.f32 f1072, f1060, f1065;
sub.f32 f2111, f1061, f1064;
add.f32 f1073, f1061, f1064;
mul.f32 f1075, f2111, 0fBF3504F3;
mul.f32 f2110, f1070, 0f3F3504F3;
sub.f32 f1076, f2110, f1075;
mul.f32 f1077, f2111, 0f3F3504F3;
fma.rn.f32 f1078, f1070, 0fBF3504F3, f1077;
mul.f32 f1079, f1072, 0fBF3504F3;
mul.f32 f1080, f1073, 0fBF3504F3;
sub.f32 f1081, f1079, f1080;
add.f32 f1082, f1079, f1080;
add.f32 f1083, f1050, f1066;
sub.f32 f1085, f1050, f1066;
add.f32 f2109, f2116, f2112;
sub.f32 f1086, f2116, f2112;
add.f32 f1087, f1054, f1076;
sub.f32 f1089, f1054, f1076;
add.f32 f2108, f2115, f1078;
sub.f32 f1090, f2115, f1078;
add.f32 f1091, f1052, f1069;
sub.f32 f1093, f1052, f1069;
sub.f32 f2107, f1053, f1068;
add.f32 f1094, f1053, f1068;
add.f32 f1095, f1056, f1081;
sub.f32 f1097, f1056, f1081;
add.f32 f2106, f1057, f1082;
sub.f32 f1098, f1057, f1082;
mul.f32 f2104, f1087, 0f3F6C835E;
mul.f32 f2105, f2108, 0fBEC3EF15;
sub.f32 f1101, f2104, f2105;
mul.f32 f1102, f2108, 0f3F6C835E;
fma.rn.f32 f1103, f1087, 0fBEC3EF15, f1102;
mul.f32 f2102, f1091, 0f3F3504F3;
mul.f32 f2103, f2107, 0fBF3504F3;
sub.f32 f1106, f2102, f2103;
mul.f32 f1107, f2107, 0f3F3504F3;
fma.rn.f32 f1108, f1091, 0fBF3504F3, f1107;
mul.f32 f1110, f2106, 0fBF6C835E;
mul.f32 f2101, f1095, 0f3EC3EF15;
sub.f32 f1111, f2101, f1110;
mul.f32 f1112, f2106, 0f3EC3EF15;
fma.rn.f32 f1113, f1095, 0fBF6C835E, f1112;
mul.f32 f1115, f1090, 0fBF6C835E;
mul.f32 f2100, f1089, 0fBEC3EF15;
sub.f32 f1116, f2100, f1115;
mul.f32 f1117, f1090, 0fBEC3EF15;
fma.rn.f32 f1118, f1089, 0fBF6C835E, f1117;
mul.f32 f1119, f1093, 0fBF3504F3;
mul.f32 f1120, f1094, 0fBF3504F3;
sub.f32 f1121, f1119, f1120;
add.f32 f1122, f1119, f1120;
mul.f32 f2098, f1097, 0fBF6C835E;
mul.f32 f2099, f1098, 0fBEC3EF15;
sub.f32 f1125, f2098, f2099;
mul.f32 f1126, f1098, 0fBF6C835E;
fma.rn.f32 f1127, f1097, 0fBEC3EF15, f1126;
add.f32 f1128, f1026, f1083;
sub.f32 f1130, f1026, f1083;
add.f32 f2097, f2122, f2109;
sub.f32 f1131, f2122, f2109;
add.f32 f1132, f1030, f1101;
sub.f32 f1134, f1030, f1101;
add.f32 f2096, f2121, f1103;
sub.f32 f1135, f2121, f1103;
add.f32 f1136, f1034, f1106;
sub.f32 f1138, f1034, f1106;
add.f32 f2095, f2120, f1108;
sub.f32 f1139, f2120, f1108;
add.f32 f1140, f1038, f1111;
sub.f32 f1142, f1038, f1111;
add.f32 f2094, f2119, f1113;
sub.f32 f1143, f2119, f1113;
add.f32 f1144, f1028, f1086;
sub.f32 f1146, f1028, f1086;
sub.f32 f2093, f1029, f1085;
add.f32 f1147, f1029, f1085;
add.f32 f1148, f1032, f1116;
sub.f32 f1150, f1032, f1116;
add.f32 f2092, f1033, f1118;
sub.f32 f1151, f1033, f1118;
add.f32 f1152, f1036, f1121;
sub.f32 f1154, f1036, f1121;
add.f32 f2091, f1037, f1122;
sub.f32 f1155, f1037, f1122;
add.f32 f1156, f1040, f1125;
sub.f32 f1158, f1040, f1125;
add.f32 f2090, f1041, f1127;
sub.f32 f1159, f1041, f1127;
add.f32 f1160, f922, f938;
sub.f32 f1162, f922, f938;
add.f32 f2089, f954, f970;
sub.f32 f1163, f954, f970;
add.f32 f1164, f930, f946;
sub.f32 f1166, f930, f946;
add.f32 f2088, f962, f978;
sub.f32 f1167, f962, f978;
add.f32 f1168, f1160, f1164;
sub.f32 f1170, f1160, f1164;
add.f32 f2087, f2089, f2088;
sub.f32 f1171, f2089, f2088;
add.f32 f1172, f1162, f1167;
sub.f32 f1174, f1162, f1167;
sub.f32 f2086, f1163, f1166;
add.f32 f1175, f1163, f1166;
add.f32 f1176, f926, f942;
sub.f32 f1178, f926, f942;
add.f32 f2085, f958, f974;
sub.f32 f1179, f958, f974;
add.f32 f1180, f934, f950;
sub.f32 f1182, f934, f950;
add.f32 f2084, f966, f982;
sub.f32 f1183, f966, f982;
add.f32 f1184, f1176, f1180;
sub.f32 f1186, f1176, f1180;
add.f32 f2083, f2085, f2084;
sub.f32 f1187, f2085, f2084;
add.f32 f1188, f1178, f1183;
sub.f32 f1190, f1178, f1183;
sub.f32 f2082, f1179, f1182;
add.f32 f1191, f1179, f1182;
mul.f32 f1193, f2082, 0fBF3504F3;
mul.f32 f2081, f1188, 0f3F3504F3;
sub.f32 f1194, f2081, f1193;
mul.f32 f1195, f2082, 0f3F3504F3;
fma.rn.f32 f1196, f1188, 0fBF3504F3, f1195;
mul.f32 f1197, f1190, 0fBF3504F3;
mul.f32 f1198, f1191, 0fBF3504F3;
sub.f32 f1199, f1197, f1198;
add.f32 f1200, f1197, f1198;
add.f32 f1201, f1168, f1184;
sub.f32 f1203, f1168, f1184;
add.f32 f2080, f2087, f2083;
sub.f32 f1204, f2087, f2083;
add.f32 f1205, f1172, f1194;
sub.f32 f1207, f1172, f1194;
add.f32 f2079, f2086, f1196;
sub.f32 f1208, f2086, f1196;
add.f32 f1209, f1170, f1187;
sub.f32 f1211, f1170, f1187;
sub.f32 f2078, f1171, f1186;
add.f32 f1212, f1171, f1186;
add.f32 f1213, f1174, f1199;
sub.f32 f1215, f1174, f1199;
add.f32 f2077, f1175, f1200;
sub.f32 f1216, f1175, f1200;
add.f32 f1217, f924, f940;
sub.f32 f1219, f924, f940;
add.f32 f2076, f956, f972;
sub.f32 f1220, f956, f972;
add.f32 f1221, f932, f948;
sub.f32 f1223, f932, f948;
add.f32 f2075, f964, f980;
sub.f32 f1224, f964, f980;
add.f32 f1225, f1217, f1221;
sub.f32 f1227, f1217, f1221;
add.f32 f2074, f2076, f2075;
sub.f32 f1228, f2076, f2075;
add.f32 f1229, f1219, f1224;
sub.f32 f1231, f1219, f1224;
sub.f32 f2073, f1220, f1223;
add.f32 f1232, f1220, f1223;
add.f32 f1233, f928, f944;
sub.f32 f1235, f928, f944;
add.f32 f2072, f960, f976;
sub.f32 f1236, f960, f976;
add.f32 f1237, f936, f952;
sub.f32 f1239, f936, f952;
add.f32 f2071, f968, f984;
sub.f32 f1240, f968, f984;
add.f32 f1241, f1233, f1237;
sub.f32 f1243, f1233, f1237;
add.f32 f2070, f2072, f2071;
sub.f32 f1244, f2072, f2071;
add.f32 f1245, f1235, f1240;
sub.f32 f1247, f1235, f1240;
sub.f32 f2069, f1236, f1239;
add.f32 f1248, f1236, f1239;
mul.f32 f1250, f2069, 0fBF3504F3;
mul.f32 f2068, f1245, 0f3F3504F3;
sub.f32 f1251, f2068, f1250;
mul.f32 f1252, f2069, 0f3F3504F3;
fma.rn.f32 f1253, f1245, 0fBF3504F3, f1252;
mul.f32 f1254, f1247, 0fBF3504F3;
mul.f32 f1255, f1248, 0fBF3504F3;
sub.f32 f1256, f1254, f1255;
add.f32 f1257, f1254, f1255;
add.f32 f1258, f1225, f1241;
sub.f32 f1260, f1225, f1241;
add.f32 f2067, f2074, f2070;
sub.f32 f1261, f2074, f2070;
add.f32 f1262, f1229, f1251;
sub.f32 f1264, f1229, f1251;
add.f32 f2066, f2073, f1253;
sub.f32 f1265, f2073, f1253;
add.f32 f1266, f1227, f1244;
sub.f32 f1268, f1227, f1244;
sub.f32 f2065, f1228, f1243;
add.f32 f1269, f1228, f1243;
add.f32 f1270, f1231, f1256;
sub.f32 f1272, f1231, f1256;
add.f32 f2064, f1232, f1257;
sub.f32 f1273, f1232, f1257;
mul.f32 f2062, f1262, 0f3F6C835E;
mul.f32 f2063, f2066, 0fBEC3EF15;
sub.f32 f1276, f2062, f2063;
mul.f32 f1277, f2066, 0f3F6C835E;
fma.rn.f32 f1278, f1262, 0fBEC3EF15, f1277;
mul.f32 f2060, f1266, 0f3F3504F3;
mul.f32 f2061, f2065, 0fBF3504F3;
sub.f32 f1281, f2060, f2061;
mul.f32 f1282, f2065, 0f3F3504F3;
fma.rn.f32 f1283, f1266, 0fBF3504F3, f1282;
mul.f32 f2058, f1270, 0f3EC3EF15;
mul.f32 f2059, f2064, 0fBF6C835E;
sub.f32 f1286, f2058, f2059;
mul.f32 f1287, f2064, 0f3EC3EF15;
fma.rn.f32 f1288, f1270, 0fBF6C835E, f1287;
mul.f32 f2056, f1264, 0fBEC3EF15;
mul.f32 f2057, f1265, 0fBF6C835E;
sub.f32 f1291, f2056, f2057;
mul.f32 f1292, f1265, 0fBEC3EF15;
fma.rn.f32 f1293, f1264, 0fBF6C835E, f1292;
mul.f32 f1294, f1268, 0fBF3504F3;
mul.f32 f1295, f1269, 0fBF3504F3;
sub.f32 f1296, f1294, f1295;
add.f32 f1297, f1294, f1295;
mul.f32 f2054, f1272, 0fBF6C835E;
mul.f32 f2055, f1273, 0fBEC3EF15;
sub.f32 f1300, f2054, f2055;
mul.f32 f1301, f1273, 0fBF6C835E;
fma.rn.f32 f1302, f1272, 0fBEC3EF15, f1301;
add.f32 f1303, f1201, f1258;
sub.f32 f1305, f1201, f1258;
add.f32 f2053, f2080, f2067;
sub.f32 f1306, f2080, f2067;
add.f32 f1307, f1205, f1276;
sub.f32 f1309, f1205, f1276;
add.f32 f2052, f2079, f1278;
sub.f32 f1310, f2079, f1278;
add.f32 f1311, f1209, f1281;
sub.f32 f1313, f1209, f1281;
add.f32 f2051, f2078, f1283;
sub.f32 f1314, f2078, f1283;
add.f32 f1315, f1213, f1286;
sub.f32 f1317, f1213, f1286;
add.f32 f2050, f2077, f1288;
sub.f32 f1318, f2077, f1288;
add.f32 f1319, f1203, f1261;
sub.f32 f1321, f1203, f1261;
sub.f32 f2049, f1204, f1260;
add.f32 f1322, f1204, f1260;
add.f32 f1323, f1207, f1291;
sub.f32 f1325, f1207, f1291;
add.f32 f2048, f1208, f1293;
sub.f32 f1326, f1208, f1293;
add.f32 f1327, f1211, f1296;
sub.f32 f1329, f1211, f1296;
add.f32 f2047, f1212, f1297;
sub.f32 f1330, f1212, f1297;
add.f32 f1331, f1215, f1300;
sub.f32 f1333, f1215, f1300;
add.f32 f2046, f1216, f1302;
sub.f32 f1334, f1216, f1302;
mul.f32 f1336, f2052, 0fBE47C5C2;
mul.f32 f2045, f1307, 0f3F7B14BE;
sub.f32 f1337, f2045, f1336;
mul.f32 f1338, f2052, 0f3F7B14BE;
fma.rn.f32 f1339, f1307, 0fBE47C5C2, f1338;
mul.f32 f1341, f2051, 0fBEC3EF15;
mul.f32 f2044, f1311, 0f3F6C835E;
sub.f32 f1342, f2044, f1341;
mul.f32 f1343, f2051, 0f3F6C835E;
fma.rn.f32 f1344, f1311, 0fBEC3EF15, f1343;
mul.f32 f2042, f1315, 0f3F54DB31;
mul.f32 f2043, f2050, 0fBF0E39DA;
sub.f32 f1347, f2042, f2043;
mul.f32 f1348, f2050, 0f3F54DB31;
fma.rn.f32 f1349, f1315, 0fBF0E39DA, f1348;
mul.f32 f2040, f1319, 0f3F3504F3;
mul.f32 f2041, f2049, 0fBF3504F3;
sub.f32 f1352, f2040, f2041;
mul.f32 f1353, f2049, 0f3F3504F3;
fma.rn.f32 f1354, f1319, 0fBF3504F3, f1353;
mul.f32 f2038, f1323, 0f3F0E39DA;
mul.f32 f2039, f2048, 0fBF54DB31;
sub.f32 f1357, f2038, f2039;
mul.f32 f1358, f2048, 0f3F0E39DA;
fma.rn.f32 f1359, f1323, 0fBF54DB31, f1358;
mul.f32 f2036, f1327, 0f3EC3EF15;
mul.f32 f2037, f2047, 0fBF6C835E;
sub.f32 f1362, f2036, f2037;
mul.f32 f1363, f2047, 0f3EC3EF15;
fma.rn.f32 f1364, f1327, 0fBF6C835E, f1363;
mul.f32 f1366, f2046, 0fBF7B14BE;
mul.f32 f2035, f1331, 0f3E47C5C2;
sub.f32 f1367, f2035, f1366;
mul.f32 f1368, f2046, 0f3E47C5C2;
fma.rn.f32 f1369, f1331, 0fBF7B14BE, f1368;
mul.f32 f1371, f1310, 0fBF7B14BE;
mul.f32 f2034, f1309, 0fBE47C5C2;
sub.f32 f1372, f2034, f1371;
mul.f32 f1373, f1310, 0fBE47C5C2;
fma.rn.f32 f1374, f1309, 0fBF7B14BE, f1373;
mul.f32 f1376, f1314, 0fBF6C835E;
mul.f32 f2033, f1313, 0fBEC3EF15;
sub.f32 f1377, f2033, f1376;
mul.f32 f1378, f1314, 0fBEC3EF15;
fma.rn.f32 f1379, f1313, 0fBF6C835E, f1378;
mul.f32 f1381, f1318, 0fBF54DB31;
mul.f32 f2032, f1317, 0fBF0E39DA;
sub.f32 f1382, f2032, f1381;
mul.f32 f1383, f1318, 0fBF0E39DA;
fma.rn.f32 f1384, f1317, 0fBF54DB31, f1383;
mul.f32 f1385, f1321, 0fBF3504F3;
mul.f32 f1386, f1322, 0fBF3504F3;
sub.f32 f1387, f1385, f1386;
add.f32 f1388, f1385, f1386;
mul.f32 f1390, f1326, 0fBF0E39DA;
mul.f32 f2031, f1325, 0fBF54DB31;
sub.f32 f1391, f2031, f1390;
mul.f32 f1392, f1326, 0fBF54DB31;
fma.rn.f32 f1393, f1325, 0fBF0E39DA, f1392;
mul.f32 f1395, f1330, 0fBEC3EF15;
mul.f32 f2030, f1329, 0fBF6C835E;
sub.f32 f1396, f2030, f1395;
mul.f32 f1397, f1330, 0fBF6C835E;
fma.rn.f32 f1398, f1329, 0fBEC3EF15, f1397;
mul.f32 f1400, f1334, 0fBE47C5C2;
mul.f32 f2029, f1333, 0fBF7B14BE;
sub.f32 f1401, f2029, f1400;
mul.f32 f1402, f1334, 0fBF7B14BE;
fma.rn.f32 f1403, f1333, 0fBE47C5C2, f1402;
add.f32 f1404, f1128, f1303;
sub.f32 f1406, f1128, f1303;
add.f32 f2028, f2097, f2053;
sub.f32 f1407, f2097, f2053;
add.f32 f1408, f1132, f1337;
sub.f32 f1410, f1132, f1337;
add.f32 f2027, f2096, f1339;
sub.f32 f1411, f2096, f1339;
add.f32 f1412, f1136, f1342;
sub.f32 f1414, f1136, f1342;
add.f32 f2026, f2095, f1344;
sub.f32 f1415, f2095, f1344;
add.f32 f1416, f1140, f1347;
sub.f32 f1418, f1140, f1347;
add.f32 f2025, f2094, f1349;
sub.f32 f1419, f2094, f1349;
add.f32 f1420, f1144, f1352;
sub.f32 f1422, f1144, f1352;
add.f32 f2024, f2093, f1354;
sub.f32 f1423, f2093, f1354;
add.f32 f1424, f1148, f1357;
sub.f32 f1426, f1148, f1357;
add.f32 f2023, f2092, f1359;
sub.f32 f1427, f2092, f1359;
add.f32 f1428, f1152, f1362;
sub.f32 f1430, f1152, f1362;
add.f32 f2022, f2091, f1364;
sub.f32 f1431, f2091, f1364;
add.f32 f1432, f1156, f1367;
sub.f32 f1434, f1156, f1367;
add.f32 f2021, f2090, f1369;
sub.f32 f1435, f2090, f1369;
add.f32 f1436, f1130, f1306;
sub.f32 f1438, f1130, f1306;
sub.f32 f2020, f1131, f1305;
add.f32 f1439, f1131, f1305;
add.f32 f1440, f1134, f1372;
sub.f32 f1442, f1134, f1372;
add.f32 f2019, f1135, f1374;
sub.f32 f1443, f1135, f1374;
add.f32 f1444, f1138, f1377;
sub.f32 f1446, f1138, f1377;
add.f32 f2018, f1139, f1379;
sub.f32 f1447, f1139, f1379;
add.f32 f1448, f1142, f1382;
sub.f32 f1450, f1142, f1382;
add.f32 f2017, f1143, f1384;
sub.f32 f1451, f1143, f1384;
add.f32 f1452, f1146, f1387;
sub.f32 f1454, f1146, f1387;
add.f32 f2016, f1147, f1388;
sub.f32 f1455, f1147, f1388;
add.f32 f1456, f1150, f1391;
sub.f32 f1458, f1150, f1391;
add.f32 f2015, f1151, f1393;
sub.f32 f1459, f1151, f1393;
add.f32 f1460, f1154, f1396;
sub.f32 f1462, f1154, f1396;
add.f32 f2014, f1155, f1398;
sub.f32 f1463, f1155, f1398;
add.f32 f1464, f1158, f1401;
sub.f32 f1466, f1158, f1401;
add.f32 f2013, f1159, f1403;
sub.f32 f1467, f1159, f1403;
bfe.u32 r15, r32, 5, 1;
mul.wide.u32 rd6, r15, 8;
mov.u64 rd7, %66;
add.s64 rd8, rd7, rd6;
ld.global.v2.f32 {f1468, f1469}, [rd8];
mul.f32 f1473, f1469, f2027;
mul.f32 f2012, f1468, f1408;
sub.f32 f1474, f2012, f1473;
mul.f32 f1475, f1468, f2027;
fma.rn.f32 f1476, f1469, f1408, f1475;
mul.f32 f1478, f1469, f1469;
mul.f32 f2011, f1468, f1468;
sub.f32 f1479, f2011, f1478;
mul.f32 f1480, f1469, f1468;
fma.rn.f32 f1481, f1469, f1468, f1480;
mul.f32 f1483, f1481, f2026;
mul.f32 f2010, f1479, f1412;
sub.f32 f1484, f2010, f1483;
mul.f32 f1485, f1479, f2026;
fma.rn.f32 f1486, f1481, f1412, f1485;
mul.f32 f2008, f1468, f1479;
mul.f32 f2009, f1469, f1481;
sub.f32 f1489, f2008, f2009;
mul.f32 f1490, f1468, f1481;
fma.rn.f32 f1491, f1469, f1479, f1490;
mul.f32 f2006, f1489, f1416;
mul.f32 f2007, f1491, f2025;
sub.f32 f1494, f2006, f2007;
mul.f32 f1495, f1489, f2025;
fma.rn.f32 f1496, f1491, f1416, f1495;
mul.f32 f2004, f1468, f1489;
mul.f32 f2005, f1469, f1491;
sub.f32 f1499, f2004, f2005;
mul.f32 f1500, f1468, f1491;
fma.rn.f32 f1501, f1469, f1489, f1500;
mul.f32 f2002, f1499, f1420;
mul.f32 f2003, f1501, f2024;
sub.f32 f1504, f2002, f2003;
mul.f32 f1505, f1499, f2024;
fma.rn.f32 f1506, f1501, f1420, f1505;
mul.f32 f1508, f1469, f1501;
mul.f32 f2001, f1468, f1499;
sub.f32 f1509, f2001, f1508;
mul.f32 f1510, f1468, f1501;
fma.rn.f32 f1511, f1469, f1499, f1510;
mul.f32 f1513, f1511, f2023;
mul.f32 f2000, f1509, f1424;
sub.f32 f1514, f2000, f1513;
mul.f32 f1515, f1509, f2023;
fma.rn.f32 f1516, f1511, f1424, f1515;
mul.f32 f1518, f1469, f1511;
mul.f32 f1999, f1468, f1509;
sub.f32 f1519, f1999, f1518;
mul.f32 f1520, f1468, f1511;
fma.rn.f32 f1521, f1469, f1509, f1520;
mul.f32 f1523, f1521, f2022;
mul.f32 f1998, f1519, f1428;
sub.f32 f1524, f1998, f1523;
mul.f32 f1525, f1519, f2022;
fma.rn.f32 f1526, f1521, f1428, f1525;
mul.f32 f1528, f1469, f1521;
mul.f32 f1997, f1468, f1519;
sub.f32 f1529, f1997, f1528;
mul.f32 f1530, f1468, f1521;
fma.rn.f32 f1531, f1469, f1519, f1530;
mul.f32 f1995, f1529, f1432;
mul.f32 f1996, f1531, f2021;
sub.f32 f1534, f1995, f1996;
mul.f32 f1535, f1529, f2021;
fma.rn.f32 f1536, f1531, f1432, f1535;
mul.f32 f1993, f1468, f1529;
mul.f32 f1994, f1469, f1531;
sub.f32 f1539, f1993, f1994;
mul.f32 f1540, f1468, f1531;
fma.rn.f32 f1541, f1469, f1529, f1540;
mul.f32 f1991, f1539, f1436;
mul.f32 f1992, f1541, f2020;
sub.f32 f1544, f1991, f1992;
mul.f32 f1545, f1539, f2020;
fma.rn.f32 f1546, f1541, f1436, f1545;
mul.f32 f1989, f1468, f1539;
mul.f32 f1990, f1469, f1541;
sub.f32 f1549, f1989, f1990;
mul.f32 f1550, f1468, f1541;
fma.rn.f32 f1551, f1469, f1539, f1550;
mul.f32 f1553, f1551, f2019;
mul.f32 f1988, f1549, f1440;
sub.f32 f1554, f1988, f1553;
mul.f32 f1555, f1549, f2019;
fma.rn.f32 f1556, f1551, f1440, f1555;
mul.f32 f1558, f1469, f1551;
mul.f32 f1987, f1468, f1549;
sub.f32 f1559, f1987, f1558;
mul.f32 f1560, f1468, f1551;
fma.rn.f32 f1561, f1469, f1549, f1560;
mul.f32 f1563, f1561, f2018;
mul.f32 f1986, f1559, f1444;
sub.f32 f1564, f1986, f1563;
mul.f32 f1565, f1559, f2018;
fma.rn.f32 f1566, f1561, f1444, f1565;
mul.f32 f1568, f1469, f1561;
mul.f32 f1985, f1468, f1559;
sub.f32 f1569, f1985, f1568;
mul.f32 f1570, f1468, f1561;
fma.rn.f32 f1571, f1469, f1559, f1570;
mul.f32 f1573, f1571, f2017;
mul.f32 f1984, f1569, f1448;
sub.f32 f1574, f1984, f1573;
mul.f32 f1575, f1569, f2017;
fma.rn.f32 f1576, f1571, f1448, f1575;
mul.f32 f1578, f1469, f1571;
mul.f32 f1983, f1468, f1569;
sub.f32 f1579, f1983, f1578;
mul.f32 f1580, f1468, f1571;
fma.rn.f32 f1581, f1469, f1569, f1580;
mul.f32 f1981, f1579, f1452;
mul.f32 f1982, f1581, f2016;
sub.f32 f1584, f1981, f1982;
mul.f32 f1585, f1579, f2016;
fma.rn.f32 f1586, f1581, f1452, f1585;
mul.f32 f1979, f1468, f1579;
mul.f32 f1980, f1469, f1581;
sub.f32 f1589, f1979, f1980;
mul.f32 f1590, f1468, f1581;
fma.rn.f32 f1591, f1469, f1579, f1590;
mul.f32 f1977, f1589, f1456;
mul.f32 f1978, f1591, f2015;
sub.f32 f1594, f1977, f1978;
mul.f32 f1595, f1589, f2015;
fma.rn.f32 f1596, f1591, f1456, f1595;
mul.f32 f1598, f1469, f1591;
mul.f32 f1976, f1468, f1589;
sub.f32 f1599, f1976, f1598;
mul.f32 f1600, f1468, f1591;
fma.rn.f32 f1601, f1469, f1589, f1600;
mul.f32 f1603, f1601, f2014;
mul.f32 f1975, f1599, f1460;
sub.f32 f1604, f1975, f1603;
mul.f32 f1605, f1599, f2014;
fma.rn.f32 f1606, f1601, f1460, f1605;
mul.f32 f1608, f1469, f1601;
mul.f32 f1974, f1468, f1599;
sub.f32 f1609, f1974, f1608;
mul.f32 f1610, f1468, f1601;
fma.rn.f32 f1611, f1469, f1599, f1610;
mul.f32 f1613, f1611, f2013;
mul.f32 f1973, f1609, f1464;
sub.f32 f1614, f1973, f1613;
mul.f32 f1615, f1609, f2013;
fma.rn.f32 f1616, f1611, f1464, f1615;
mul.f32 f1618, f1469, f1611;
mul.f32 f1972, f1468, f1609;
sub.f32 f1619, f1972, f1618;
mul.f32 f1620, f1468, f1611;
fma.rn.f32 f1621, f1469, f1609, f1620;
mul.f32 f1623, f1621, f1407;
mul.f32 f1971, f1619, f1406;
sub.f32 f1624, f1971, f1623;
mul.f32 f1625, f1619, f1407;
fma.rn.f32 f1626, f1621, f1406, f1625;
mul.f32 f1969, f1468, f1619;
mul.f32 f1970, f1469, f1621;
sub.f32 f1629, f1969, f1970;
mul.f32 f1630, f1468, f1621;
fma.rn.f32 f1631, f1469, f1619, f1630;
mul.f32 f1967, f1629, f1410;
mul.f32 f1968, f1631, f1411;
sub.f32 f1634, f1967, f1968;
mul.f32 f1635, f1629, f1411;
fma.rn.f32 f1636, f1631, f1410, f1635;
mul.f32 f1965, f1468, f1629;
mul.f32 f1966, f1469, f1631;
sub.f32 f1639, f1965, f1966;
mul.f32 f1640, f1468, f1631;
fma.rn.f32 f1641, f1469, f1629, f1640;
mul.f32 f1963, f1639, f1414;
mul.f32 f1964, f1641, f1415;
sub.f32 f1644, f1963, f1964;
mul.f32 f1645, f1639, f1415;
fma.rn.f32 f1646, f1641, f1414, f1645;
mul.f32 f1648, f1469, f1641;
mul.f32 f1962, f1468, f1639;
sub.f32 f1649, f1962, f1648;
mul.f32 f1650, f1468, f1641;
fma.rn.f32 f1651, f1469, f1639, f1650;
mul.f32 f1653, f1651, f1419;
mul.f32 f1961, f1649, f1418;
sub.f32 f1654, f1961, f1653;
mul.f32 f1655, f1649, f1419;
fma.rn.f32 f1656, f1651, f1418, f1655;
mul.f32 f1658, f1469, f1651;
mul.f32 f1960, f1468, f1649;
sub.f32 f1659, f1960, f1658;
mul.f32 f1660, f1468, f1651;
fma.rn.f32 f1661, f1469, f1649, f1660;
mul.f32 f1663, f1661, f1423;
mul.f32 f1959, f1659, f1422;
sub.f32 f1664, f1959, f1663;
mul.f32 f1665, f1659, f1423;
fma.rn.f32 f1666, f1661, f1422, f1665;
mul.f32 f1668, f1469, f1661;
mul.f32 f1958, f1468, f1659;
sub.f32 f1669, f1958, f1668;
mul.f32 f1670, f1468, f1661;
fma.rn.f32 f1671, f1469, f1659, f1670;
mul.f32 f1956, f1669, f1426;
mul.f32 f1957, f1671, f1427;
sub.f32 f1674, f1956, f1957;
mul.f32 f1675, f1669, f1427;
fma.rn.f32 f1676, f1671, f1426, f1675;
mul.f32 f1954, f1468, f1669;
mul.f32 f1955, f1469, f1671;
sub.f32 f1679, f1954, f1955;
mul.f32 f1680, f1468, f1671;
fma.rn.f32 f1681, f1469, f1669, f1680;
mul.f32 f1952, f1679, f1430;
mul.f32 f1953, f1681, f1431;
sub.f32 f1684, f1952, f1953;
mul.f32 f1685, f1679, f1431;
fma.rn.f32 f1686, f1681, f1430, f1685;
mul.f32 f1950, f1468, f1679;
mul.f32 f1951, f1469, f1681;
sub.f32 f1689, f1950, f1951;
mul.f32 f1690, f1468, f1681;
fma.rn.f32 f1691, f1469, f1679, f1690;
mul.f32 f1693, f1691, f1435;
mul.f32 f1949, f1689, f1434;
sub.f32 f1694, f1949, f1693;
mul.f32 f1695, f1689, f1435;
fma.rn.f32 f1696, f1691, f1434, f1695;
mul.f32 f1698, f1469, f1691;
mul.f32 f1948, f1468, f1689;
sub.f32 f1699, f1948, f1698;
mul.f32 f1700, f1468, f1691;
fma.rn.f32 f1701, f1469, f1689, f1700;
mul.f32 f1703, f1701, f1439;
mul.f32 f1947, f1699, f1438;
sub.f32 f1704, f1947, f1703;
mul.f32 f1705, f1699, f1439;
fma.rn.f32 f1706, f1701, f1438, f1705;
mul.f32 f1708, f1469, f1701;
mul.f32 f1946, f1468, f1699;
sub.f32 f1709, f1946, f1708;
mul.f32 f1710, f1468, f1701;
fma.rn.f32 f1711, f1469, f1699, f1710;
mul.f32 f1713, f1711, f1443;
mul.f32 f1945, f1709, f1442;
sub.f32 f1714, f1945, f1713;
mul.f32 f1715, f1709, f1443;
fma.rn.f32 f1716, f1711, f1442, f1715;
mul.f32 f1943, f1468, f1709;
mul.f32 f1944, f1469, f1711;
sub.f32 f1719, f1943, f1944;
mul.f32 f1720, f1468, f1711;
fma.rn.f32 f1721, f1469, f1709, f1720;
mul.f32 f1941, f1719, f1446;
mul.f32 f1942, f1721, f1447;
sub.f32 f1724, f1941, f1942;
mul.f32 f1725, f1719, f1447;
fma.rn.f32 f1726, f1721, f1446, f1725;
mul.f32 f1939, f1468, f1719;
mul.f32 f1940, f1469, f1721;
sub.f32 f1729, f1939, f1940;
mul.f32 f1730, f1468, f1721;
fma.rn.f32 f1731, f1469, f1719, f1730;
mul.f32 f1937, f1729, f1450;
mul.f32 f1938, f1731, f1451;
sub.f32 f1734, f1937, f1938;
mul.f32 f1735, f1729, f1451;
fma.rn.f32 f1736, f1731, f1450, f1735;
mul.f32 f1738, f1469, f1731;
mul.f32 f1936, f1468, f1729;
sub.f32 f1739, f1936, f1738;
mul.f32 f1740, f1468, f1731;
fma.rn.f32 f1741, f1469, f1729, f1740;
mul.f32 f1743, f1741, f1455;
mul.f32 f1935, f1739, f1454;
sub.f32 f1744, f1935, f1743;
mul.f32 f1745, f1739, f1455;
fma.rn.f32 f1746, f1741, f1454, f1745;
mul.f32 f1748, f1469, f1741;
mul.f32 f1934, f1468, f1739;
sub.f32 f1749, f1934, f1748;
mul.f32 f1750, f1468, f1741;
fma.rn.f32 f1751, f1469, f1739, f1750;
mul.f32 f1753, f1751, f1459;
mul.f32 f1933, f1749, f1458;
sub.f32 f1754, f1933, f1753;
mul.f32 f1755, f1749, f1459;
fma.rn.f32 f1756, f1751, f1458, f1755;
mul.f32 f1758, f1469, f1751;
mul.f32 f1932, f1468, f1749;
sub.f32 f1759, f1932, f1758;
mul.f32 f1760, f1468, f1751;
fma.rn.f32 f1761, f1469, f1749, f1760;
mul.f32 f1930, f1759, f1462;
mul.f32 f1931, f1761, f1463;
sub.f32 f1764, f1930, f1931;
mul.f32 f1765, f1759, f1463;
fma.rn.f32 f1766, f1761, f1462, f1765;
mul.f32 f1928, f1468, f1759;
mul.f32 f1929, f1469, f1761;
sub.f32 f1769, f1928, f1929;
mov.u32 r28, %tid.x;
shl.b32 r27, r28, 7;
mul.f32 f1770, f1468, f1761;
mov.u32 r31, %tid.x;
shl.b32 r30, r31, 7;
fma.rn.f32 f1771, f1469, f1759, f1770;
mul.f32 f1926, f1769, f1466;
mul.f32 f1927, f1771, f1467;
sub.f32 f1774, f1926, f1927;
mul.f32 f1775, f1769, f1467;
mov.u32 r33, %tid.x;
fma.rn.f32 f1776, f1771, f1466, f1775;
and.b32 r22, r33, 32;
shl.b32 r16, r33, 2;
and.b32 r17, r16, 124;
add.s32 r18, r10, r17;
barrier.sync 0;
and.b32 r19, r30, 4096;
add.s32 r20, r18, r19;
st.shared.f32 [r20], f1404;
st.shared.f32 [r20+128], f1474;
st.shared.f32 [r20+256], f1484;
st.shared.f32 [r20+384], f1494;
st.shared.f32 [r20+512], f1504;
st.shared.f32 [r20+640], f1514;
st.shared.f32 [r20+768], f1524;
st.shared.f32 [r20+896], f1534;
st.shared.f32 [r20+1024], f1544;
st.shared.f32 [r20+1152], f1554;
st.shared.f32 [r20+1280], f1564;
st.shared.f32 [r20+1408], f1574;
st.shared.f32 [r20+1536], f1584;
st.shared.f32 [r20+1664], f1594;
st.shared.f32 [r20+1792], f1604;
st.shared.f32 [r20+1920], f1614;
st.shared.f32 [r20+2048], f1624;
st.shared.f32 [r20+2176], f1634;
st.shared.f32 [r20+2304], f1644;
st.shared.f32 [r20+2432], f1654;
st.shared.f32 [r20+2560], f1664;
st.shared.f32 [r20+2688], f1674;
st.shared.f32 [r20+2816], f1684;
st.shared.f32 [r20+2944], f1694;
st.shared.f32 [r20+3072], f1704;
st.shared.f32 [r20+3200], f1714;
st.shared.f32 [r20+3328], f1724;
st.shared.f32 [r20+3456], f1734;
st.shared.f32 [r20+3584], f1744;
st.shared.f32 [r20+3712], f1754;
st.shared.f32 [r20+3840], f1764;
st.shared.f32 [r20+3968], f1774;
barrier.sync 0;
mad.lo.s32 r21, r22, -124, r20;
ld.shared.f32 f1777, [r21];
ld.shared.f32 f1778, [r21+256];
ld.shared.f32 f1779, [r21+512];
ld.shared.f32 f1780, [r21+768];
ld.shared.f32 f1781, [r21+1024];
ld.shared.f32 f1782, [r21+1280];
ld.shared.f32 f1783, [r21+1536];
ld.shared.f32 f1784, [r21+1792];
ld.shared.f32 f1785, [r21+2048];
ld.shared.f32 f1786, [r21+2304];
ld.shared.f32 f1787, [r21+2560];
ld.shared.f32 f1788, [r21+2816];
ld.shared.f32 f1789, [r21+3072];
ld.shared.f32 f1790, [r21+3328];
ld.shared.f32 f1791, [r21+3584];
ld.shared.f32 f1792, [r21+3840];
ld.shared.f32 f1793, [r21+4096];
ld.shared.f32 f1794, [r21+4352];
ld.shared.f32 f1795, [r21+4608];
ld.shared.f32 f1796, [r21+4864];
ld.shared.f32 f1797, [r21+5120];
ld.shared.f32 f1798, [r21+5376];
ld.shared.f32 f1799, [r21+5632];
ld.shared.f32 f1800, [r21+5888];
ld.shared.f32 f1801, [r21+6144];
ld.shared.f32 f1802, [r21+6400];
ld.shared.f32 f1803, [r21+6656];
ld.shared.f32 f1804, [r21+6912];
ld.shared.f32 f1805, [r21+7168];
ld.shared.f32 f1806, [r21+7424];
ld.shared.f32 f1807, [r21+7680];
ld.shared.f32 f1808, [r21+7936];
barrier.sync 0;
st.shared.f32 [r20], f2028;
st.shared.f32 [r20+128], f1476;
st.shared.f32 [r20+256], f1486;
st.shared.f32 [r20+384], f1496;
st.shared.f32 [r20+512], f1506;
st.shared.f32 [r20+640], f1516;
st.shared.f32 [r20+768], f1526;
st.shared.f32 [r20+896], f1536;
st.shared.f32 [r20+1024], f1546;
st.shared.f32 [r20+1152], f1556;
st.shared.f32 [r20+1280], f1566;
st.shared.f32 [r20+1408], f1576;
st.shared.f32 [r20+1536], f1586;
st.shared.f32 [r20+1664], f1596;
st.shared.f32 [r20+1792], f1606;
st.shared.f32 [r20+1920], f1616;
st.shared.f32 [r20+2048], f1626;
st.shared.f32 [r20+2176], f1636;
st.shared.f32 [r20+2304], f1646;
st.shared.f32 [r20+2432], f1656;
st.shared.f32 [r20+2560], f1666;
st.shared.f32 [r20+2688], f1676;
st.shared.f32 [r20+2816], f1686;
st.shared.f32 [r20+2944], f1696;
st.shared.f32 [r20+3072], f1706;
st.shared.f32 [r20+3200], f1716;
st.shared.f32 [r20+3328], f1726;
st.shared.f32 [r20+3456], f1736;
st.shared.f32 [r20+3584], f1746;
st.shared.f32 [r20+3712], f1756;
st.shared.f32 [r20+3840], f1766;
st.shared.f32 [r20+3968], f1776;
barrier.sync 0;
ld.shared.f32 f1809, [r21];
ld.shared.f32 f1810, [r21+256];
ld.shared.f32 f1811, [r21+512];
ld.shared.f32 f1812, [r21+768];
ld.shared.f32 f1813, [r21+1024];
ld.shared.f32 f1814, [r21+1280];
ld.shared.f32 f1815, [r21+1536];
ld.shared.f32 f1816, [r21+1792];
ld.shared.f32 f1817, [r21+2048];
ld.shared.f32 f1818, [r21+2304];
ld.shared.f32 f1819, [r21+2560];
ld.shared.f32 f1820, [r21+2816];
ld.shared.f32 f1821, [r21+3072];
ld.shared.f32 f1822, [r21+3328];
ld.shared.f32 f1823, [r21+3584];
ld.shared.f32 f1824, [r21+3840];
ld.shared.f32 f1825, [r21+4096];
ld.shared.f32 f1826, [r21+4352];
ld.shared.f32 f1827, [r21+4608];
ld.shared.f32 f1828, [r21+4864];
ld.shared.f32 f1829, [r21+5120];
ld.shared.f32 f1830, [r21+5376];
ld.shared.f32 f1831, [r21+5632];
ld.shared.f32 f1832, [r21+5888];
ld.shared.f32 f1833, [r21+6144];
ld.shared.f32 f1834, [r21+6400];
ld.shared.f32 f1835, [r21+6656];
ld.shared.f32 f1836, [r21+6912];
ld.shared.f32 f1837, [r21+7168];
ld.shared.f32 f1838, [r21+7424];
ld.shared.f32 f1839, [r21+7680];
ld.shared.f32 f1840, [r21+7936];
add.f32 %1, f1809, f1825;
add.f32 %0, f1777, f1793;
add.f32 %3, f1810, f1826;
add.f32 %2, f1778, f1794;
add.f32 %5, f1811, f1827;
add.f32 %4, f1779, f1795;
add.f32 %7, f1812, f1828;
add.f32 %6, f1780, f1796;
add.f32 %8, f1781, f1797;
add.f32 %9, f1813, f1829;
add.f32 %10, f1782, f1798;
add.f32 %11, f1814, f1830;
add.f32 %13, f1815, f1831;
add.f32 %12, f1783, f1799;
add.f32 %15, f1816, f1832;
add.f32 %14, f1784, f1800;
add.f32 %17, f1817, f1833;
add.f32 %16, f1785, f1801;
add.f32 %19, f1818, f1834;
add.f32 %18, f1786, f1802;
add.f32 %20, f1787, f1803;
add.f32 %21, f1819, f1835;
add.f32 %22, f1788, f1804;
add.f32 %23, f1820, f1836;
add.f32 %24, f1789, f1805;
add.f32 %25, f1821, f1837;
add.f32 %27, f1822, f1838;
add.f32 %26, f1790, f1806;
add.f32 %29, f1823, f1839;
add.f32 %28, f1791, f1807;
add.f32 %31, f1824, f1840;
add.f32 %30, f1792, f1808;
sub.f32 %32, f1777, f1793;
sub.f32 %33, f1809, f1825;
sub.f32 %34, f1778, f1794;
sub.f32 %35, f1810, f1826;
sub.f32 %36, f1779, f1795;
sub.f32 %37, f1811, f1827;
sub.f32 %38, f1780, f1796;
sub.f32 %39, f1812, f1828;
sub.f32 %40, f1781, f1797;
sub.f32 %41, f1813, f1829;
sub.f32 %42, f1782, f1798;
sub.f32 %43, f1814, f1830;
sub.f32 %44, f1783, f1799;
sub.f32 %45, f1815, f1831;
sub.f32 %46, f1784, f1800;
sub.f32 %47, f1816, f1832;
sub.f32 %48, f1785, f1801;
sub.f32 %49, f1817, f1833;
sub.f32 %50, f1786, f1802;
sub.f32 %51, f1818, f1834;
sub.f32 %52, f1787, f1803;
sub.f32 %53, f1819, f1835;
sub.f32 %54, f1788, f1804;
sub.f32 %55, f1820, f1836;
sub.f32 %56, f1789, f1805;
sub.f32 %57, f1821, f1837;
sub.f32 %58, f1790, f1806;
sub.f32 %59, f1822, f1838;
sub.f32 %60, f1791, f1807;
sub.f32 %61, f1823, f1839;
sub.f32 %62, f1792, f1808;
sub.f32 %63, f1824, f1840;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y), "=f"(rmem[2].x), "=f"(rmem[2].y), "=f"(rmem[3].x), "=f"(rmem[3].y), "=f"(rmem[4].x), "=f"(rmem[4].y), "=f"(rmem[5].x), "=f"(rmem[5].y), "=f"(rmem[6].x), "=f"(rmem[6].y), "=f"(rmem[7].x), "=f"(rmem[7].y), "=f"(rmem[8].x), "=f"(rmem[8].y), "=f"(rmem[9].x), "=f"(rmem[9].y), "=f"(rmem[10].x), "=f"(rmem[10].y), "=f"(rmem[11].x), "=f"(rmem[11].y), "=f"(rmem[12].x), "=f"(rmem[12].y), "=f"(rmem[13].x), "=f"(rmem[13].y), "=f"(rmem[14].x), "=f"(rmem[14].y), "=f"(rmem[15].x), "=f"(rmem[15].y), "=f"(rmem[16].x), "=f"(rmem[16].y), "=f"(rmem[17].x), "=f"(rmem[17].y), "=f"(rmem[18].x), "=f"(rmem[18].y), "=f"(rmem[19].x), "=f"(rmem[19].y), "=f"(rmem[20].x), "=f"(rmem[20].y), "=f"(rmem[21].x), "=f"(rmem[21].y), "=f"(rmem[22].x), "=f"(rmem[22].y), "=f"(rmem[23].x), "=f"(rmem[23].y), "=f"(rmem[24].x), "=f"(rmem[24].y), "=f"(rmem[25].x), "=f"(rmem[25].y), "=f"(rmem[26].x), "=f"(rmem[26].y), "=f"(rmem[27].x), "=f"(rmem[27].y), "=f"(rmem[28].x), "=f"(rmem[28].y), "=f"(rmem[29].x), "=f"(rmem[29].y), "=f"(rmem[30].x), "=f"(rmem[30].y), "=f"(rmem[31].x), "=f"(rmem[31].y): "r"(smem), "l"(lut_sp_32_2048), "l"(lut_sp_32_64), "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y), "f"(rmem[2].x), "f"(rmem[2].y), "f"(rmem[3].x), "f"(rmem[3].y), "f"(rmem[4].x), "f"(rmem[4].y), "f"(rmem[5].x), "f"(rmem[5].y), "f"(rmem[6].x), "f"(rmem[6].y), "f"(rmem[7].x), "f"(rmem[7].y), "f"(rmem[8].x), "f"(rmem[8].y), "f"(rmem[9].x), "f"(rmem[9].y), "f"(rmem[10].x), "f"(rmem[10].y), "f"(rmem[11].x), "f"(rmem[11].y), "f"(rmem[12].x), "f"(rmem[12].y), "f"(rmem[13].x), "f"(rmem[13].y), "f"(rmem[14].x), "f"(rmem[14].y), "f"(rmem[15].x), "f"(rmem[15].y), "f"(rmem[16].x), "f"(rmem[16].y), "f"(rmem[17].x), "f"(rmem[17].y), "f"(rmem[18].x), "f"(rmem[18].y), "f"(rmem[19].x), "f"(rmem[19].y), "f"(rmem[20].x), "f"(rmem[20].y), "f"(rmem[21].x), "f"(rmem[21].y), "f"(rmem[22].x), "f"(rmem[22].y), "f"(rmem[23].x), "f"(rmem[23].y), "f"(rmem[24].x), "f"(rmem[24].y), "f"(rmem[25].x), "f"(rmem[25].y), "f"(rmem[26].x), "f"(rmem[26].y), "f"(rmem[27].x), "f"(rmem[27].y), "f"(rmem[28].x), "f"(rmem[28].y), "f"(rmem[29].x), "f"(rmem[29].y), "f"(rmem[30].x), "f"(rmem[30].y), "f"(rmem[31].x), "f"(rmem[31].y), "f"(rmem[16].y), "f"(rmem[8].y), "f"(rmem[4].y), "f"(rmem[20].y), "f"(rmem[28].y), "f"(rmem[2].y), "f"(rmem[26].y), "f"(rmem[10].y), "f"(rmem[22].y), "f"(rmem[14].y), "f"(rmem[17].y), "f"(rmem[1].y), "f"(rmem[25].y), "f"(rmem[5].y), "f"(rmem[29].y), "f"(rmem[13].y), "f"(rmem[19].y), "f"(rmem[11].y), "f"(rmem[7].y), "f"(rmem[23].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<97, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<330>;
.reg .b32 r<42>;
.reg .b64 rd<18>;
mov.u32 r1, %tid.y;
shl.b32 r2, r1, 14;
mov.u32 r3, %8;
add.s32 r4, r3, r2;
mov.u32 r5, %tid.x;
add.f32 f17, %14, %19;
add.f32 f18, %15, %21;
sub.f32 f19, %14, %19;
sub.f32 f20, %15, %21;
add.f32 f21, %16, %22;
add.f32 f22, %18, %23;
sub.f32 f23, %16, %22;
sub.f32 f24, %18, %23;
sub.f32 f25, f17, f21;
sub.f32 f26, f18, f22;
add.f32 f27, f19, f24;
sub.f32 f28, f20, f23;
sub.f32 f29, f19, f24;
add.f32 f30, f20, f23;
and.b32 r6, r5, 511;
shl.b32 r7, r5, 5;
and.b32 r8, r7, -16384;
add.s32 r9, r4, r8;
shl.b32 r10, r5, 3;
cvt.u64.u32 rd2, r10;
and.b64 rd3, rd2, 4088;
mov.u64 rd4, %9;
add.s64 rd5, rd4, rd3;
ld.global.v2.f32 {f31, f32}, [rd5];
mul.f32 f35, f31, f27;
mul.f32 f36, f32, f28;
mul.f32 f37, f31, f28;
mul.f32 f38, f31, f31;
mul.f32 f39, f32, f32;
sub.f32 f40, f38, f39;
mul.f32 f41, f32, f31;
fma.rn.f32 f42, f32, f31, f41;
mul.f32 f43, f40, f25;
mul.f32 f44, f42, f26;
mul.f32 f45, f40, f26;
mul.f32 f46, f31, f40;
mul.f32 f47, f32, f42;
sub.f32 f48, f46, f47;
mul.f32 f49, f31, f42;
fma.rn.f32 f50, f32, f40, f49;
mul.f32 f51, f48, f29;
mul.f32 f52, f50, f30;
mul.f32 f53, f48, f30;
barrier.sync 0;
and.b32 r11, r7, 16352;
add.s32 r12, r9, r11;
add.f32 f54, f18, f22;
add.f32 f55, f17, f21;
fma.rn.f32 f56, f32, f27, f37;
sub.f32 f57, f35, f36;
st.shared.v4.f32 [r12], {f55, f54, f57, f56};
sub.f32 f58, f43, f44;
fma.rn.f32 f59, f42, f25, f45;
fma.rn.f32 f60, f50, f29, f53;
sub.f32 f61, f51, f52;
st.shared.v4.f32 [r12+16], {f58, f59, f61, f60};
barrier.sync 0;
mad.lo.s32 r13, r6, -24, r12;
ld.shared.v2.f32 {f62, f63}, [r13];
ld.shared.v2.f32 {f66, f67}, [r13+4096];
ld.shared.v2.f32 {f70, f71}, [r13+8192];
ld.shared.v2.f32 {f74, f75}, [r13+12288];
add.f32 f78, f62, f70;
add.f32 f79, f63, f71;
sub.f32 f80, f62, f70;
sub.f32 f81, f63, f71;
add.f32 f82, f66, f74;
add.f32 f83, f67, f75;
sub.f32 f84, f66, f74;
sub.f32 f85, f67, f75;
sub.f32 f86, f78, f82;
sub.f32 f87, f79, f83;
add.f32 f88, f80, f85;
sub.f32 f89, f81, f84;
sub.f32 f90, f80, f85;
add.f32 f91, f81, f84;
and.b32 r14, r5, 508;
bfe.u32 r15, r5, 2, 7;
mul.wide.u32 rd6, r15, 8;
mov.u64 rd7, %10;
add.s64 rd8, rd7, rd6;
ld.global.v2.f32 {f92, f93}, [rd8];
mul.f32 f96, f92, f88;
mul.f32 f97, f93, f89;
mul.f32 f98, f92, f89;
mul.f32 f99, f92, f92;
mul.f32 f100, f93, f93;
sub.f32 f101, f99, f100;
mul.f32 f102, f93, f92;
fma.rn.f32 f103, f93, f92, f102;
mul.f32 f104, f101, f86;
mul.f32 f105, f103, f87;
mul.f32 f106, f101, f87;
mul.f32 f107, f92, f101;
mul.f32 f108, f93, f103;
sub.f32 f109, f107, f108;
mul.f32 f110, f92, f103;
fma.rn.f32 f111, f93, f101, f110;
mul.f32 f112, f109, f90;
mul.f32 f113, f111, f91;
mul.f32 f114, f109, f91;
and.b32 r16, r10, 24;
add.s32 r17, r9, r16;
barrier.sync 0;
and.b32 r18, r7, 16256;
add.s32 r19, r17, r18;
add.f32 f115, f79, f83;
add.f32 f116, f78, f82;
st.shared.v2.f32 [r19], {f116, f115};
fma.rn.f32 f117, f93, f88, f98;
sub.f32 f118, f96, f97;
st.shared.v2.f32 [r19+32], {f118, f117};
fma.rn.f32 f119, f103, f86, f106;
sub.f32 f120, f104, f105;
st.shared.v2.f32 [r19+64], {f120, f119};
sub.f32 f121, f112, f113;
fma.rn.f32 f122, f111, f90, f114;
st.shared.v2.f32 [r19+96], {f121, f122};
barrier.sync 0;
mad.lo.s32 r20, r14, -24, r19;
ld.shared.v2.f32 {f123, f124}, [r20];
ld.shared.v2.f32 {f127, f128}, [r20+4096];
ld.shared.v2.f32 {f131, f132}, [r20+8192];
ld.shared.v2.f32 {f135, f136}, [r20+12288];
add.f32 f139, f123, f131;
add.f32 f140, f124, f132;
sub.f32 f141, f123, f131;
sub.f32 f142, f124, f132;
add.f32 f143, f127, f135;
add.f32 f144, f128, f136;
sub.f32 f145, f127, f135;
sub.f32 f146, f128, f136;
sub.f32 f147, f139, f143;
sub.f32 f148, f140, f144;
add.f32 f149, f141, f146;
sub.f32 f150, f142, f145;
sub.f32 f151, f141, f146;
add.f32 f152, f142, f145;
and.b32 r21, r5, 496;
bfe.u32 r22, r5, 4, 5;
mul.wide.u32 rd9, r22, 8;
mov.u64 rd10, %11;
add.s64 rd11, rd10, rd9;
ld.global.v2.f32 {f153, f154}, [rd11];
mul.f32 f157, f153, f149;
mul.f32 f158, f154, f150;
mul.f32 f159, f153, f150;
mul.f32 f160, f153, f153;
mul.f32 f161, f154, f154;
sub.f32 f162, f160, f161;
mul.f32 f163, f154, f153;
fma.rn.f32 f164, f154, f153, f163;
mul.f32 f165, f162, f147;
mul.f32 f166, f164, f148;
mul.f32 f167, f162, f148;
mul.f32 f168, f153, f162;
mul.f32 f169, f154, f164;
sub.f32 f170, f168, f169;
mul.f32 f171, f153, f164;
fma.rn.f32 f172, f154, f162, f171;
mul.f32 f173, f170, f151;
mul.f32 f174, f172, f152;
mul.f32 f175, f170, f152;
and.b32 r23, r10, 120;
add.s32 r24, r9, r23;
barrier.sync 0;
and.b32 r25, r7, 15872;
add.s32 r26, r24, r25;
add.f32 f176, f140, f144;
add.f32 f177, f139, f143;
st.shared.v2.f32 [r26], {f177, f176};
fma.rn.f32 f178, f154, f149, f159;
sub.f32 f179, f157, f158;
st.shared.v2.f32 [r26+128], {f179, f178};
fma.rn.f32 f180, f164, f147, f167;
sub.f32 f181, f165, f166;
st.shared.v2.f32 [r26+256], {f181, f180};
sub.f32 f182, f173, f174;
fma.rn.f32 f183, f172, f151, f175;
st.shared.v2.f32 [r26+384], {f182, f183};
barrier.sync 0;
mad.lo.s32 r27, r21, -24, r26;
ld.shared.v2.f32 {f184, f185}, [r27];
ld.shared.v2.f32 {f188, f189}, [r27+4096];
ld.shared.v2.f32 {f192, f193}, [r27+8192];
ld.shared.v2.f32 {f196, f197}, [r27+12288];
add.f32 f200, f184, f192;
add.f32 f201, f185, f193;
sub.f32 f202, f184, f192;
sub.f32 f203, f185, f193;
add.f32 f204, f188, f196;
add.f32 f205, f189, f197;
sub.f32 f206, f188, f196;
sub.f32 f207, f189, f197;
sub.f32 f208, f200, f204;
sub.f32 f209, f201, f205;
add.f32 f210, f202, f207;
sub.f32 f211, f203, f206;
sub.f32 f212, f202, f207;
add.f32 f213, f203, f206;
and.b32 r28, r5, 448;
bfe.u32 r29, r5, 6, 3;
mul.wide.u32 rd12, r29, 8;
mov.u64 rd13, %12;
add.s64 rd14, rd13, rd12;
ld.global.v2.f32 {f214, f215}, [rd14];
mul.f32 f218, f214, f210;
mul.f32 f219, f215, f211;
mul.f32 f220, f214, f211;
mul.f32 f221, f214, f214;
mul.f32 f222, f215, f215;
sub.f32 f223, f221, f222;
mul.f32 f224, f215, f214;
fma.rn.f32 f225, f215, f214, f224;
mul.f32 f226, f223, f208;
mul.f32 f227, f225, f209;
mul.f32 f228, f223, f209;
mul.f32 f229, f214, f223;
mul.f32 f230, f215, f225;
sub.f32 f231, f229, f230;
mul.f32 f232, f214, f225;
fma.rn.f32 f233, f215, f223, f232;
mul.f32 f234, f231, f212;
mul.f32 f235, f233, f213;
mul.f32 f236, f231, f213;
and.b32 r30, r10, 504;
add.s32 r31, r9, r30;
barrier.sync 0;
and.b32 r32, r7, 14336;
add.s32 r33, r31, r32;
add.f32 f237, f201, f205;
add.f32 f238, f200, f204;
st.shared.v2.f32 [r33], {f238, f237};
fma.rn.f32 f239, f215, f210, f220;
sub.f32 f240, f218, f219;
st.shared.v2.f32 [r33+512], {f240, f239};
fma.rn.f32 f241, f225, f208, f228;
sub.f32 f242, f226, f227;
st.shared.v2.f32 [r33+1024], {f242, f241};
sub.f32 f243, f234, f235;
fma.rn.f32 f244, f233, f212, f236;
st.shared.v2.f32 [r33+1536], {f243, f244};
barrier.sync 0;
mad.lo.s32 r34, r28, -24, r33;
ld.shared.v2.f32 {f245, f246}, [r34];
ld.shared.v2.f32 {f249, f250}, [r34+4096];
ld.shared.v2.f32 {f253, f254}, [r34+8192];
ld.shared.v2.f32 {f257, f258}, [r34+12288];
add.f32 f261, f245, f253;
add.f32 f262, f246, f254;
sub.f32 f263, f245, f253;
sub.f32 f264, f246, f254;
add.f32 f265, f249, f257;
add.f32 f266, f250, f258;
sub.f32 f267, f249, f257;
sub.f32 f268, f250, f258;
sub.f32 f269, f261, f265;
sub.f32 f270, f262, f266;
add.f32 f271, f263, f268;
sub.f32 f272, f264, f267;
sub.f32 f273, f263, f268;
add.f32 f274, f264, f267;
and.b32 r35, r5, 256;
bfe.u32 r36, r5, 8, 1;
mul.wide.u32 rd15, r36, 8;
mov.u64 rd16, %13;
add.s64 rd17, rd16, rd15;
ld.global.v2.f32 {f275, f276}, [rd17];
mul.f32 f279, f275, f271;
mul.f32 f280, f276, f272;
mul.f32 f281, f275, f272;
mul.f32 f282, f275, f275;
mul.f32 f283, f276, f276;
sub.f32 f284, f282, f283;
mul.f32 f285, f276, f275;
fma.rn.f32 f286, f276, f275, f285;
mul.f32 f287, f284, f269;
mul.f32 f288, f286, f270;
mul.f32 f289, f284, f270;
mul.f32 f290, f275, f284;
mul.f32 f291, f276, f286;
sub.f32 f292, f290, f291;
mul.f32 f293, f275, f286;
fma.rn.f32 f294, f276, f284, f293;
mul.f32 f295, f292, f273;
mul.f32 f296, f294, f274;
mul.f32 f297, f292, f274;
and.b32 r37, r10, 2040;
add.s32 r38, r9, r37;
barrier.sync 0;
and.b32 r39, r7, 8192;
add.s32 r40, r38, r39;
add.f32 f298, f262, f266;
add.f32 f299, f261, f265;
st.shared.v2.f32 [r40], {f299, f298};
fma.rn.f32 f300, f276, f271, f281;
sub.f32 f301, f279, f280;
st.shared.v2.f32 [r40+2048], {f301, f300};
fma.rn.f32 f302, f286, f269, f289;
sub.f32 f303, f287, f288;
st.shared.v2.f32 [r40+4096], {f303, f302};
sub.f32 f304, f295, f296;
fma.rn.f32 f305, f294, f273, f297;
st.shared.v2.f32 [r40+6144], {f304, f305};
barrier.sync 0;
mad.lo.s32 r41, r35, -24, r40;
ld.shared.v2.f32 {f306, f307}, [r41];
ld.shared.v2.f32 {f310, f311}, [r41+4096];
ld.shared.v2.f32 {f314, f315}, [r41+8192];
ld.shared.v2.f32 {f318, f319}, [r41+12288];
add.f32 %1, f307, f315;
add.f32 %0, f306, f314;
add.f32 %3, f311, f319;
add.f32 %2, f310, f318;
sub.f32 %5, f307, f315;
sub.f32 %4, f306, f314;
sub.f32 %7, f311, f319;
sub.f32 %6, f310, f318;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y), "=f"(rmem[2].x), "=f"(rmem[2].y), "=f"(rmem[3].x), "=f"(rmem[3].y): "r"(smem), "l"(lut_sp_4_2048), "l"(lut_sp_4_512), "l"(lut_sp_4_128), "l"(lut_sp_4_32), "l"(lut_sp_4_8), "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y), "f"(rmem[1].y), "f"(rmem[2].x), "f"(rmem[2].y), "f"(rmem[2].y), "f"(rmem[3].x), "f"(rmem[3].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<98, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<290>;
.reg .b32 r<43>;
.reg .b64 rd<18>;
mov.u32 r1, %tid.y;
shl.b32 r2, r1, 13;
mov.u32 r3, %8;
add.s32 r4, r3, r2;
mov.u32 r5, %tid.x;
add.f32 f17, %14, %19;
add.f32 f18, %15, %21;
sub.f32 f19, %14, %19;
sub.f32 f20, %15, %21;
add.f32 f21, %16, %22;
add.f32 f22, %18, %23;
sub.f32 f23, %16, %22;
sub.f32 f24, %18, %23;
add.f32 f25, f17, f21;
add.f32 f26, f18, f22;
sub.f32 f27, f17, f21;
sub.f32 f28, f18, f22;
add.f32 f29, f19, f24;
sub.f32 f30, f20, f23;
sub.f32 f31, f19, f24;
add.f32 f32, f20, f23;
and.b32 r6, r5, 511;
shl.b32 r7, r5, 3;
cvt.u64.u32 rd2, r7;
and.b64 rd3, rd2, 4088;
mov.u64 rd4, %9;
add.s64 rd5, rd4, rd3;
ld.global.v2.f32 {f33, f34}, [rd5];
mul.f32 f37, f33, f29;
mul.f32 f38, f34, f30;
sub.f32 f39, f37, f38;
mul.f32 f40, f33, f30;
fma.rn.f32 f41, f34, f29, f40;
mul.f32 f42, f33, f33;
mul.f32 f43, f34, f34;
sub.f32 f44, f42, f43;
mul.f32 f45, f34, f33;
fma.rn.f32 f46, f34, f33, f45;
mul.f32 f47, f44, f27;
mul.f32 f48, f46, f28;
sub.f32 f49, f47, f48;
mul.f32 f50, f44, f28;
fma.rn.f32 f51, f46, f27, f50;
mul.f32 f52, f33, f44;
mul.f32 f53, f34, f46;
sub.f32 f54, f52, f53;
mul.f32 f55, f33, f46;
fma.rn.f32 f56, f34, f44, f55;
mul.f32 f57, f54, f31;
mul.f32 f58, f56, f32;
sub.f32 f59, f57, f58;
mul.f32 f60, f54, f32;
fma.rn.f32 f61, f56, f31, f60;
shl.b32 r8, r5, 4;
and.b32 r9, r8, -8192;
add.s32 r10, r4, r9;
barrier.sync 0;
and.b32 r11, r8, 8176;
add.s32 r12, r10, r11;
st.shared.v4.f32 [r12], {f25, f39, f49, f59};
barrier.sync 0;
mad.lo.s32 r13, r6, -12, r12;
ld.shared.f32 f62, [r13];
ld.shared.f32 f63, [r13+2048];
ld.shared.f32 f64, [r13+4096];
ld.shared.f32 f65, [r13+6144];
barrier.sync 0;
st.shared.v4.f32 [r12], {f26, f41, f51, f61};
barrier.sync 0;
ld.shared.f32 f66, [r13];
ld.shared.f32 f67, [r13+2048];
ld.shared.f32 f68, [r13+4096];
ld.shared.f32 f69, [r13+6144];
add.f32 f70, f62, f64;
add.f32 f71, f66, f68;
sub.f32 f72, f62, f64;
sub.f32 f73, f66, f68;
add.f32 f74, f63, f65;
add.f32 f75, f67, f69;
sub.f32 f76, f63, f65;
sub.f32 f77, f67, f69;
add.f32 f78, f70, f74;
add.f32 f79, f71, f75;
sub.f32 f80, f70, f74;
sub.f32 f81, f71, f75;
add.f32 f82, f72, f77;
sub.f32 f83, f73, f76;
sub.f32 f84, f72, f77;
add.f32 f85, f73, f76;
and.b32 r14, r5, 508;
bfe.u32 r15, r5, 2, 7;
mul.wide.u32 rd6, r15, 8;
mov.u64 rd7, %10;
add.s64 rd8, rd7, rd6;
ld.global.v2.f32 {f86, f87}, [rd8];
mul.f32 f90, f86, f82;
mul.f32 f91, f87, f83;
sub.f32 f92, f90, f91;
mul.f32 f93, f86, f83;
fma.rn.f32 f94, f87, f82, f93;
mul.f32 f95, f86, f86;
mul.f32 f96, f87, f87;
sub.f32 f97, f95, f96;
mul.f32 f98, f87, f86;
fma.rn.f32 f99, f87, f86, f98;
mul.f32 f100, f97, f80;
mul.f32 f101, f99, f81;
sub.f32 f102, f100, f101;
mul.f32 f103, f97, f81;
fma.rn.f32 f104, f99, f80, f103;
mul.f32 f105, f86, f97;
mul.f32 f106, f87, f99;
sub.f32 f107, f105, f106;
mul.f32 f108, f86, f99;
fma.rn.f32 f109, f87, f97, f108;
mul.f32 f110, f107, f84;
mul.f32 f111, f109, f85;
sub.f32 f112, f110, f111;
mul.f32 f113, f107, f85;
fma.rn.f32 f114, f109, f84, f113;
shl.b32 r16, r5, 2;
and.b32 r17, r16, 12;
add.s32 r18, r10, r17;
barrier.sync 0;
and.b32 r19, r8, 8128;
add.s32 r20, r18, r19;
st.shared.f32 [r20], f78;
st.shared.f32 [r20+16], f92;
st.shared.f32 [r20+32], f102;
st.shared.f32 [r20+48], f112;
barrier.sync 0;
mad.lo.s32 r21, r14, -12, r20;
ld.shared.f32 f115, [r21];
ld.shared.f32 f116, [r21+2048];
ld.shared.f32 f117, [r21+4096];
ld.shared.f32 f118, [r21+6144];
barrier.sync 0;
st.shared.f32 [r20], f79;
st.shared.f32 [r20+16], f94;
st.shared.f32 [r20+32], f104;
st.shared.f32 [r20+48], f114;
barrier.sync 0;
ld.shared.f32 f119, [r21];
ld.shared.f32 f120, [r21+2048];
ld.shared.f32 f121, [r21+4096];
ld.shared.f32 f122, [r21+6144];
add.f32 f123, f115, f117;
add.f32 f124, f119, f121;
sub.f32 f125, f115, f117;
sub.f32 f126, f119, f121;
add.f32 f127, f116, f118;
add.f32 f128, f120, f122;
sub.f32 f129, f116, f118;
sub.f32 f130, f120, f122;
add.f32 f131, f123, f127;
add.f32 f132, f124, f128;
sub.f32 f133, f123, f127;
sub.f32 f134, f124, f128;
add.f32 f135, f125, f130;
sub.f32 f136, f126, f129;
sub.f32 f137, f125, f130;
add.f32 f138, f126, f129;
and.b32 r22, r5, 496;
bfe.u32 r23, r5, 4, 5;
mul.wide.u32 rd9, r23, 8;
mov.u64 rd10, %11;
add.s64 rd11, rd10, rd9;
ld.global.v2.f32 {f139, f140}, [rd11];
mul.f32 f143, f139, f135;
mul.f32 f144, f140, f136;
sub.f32 f145, f143, f144;
mul.f32 f146, f139, f136;
fma.rn.f32 f147, f140, f135, f146;
mul.f32 f148, f139, f139;
mul.f32 f149, f140, f140;
sub.f32 f150, f148, f149;
mul.f32 f151, f140, f139;
fma.rn.f32 f152, f140, f139, f151;
mul.f32 f153, f150, f133;
mul.f32 f154, f152, f134;
sub.f32 f155, f153, f154;
mul.f32 f156, f150, f134;
fma.rn.f32 f157, f152, f133, f156;
mul.f32 f158, f139, f150;
mul.f32 f159, f140, f152;
sub.f32 f160, f158, f159;
mul.f32 f161, f139, f152;
fma.rn.f32 f162, f140, f150, f161;
mul.f32 f163, f160, f137;
mul.f32 f164, f162, f138;
sub.f32 f165, f163, f164;
mul.f32 f166, f160, f138;
fma.rn.f32 f167, f162, f137, f166;
and.b32 r24, r16, 60;
add.s32 r25, r10, r24;
barrier.sync 0;
and.b32 r26, r8, 7936;
add.s32 r27, r25, r26;
st.shared.f32 [r27], f131;
st.shared.f32 [r27+64], f145;
st.shared.f32 [r27+128], f155;
st.shared.f32 [r27+192], f165;
barrier.sync 0;
mad.lo.s32 r28, r22, -12, r27;
ld.shared.f32 f168, [r28];
ld.shared.f32 f169, [r28+2048];
ld.shared.f32 f170, [r28+4096];
ld.shared.f32 f171, [r28+6144];
barrier.sync 0;
st.shared.f32 [r27], f132;
st.shared.f32 [r27+64], f147;
st.shared.f32 [r27+128], f157;
st.shared.f32 [r27+192], f167;
barrier.sync 0;
ld.shared.f32 f172, [r28];
ld.shared.f32 f173, [r28+2048];
ld.shared.f32 f174, [r28+4096];
ld.shared.f32 f175, [r28+6144];
add.f32 f176, f168, f170;
add.f32 f177, f172, f174;
sub.f32 f178, f168, f170;
sub.f32 f179, f172, f174;
add.f32 f180, f169, f171;
add.f32 f181, f173, f175;
sub.f32 f182, f169, f171;
sub.f32 f183, f173, f175;
add.f32 f184, f176, f180;
add.f32 f185, f177, f181;
sub.f32 f186, f176, f180;
sub.f32 f187, f177, f181;
add.f32 f188, f178, f183;
sub.f32 f189, f179, f182;
sub.f32 f190, f178, f183;
add.f32 f191, f179, f182;
and.b32 r29, r5, 448;
bfe.u32 r30, r5, 6, 3;
mul.wide.u32 rd12, r30, 8;
mov.u64 rd13, %12;
add.s64 rd14, rd13, rd12;
ld.global.v2.f32 {f192, f193}, [rd14];
mul.f32 f196, f192, f188;
mul.f32 f197, f193, f189;
sub.f32 f198, f196, f197;
mul.f32 f199, f192, f189;
fma.rn.f32 f200, f193, f188, f199;
mul.f32 f201, f192, f192;
mul.f32 f202, f193, f193;
sub.f32 f203, f201, f202;
mul.f32 f204, f193, f192;
fma.rn.f32 f205, f193, f192, f204;
mul.f32 f206, f203, f186;
mul.f32 f207, f205, f187;
sub.f32 f208, f206, f207;
mul.f32 f209, f203, f187;
fma.rn.f32 f210, f205, f186, f209;
mul.f32 f211, f192, f203;
mul.f32 f212, f193, f205;
sub.f32 f213, f211, f212;
mul.f32 f214, f192, f205;
fma.rn.f32 f215, f193, f203, f214;
mul.f32 f216, f213, f190;
mul.f32 f217, f215, f191;
sub.f32 f218, f216, f217;
mul.f32 f219, f213, f191;
fma.rn.f32 f220, f215, f190, f219;
and.b32 r31, r16, 252;
add.s32 r32, r10, r31;
barrier.sync 0;
and.b32 r33, r8, 7168;
add.s32 r34, r32, r33;
st.shared.f32 [r34], f184;
st.shared.f32 [r34+256], f198;
st.shared.f32 [r34+512], f208;
st.shared.f32 [r34+768], f218;
barrier.sync 0;
mad.lo.s32 r35, r29, -12, r34;
ld.shared.f32 f221, [r35];
ld.shared.f32 f222, [r35+2048];
ld.shared.f32 f223, [r35+4096];
ld.shared.f32 f224, [r35+6144];
barrier.sync 0;
st.shared.f32 [r34], f185;
st.shared.f32 [r34+256], f200;
st.shared.f32 [r34+512], f210;
st.shared.f32 [r34+768], f220;
barrier.sync 0;
ld.shared.f32 f225, [r35];
ld.shared.f32 f226, [r35+2048];
ld.shared.f32 f227, [r35+4096];
ld.shared.f32 f228, [r35+6144];
add.f32 f229, f221, f223;
add.f32 f230, f225, f227;
sub.f32 f231, f221, f223;
sub.f32 f232, f225, f227;
add.f32 f233, f222, f224;
add.f32 f234, f226, f228;
sub.f32 f235, f222, f224;
sub.f32 f236, f226, f228;
add.f32 f237, f229, f233;
add.f32 f238, f230, f234;
sub.f32 f239, f229, f233;
sub.f32 f240, f230, f234;
add.f32 f241, f231, f236;
sub.f32 f242, f232, f235;
sub.f32 f243, f231, f236;
add.f32 f244, f232, f235;
and.b32 r36, r5, 256;
bfe.u32 r37, r5, 8, 1;
mul.wide.u32 rd15, r37, 8;
mov.u64 rd16, %13;
add.s64 rd17, rd16, rd15;
ld.global.v2.f32 {f245, f246}, [rd17];
mul.f32 f249, f245, f241;
mul.f32 f250, f246, f242;
sub.f32 f251, f249, f250;
mul.f32 f252, f245, f242;
fma.rn.f32 f253, f246, f241, f252;
mul.f32 f254, f245, f245;
mul.f32 f255, f246, f246;
sub.f32 f256, f254, f255;
mul.f32 f257, f246, f245;
fma.rn.f32 f258, f246, f245, f257;
mul.f32 f259, f256, f239;
mul.f32 f260, f258, f240;
sub.f32 f261, f259, f260;
mul.f32 f262, f256, f240;
fma.rn.f32 f263, f258, f239, f262;
mul.f32 f264, f245, f256;
mul.f32 f265, f246, f258;
sub.f32 f266, f264, f265;
mul.f32 f267, f245, f258;
fma.rn.f32 f268, f246, f256, f267;
mul.f32 f269, f266, f243;
mul.f32 f270, f268, f244;
sub.f32 f271, f269, f270;
mul.f32 f272, f266, f244;
fma.rn.f32 f273, f268, f243, f272;
and.b32 r38, r16, 1020;
add.s32 r39, r10, r38;
barrier.sync 0;
and.b32 r40, r8, 4096;
add.s32 r41, r39, r40;
st.shared.f32 [r41], f237;
st.shared.f32 [r41+1024], f251;
st.shared.f32 [r41+2048], f261;
st.shared.f32 [r41+3072], f271;
barrier.sync 0;
mad.lo.s32 r42, r36, -12, r41;
ld.shared.f32 f274, [r42];
ld.shared.f32 f275, [r42+2048];
ld.shared.f32 f276, [r42+4096];
ld.shared.f32 f277, [r42+6144];
barrier.sync 0;
st.shared.f32 [r41], f238;
st.shared.f32 [r41+1024], f253;
st.shared.f32 [r41+2048], f263;
st.shared.f32 [r41+3072], f273;
barrier.sync 0;
ld.shared.f32 f278, [r42];
ld.shared.f32 f279, [r42+2048];
ld.shared.f32 f280, [r42+4096];
ld.shared.f32 f281, [r42+6144];
add.f32 %0, f274, f276;
add.f32 %1, f278, f280;
add.f32 %2, f275, f277;
add.f32 %3, f279, f281;
sub.f32 %4, f274, f276;
sub.f32 %5, f278, f280;
sub.f32 %6, f275, f277;
sub.f32 %7, f279, f281;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y), "=f"(rmem[2].x), "=f"(rmem[2].y), "=f"(rmem[3].x), "=f"(rmem[3].y): "r"(smem), "l"(lut_sp_4_2048), "l"(lut_sp_4_512), "l"(lut_sp_4_128), "l"(lut_sp_4_32), "l"(lut_sp_4_8), "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y), "f"(rmem[1].y), "f"(rmem[2].x), "f"(rmem[2].y), "f"(rmem[2].y), "f"(rmem[3].x), "f"(rmem[3].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<99, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<223>;
.reg .b32 r<77>;
.reg .b64 rd<33>;
mov.u32 r1, %tid.y;
shl.b32 r2, r1, 14;
mov.u32 r3, %4;
add.s32 r4, r3, r2;
mov.u32 r5, %tid.x;
sub.f32 f9, %15, %17;
sub.f32 f10, %16, %18;
shl.b32 r6, r5, 4;
and.b32 r7, r6, -16384;
add.s32 r8, r4, r7;
shl.b32 r9, r5, 3;
cvt.u64.u32 rd2, r9;
and.b64 rd3, rd2, 8184;
mov.u64 rd4, %5;
add.s64 rd5, rd4, rd3;
ld.global.v2.f32 {f11, f12}, [rd5];
mul.f32 f15, f11, f9;
mul.f32 f16, f12, f10;
mul.f32 f17, f11, f10;
barrier.sync 0;
and.b32 r10, r6, 16368;
add.s32 r11, r8, r10;
add.f32 f18, %16, %18;
add.f32 f19, %15, %17;
st.shared.v2.f32 [r11], {f19, f18};
sub.f32 f20, f15, f16;
fma.rn.f32 f21, f12, f9, f17;
st.shared.v2.f32 [r11+8], {f20, f21};
barrier.sync 0;
and.b32 r12, r9, 8184;
sub.s32 r13, r11, r12;
ld.shared.v2.f32 {f22, f23}, [r13];
ld.shared.v2.f32 {f26, f27}, [r13+8192];
sub.f32 f30, f22, f26;
sub.f32 f31, f23, f27;
bfe.u32 r14, r5, 1, 9;
mul.wide.u32 rd6, r14, 8;
mov.u64 rd7, %6;
add.s64 rd8, rd7, rd6;
ld.global.v2.f32 {f32, f33}, [rd8];
mul.f32 f36, f32, f30;
mul.f32 f37, f33, f31;
mul.f32 f38, f32, f31;
and.b32 r15, r9, 8;
add.s32 r16, r8, r15;
barrier.sync 0;
and.b32 r17, r6, 16352;
add.s32 r18, r16, r17;
add.f32 f39, f23, f27;
add.f32 f40, f22, f26;
st.shared.v2.f32 [r18], {f40, f39};
fma.rn.f32 f41, f33, f30, f38;
sub.f32 f42, f36, f37;
st.shared.v2.f32 [r18+16], {f42, f41};
barrier.sync 0;
and.b32 r19, r9, 8176;
sub.s32 r20, r18, r19;
ld.shared.v2.f32 {f43, f44}, [r20];
ld.shared.v2.f32 {f47, f48}, [r20+8192];
sub.f32 f51, f43, f47;
sub.f32 f52, f44, f48;
bfe.u32 r21, r5, 2, 8;
mul.wide.u32 rd9, r21, 8;
mov.u64 rd10, %7;
add.s64 rd11, rd10, rd9;
ld.global.v2.f32 {f53, f54}, [rd11];
mul.f32 f57, f53, f51;
mul.f32 f58, f54, f52;
mul.f32 f59, f53, f52;
and.b32 r22, r9, 24;
add.s32 r23, r8, r22;
barrier.sync 0;
and.b32 r24, r6, 16320;
add.s32 r25, r23, r24;
add.f32 f60, f44, f48;
add.f32 f61, f43, f47;
st.shared.v2.f32 [r25], {f61, f60};
fma.rn.f32 f62, f54, f51, f59;
sub.f32 f63, f57, f58;
st.shared.v2.f32 [r25+32], {f63, f62};
barrier.sync 0;
and.b32 r26, r9, 8160;
sub.s32 r27, r25, r26;
ld.shared.v2.f32 {f64, f65}, [r27];
ld.shared.v2.f32 {f68, f69}, [r27+8192];
sub.f32 f72, f64, f68;
sub.f32 f73, f65, f69;
and.b32 r28, r5, 1016;
cvt.u64.u32 rd12, r28;
mov.u64 rd13, %8;
add.s64 rd14, rd13, rd12;
ld.global.v2.f32 {f74, f75}, [rd14];
mul.f32 f78, f74, f72;
mul.f32 f79, f75, f73;
mul.f32 f80, f74, f73;
and.b32 r29, r9, 56;
add.s32 r30, r8, r29;
barrier.sync 0;
and.b32 r31, r6, 16256;
add.s32 r32, r30, r31;
add.f32 f81, f65, f69;
add.f32 f82, f64, f68;
st.shared.v2.f32 [r32], {f82, f81};
fma.rn.f32 f83, f75, f72, f80;
sub.f32 f84, f78, f79;
st.shared.v2.f32 [r32+64], {f84, f83};
barrier.sync 0;
and.b32 r33, r9, 8128;
sub.s32 r34, r32, r33;
ld.shared.v2.f32 {f85, f86}, [r34];
ld.shared.v2.f32 {f89, f90}, [r34+8192];
sub.f32 f93, f85, f89;
sub.f32 f94, f86, f90;
bfe.u32 r35, r5, 4, 6;
mul.wide.u32 rd15, r35, 8;
mov.u64 rd16, %9;
add.s64 rd17, rd16, rd15;
ld.global.v2.f32 {f95, f96}, [rd17];
mul.f32 f99, f95, f93;
mul.f32 f100, f96, f94;
mul.f32 f101, f95, f94;
and.b32 r36, r9, 120;
add.s32 r37, r8, r36;
barrier.sync 0;
and.b32 r38, r6, 16128;
add.s32 r39, r37, r38;
add.f32 f102, f86, f90;
add.f32 f103, f85, f89;
st.shared.v2.f32 [r39], {f103, f102};
fma.rn.f32 f104, f96, f93, f101;
sub.f32 f105, f99, f100;
st.shared.v2.f32 [r39+128], {f105, f104};
barrier.sync 0;
and.b32 r40, r9, 8064;
sub.s32 r41, r39, r40;
ld.shared.v2.f32 {f106, f107}, [r41];
ld.shared.v2.f32 {f110, f111}, [r41+8192];
sub.f32 f114, f106, f110;
sub.f32 f115, f107, f111;
bfe.u32 r42, r5, 5, 5;
mul.wide.u32 rd18, r42, 8;
mov.u64 rd19, %10;
add.s64 rd20, rd19, rd18;
ld.global.v2.f32 {f116, f117}, [rd20];
mul.f32 f120, f116, f114;
mul.f32 f121, f117, f115;
mul.f32 f122, f116, f115;
and.b32 r43, r9, 248;
add.s32 r44, r8, r43;
barrier.sync 0;
and.b32 r45, r6, 15872;
add.s32 r46, r44, r45;
add.f32 f123, f107, f111;
add.f32 f124, f106, f110;
st.shared.v2.f32 [r46], {f124, f123};
fma.rn.f32 f125, f117, f114, f122;
sub.f32 f126, f120, f121;
st.shared.v2.f32 [r46+256], {f126, f125};
barrier.sync 0;
and.b32 r47, r9, 7936;
sub.s32 r48, r46, r47;
ld.shared.v2.f32 {f127, f128}, [r48];
ld.shared.v2.f32 {f131, f132}, [r48+8192];
sub.f32 f135, f127, f131;
sub.f32 f136, f128, f132;
bfe.u32 r49, r5, 6, 4;
mul.wide.u32 rd21, r49, 8;
mov.u64 rd22, %11;
add.s64 rd23, rd22, rd21;
ld.global.v2.f32 {f137, f138}, [rd23];
mul.f32 f141, f137, f135;
mul.f32 f142, f138, f136;
mul.f32 f143, f137, f136;
and.b32 r50, r9, 504;
add.s32 r51, r8, r50;
barrier.sync 0;
and.b32 r52, r6, 15360;
add.s32 r53, r51, r52;
add.f32 f144, f128, f132;
add.f32 f145, f127, f131;
st.shared.v2.f32 [r53], {f145, f144};
fma.rn.f32 f146, f138, f135, f143;
sub.f32 f147, f141, f142;
st.shared.v2.f32 [r53+512], {f147, f146};
barrier.sync 0;
and.b32 r54, r9, 7680;
sub.s32 r55, r53, r54;
ld.shared.v2.f32 {f148, f149}, [r55];
ld.shared.v2.f32 {f152, f153}, [r55+8192];
sub.f32 f156, f148, f152;
sub.f32 f157, f149, f153;
bfe.u32 r56, r5, 7, 3;
mul.wide.u32 rd24, r56, 8;
mov.u64 rd25, %12;
add.s64 rd26, rd25, rd24;
ld.global.v2.f32 {f158, f159}, [rd26];
mul.f32 f162, f158, f156;
mul.f32 f163, f159, f157;
mul.f32 f164, f158, f157;
and.b32 r57, r9, 1016;
add.s32 r58, r8, r57;
barrier.sync 0;
and.b32 r59, r6, 14336;
add.s32 r60, r58, r59;
add.f32 f165, f149, f153;
add.f32 f166, f148, f152;
st.shared.v2.f32 [r60], {f166, f165};
fma.rn.f32 f167, f159, f156, f164;
sub.f32 f168, f162, f163;
st.shared.v2.f32 [r60+1024], {f168, f167};
barrier.sync 0;
and.b32 r61, r9, 7168;
sub.s32 r62, r60, r61;
ld.shared.v2.f32 {f169, f170}, [r62];
ld.shared.v2.f32 {f173, f174}, [r62+8192];
sub.f32 f177, f169, f173;
sub.f32 f178, f170, f174;
bfe.u32 r63, r5, 8, 2;
mul.wide.u32 rd27, r63, 8;
mov.u64 rd28, %13;
add.s64 rd29, rd28, rd27;
ld.global.v2.f32 {f179, f180}, [rd29];
mul.f32 f183, f179, f177;
mul.f32 f184, f180, f178;
mul.f32 f185, f179, f178;
and.b32 r64, r9, 2040;
add.s32 r65, r8, r64;
barrier.sync 0;
and.b32 r66, r6, 12288;
add.s32 r67, r65, r66;
add.f32 f186, f170, f174;
add.f32 f187, f169, f173;
st.shared.v2.f32 [r67], {f187, f186};
fma.rn.f32 f188, f180, f177, f185;
sub.f32 f189, f183, f184;
st.shared.v2.f32 [r67+2048], {f189, f188};
barrier.sync 0;
and.b32 r68, r9, 6144;
sub.s32 r69, r67, r68;
ld.shared.v2.f32 {f190, f191}, [r69];
ld.shared.v2.f32 {f194, f195}, [r69+8192];
sub.f32 f198, f190, f194;
sub.f32 f199, f191, f195;
bfe.u32 r70, r5, 9, 1;
mul.wide.u32 rd30, r70, 8;
mov.u64 rd31, %14;
add.s64 rd32, rd31, rd30;
ld.global.v2.f32 {f200, f201}, [rd32];
mul.f32 f204, f200, f198;
mul.f32 f205, f201, f199;
mul.f32 f206, f200, f199;
and.b32 r71, r9, 4088;
add.s32 r72, r8, r71;
barrier.sync 0;
and.b32 r73, r6, 8192;
add.s32 r74, r72, r73;
add.f32 f207, f191, f195;
add.f32 f208, f190, f194;
st.shared.v2.f32 [r74], {f208, f207};
fma.rn.f32 f209, f201, f198, f206;
sub.f32 f210, f204, f205;
st.shared.v2.f32 [r74+4096], {f210, f209};
barrier.sync 0;
and.b32 r75, r9, 4096;
sub.s32 r76, r74, r75;
ld.shared.v2.f32 {f211, f212}, [r76];
ld.shared.v2.f32 {f215, f216}, [r76+8192];
add.f32 %1, f212, f216;
add.f32 %0, f211, f215;
sub.f32 %3, f212, f216;
sub.f32 %2, f211, f215;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y): "r"(smem), "l"(lut_sp_2_2048), "l"(lut_sp_2_1024), "l"(lut_sp_2_512), "l"(lut_sp_2_256), "l"(lut_sp_2_128), "l"(lut_sp_2_64), "l"(lut_sp_2_32), "l"(lut_sp_2_16), "l"(lut_sp_2_8), "l"(lut_sp_2_4), "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<100, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<183>;
.reg .b32 r<77>;
.reg .b64 rd<33>;
mov.u32 r1, %tid.y;
shl.b32 r2, r1, 13;
mov.u32 r3, %4;
add.s32 r4, r3, r2;
mov.u32 r5, %tid.x;
add.f32 f9, %15, %17;
add.f32 f10, %16, %18;
sub.f32 f11, %15, %17;
sub.f32 f12, %16, %18;
shl.b32 r6, r5, 3;
cvt.u64.u32 rd2, r6;
and.b64 rd3, rd2, 8184;
mov.u64 rd4, %5;
add.s64 rd5, rd4, rd3;
ld.global.v2.f32 {f13, f14}, [rd5];
mul.f32 f17, f13, f11;
mul.f32 f18, f14, f12;
sub.f32 f19, f17, f18;
mul.f32 f20, f13, f12;
fma.rn.f32 f21, f14, f11, f20;
and.b32 r7, r6, -8192;
add.s32 r8, r4, r7;
barrier.sync 0;
and.b32 r9, r6, 8184;
add.s32 r10, r8, r9;
st.shared.v2.f32 [r10], {f9, f19};
barrier.sync 0;
shl.b32 r11, r5, 2;
and.b32 r12, r11, 4092;
sub.s32 r13, r10, r12;
ld.shared.f32 f22, [r13];
ld.shared.f32 f23, [r13+4096];
barrier.sync 0;
st.shared.v2.f32 [r10], {f10, f21};
barrier.sync 0;
ld.shared.f32 f24, [r13];
ld.shared.f32 f25, [r13+4096];
add.f32 f26, f22, f23;
add.f32 f27, f24, f25;
sub.f32 f28, f22, f23;
sub.f32 f29, f24, f25;
bfe.u32 r14, r5, 1, 9;
mul.wide.u32 rd6, r14, 8;
mov.u64 rd7, %6;
add.s64 rd8, rd7, rd6;
ld.global.v2.f32 {f30, f31}, [rd8];
mul.f32 f34, f30, f28;
mul.f32 f35, f31, f29;
sub.f32 f36, f34, f35;
mul.f32 f37, f30, f29;
fma.rn.f32 f38, f31, f28, f37;
and.b32 r15, r11, 4;
add.s32 r16, r8, r15;
barrier.sync 0;
and.b32 r17, r6, 8176;
add.s32 r18, r16, r17;
st.shared.f32 [r18], f26;
st.shared.f32 [r18+8], f36;
barrier.sync 0;
and.b32 r19, r11, 4088;
sub.s32 r20, r18, r19;
ld.shared.f32 f39, [r20];
ld.shared.f32 f40, [r20+4096];
barrier.sync 0;
st.shared.f32 [r18], f27;
st.shared.f32 [r18+8], f38;
barrier.sync 0;
ld.shared.f32 f41, [r20];
ld.shared.f32 f42, [r20+4096];
add.f32 f43, f39, f40;
add.f32 f44, f41, f42;
sub.f32 f45, f39, f40;
sub.f32 f46, f41, f42;
bfe.u32 r21, r5, 2, 8;
mul.wide.u32 rd9, r21, 8;
mov.u64 rd10, %7;
add.s64 rd11, rd10, rd9;
ld.global.v2.f32 {f47, f48}, [rd11];
mul.f32 f51, f47, f45;
mul.f32 f52, f48, f46;
sub.f32 f53, f51, f52;
mul.f32 f54, f47, f46;
fma.rn.f32 f55, f48, f45, f54;
and.b32 r22, r11, 12;
add.s32 r23, r8, r22;
barrier.sync 0;
and.b32 r24, r6, 8160;
add.s32 r25, r23, r24;
st.shared.f32 [r25], f43;
st.shared.f32 [r25+16], f53;
barrier.sync 0;
and.b32 r26, r11, 4080;
sub.s32 r27, r25, r26;
ld.shared.f32 f56, [r27];
ld.shared.f32 f57, [r27+4096];
barrier.sync 0;
st.shared.f32 [r25], f44;
st.shared.f32 [r25+16], f55;
barrier.sync 0;
ld.shared.f32 f58, [r27];
ld.shared.f32 f59, [r27+4096];
add.f32 f60, f56, f57;
add.f32 f61, f58, f59;
sub.f32 f62, f56, f57;
sub.f32 f63, f58, f59;
and.b32 r28, r5, 1016;
cvt.u64.u32 rd12, r28;
mov.u64 rd13, %8;
add.s64 rd14, rd13, rd12;
ld.global.v2.f32 {f64, f65}, [rd14];
mul.f32 f68, f64, f62;
mul.f32 f69, f65, f63;
sub.f32 f70, f68, f69;
mul.f32 f71, f64, f63;
fma.rn.f32 f72, f65, f62, f71;
and.b32 r29, r11, 28;
add.s32 r30, r8, r29;
barrier.sync 0;
and.b32 r31, r6, 8128;
add.s32 r32, r30, r31;
st.shared.f32 [r32], f60;
st.shared.f32 [r32+32], f70;
barrier.sync 0;
and.b32 r33, r11, 4064;
sub.s32 r34, r32, r33;
ld.shared.f32 f73, [r34];
ld.shared.f32 f74, [r34+4096];
barrier.sync 0;
st.shared.f32 [r32], f61;
st.shared.f32 [r32+32], f72;
barrier.sync 0;
ld.shared.f32 f75, [r34];
ld.shared.f32 f76, [r34+4096];
add.f32 f77, f73, f74;
add.f32 f78, f75, f76;
sub.f32 f79, f73, f74;
sub.f32 f80, f75, f76;
bfe.u32 r35, r5, 4, 6;
mul.wide.u32 rd15, r35, 8;
mov.u64 rd16, %9;
add.s64 rd17, rd16, rd15;
ld.global.v2.f32 {f81, f82}, [rd17];
mul.f32 f85, f81, f79;
mul.f32 f86, f82, f80;
sub.f32 f87, f85, f86;
mul.f32 f88, f81, f80;
fma.rn.f32 f89, f82, f79, f88;
and.b32 r36, r11, 60;
add.s32 r37, r8, r36;
barrier.sync 0;
and.b32 r38, r6, 8064;
add.s32 r39, r37, r38;
st.shared.f32 [r39], f77;
st.shared.f32 [r39+64], f87;
barrier.sync 0;
and.b32 r40, r11, 4032;
sub.s32 r41, r39, r40;
ld.shared.f32 f90, [r41];
ld.shared.f32 f91, [r41+4096];
barrier.sync 0;
st.shared.f32 [r39], f78;
st.shared.f32 [r39+64], f89;
barrier.sync 0;
ld.shared.f32 f92, [r41];
ld.shared.f32 f93, [r41+4096];
add.f32 f94, f90, f91;
add.f32 f95, f92, f93;
sub.f32 f96, f90, f91;
sub.f32 f97, f92, f93;
bfe.u32 r42, r5, 5, 5;
mul.wide.u32 rd18, r42, 8;
mov.u64 rd19, %10;
add.s64 rd20, rd19, rd18;
ld.global.v2.f32 {f98, f99}, [rd20];
mul.f32 f102, f98, f96;
mul.f32 f103, f99, f97;
sub.f32 f104, f102, f103;
mul.f32 f105, f98, f97;
fma.rn.f32 f106, f99, f96, f105;
and.b32 r43, r11, 124;
add.s32 r44, r8, r43;
barrier.sync 0;
and.b32 r45, r6, 7936;
add.s32 r46, r44, r45;
st.shared.f32 [r46], f94;
st.shared.f32 [r46+128], f104;
barrier.sync 0;
and.b32 r47, r11, 3968;
sub.s32 r48, r46, r47;
ld.shared.f32 f107, [r48];
ld.shared.f32 f108, [r48+4096];
barrier.sync 0;
st.shared.f32 [r46], f95;
st.shared.f32 [r46+128], f106;
barrier.sync 0;
ld.shared.f32 f109, [r48];
ld.shared.f32 f110, [r48+4096];
add.f32 f111, f107, f108;
add.f32 f112, f109, f110;
sub.f32 f113, f107, f108;
sub.f32 f114, f109, f110;
bfe.u32 r49, r5, 6, 4;
mul.wide.u32 rd21, r49, 8;
mov.u64 rd22, %11;
add.s64 rd23, rd22, rd21;
ld.global.v2.f32 {f115, f116}, [rd23];
mul.f32 f119, f115, f113;
mul.f32 f120, f116, f114;
sub.f32 f121, f119, f120;
mul.f32 f122, f115, f114;
fma.rn.f32 f123, f116, f113, f122;
and.b32 r50, r11, 252;
add.s32 r51, r8, r50;
barrier.sync 0;
and.b32 r52, r6, 7680;
add.s32 r53, r51, r52;
st.shared.f32 [r53], f111;
st.shared.f32 [r53+256], f121;
barrier.sync 0;
and.b32 r54, r11, 3840;
sub.s32 r55, r53, r54;
ld.shared.f32 f124, [r55];
ld.shared.f32 f125, [r55+4096];
barrier.sync 0;
st.shared.f32 [r53], f112;
st.shared.f32 [r53+256], f123;
barrier.sync 0;
ld.shared.f32 f126, [r55];
ld.shared.f32 f127, [r55+4096];
add.f32 f128, f124, f125;
add.f32 f129, f126, f127;
sub.f32 f130, f124, f125;
sub.f32 f131, f126, f127;
bfe.u32 r56, r5, 7, 3;
mul.wide.u32 rd24, r56, 8;
mov.u64 rd25, %12;
add.s64 rd26, rd25, rd24;
ld.global.v2.f32 {f132, f133}, [rd26];
mul.f32 f136, f132, f130;
mul.f32 f137, f133, f131;
sub.f32 f138, f136, f137;
mul.f32 f139, f132, f131;
fma.rn.f32 f140, f133, f130, f139;
and.b32 r57, r11, 508;
add.s32 r58, r8, r57;
barrier.sync 0;
and.b32 r59, r6, 7168;
add.s32 r60, r58, r59;
st.shared.f32 [r60], f128;
st.shared.f32 [r60+512], f138;
barrier.sync 0;
and.b32 r61, r11, 3584;
sub.s32 r62, r60, r61;
ld.shared.f32 f141, [r62];
ld.shared.f32 f142, [r62+4096];
barrier.sync 0;
st.shared.f32 [r60], f129;
st.shared.f32 [r60+512], f140;
barrier.sync 0;
ld.shared.f32 f143, [r62];
ld.shared.f32 f144, [r62+4096];
add.f32 f145, f141, f142;
add.f32 f146, f143, f144;
sub.f32 f147, f141, f142;
sub.f32 f148, f143, f144;
bfe.u32 r63, r5, 8, 2;
mul.wide.u32 rd27, r63, 8;
mov.u64 rd28, %13;
add.s64 rd29, rd28, rd27;
ld.global.v2.f32 {f149, f150}, [rd29];
mul.f32 f153, f149, f147;
mul.f32 f154, f150, f148;
sub.f32 f155, f153, f154;
mul.f32 f156, f149, f148;
fma.rn.f32 f157, f150, f147, f156;
and.b32 r64, r11, 1020;
add.s32 r65, r8, r64;
barrier.sync 0;
and.b32 r66, r6, 6144;
add.s32 r67, r65, r66;
st.shared.f32 [r67], f145;
st.shared.f32 [r67+1024], f155;
barrier.sync 0;
and.b32 r68, r11, 3072;
sub.s32 r69, r67, r68;
ld.shared.f32 f158, [r69];
ld.shared.f32 f159, [r69+4096];
barrier.sync 0;
st.shared.f32 [r67], f146;
st.shared.f32 [r67+1024], f157;
barrier.sync 0;
ld.shared.f32 f160, [r69];
ld.shared.f32 f161, [r69+4096];
add.f32 f162, f158, f159;
add.f32 f163, f160, f161;
sub.f32 f164, f158, f159;
sub.f32 f165, f160, f161;
bfe.u32 r70, r5, 9, 1;
mul.wide.u32 rd30, r70, 8;
mov.u64 rd31, %14;
add.s64 rd32, rd31, rd30;
ld.global.v2.f32 {f166, f167}, [rd32];
mul.f32 f170, f166, f164;
mul.f32 f171, f167, f165;
sub.f32 f172, f170, f171;
mul.f32 f173, f166, f165;
fma.rn.f32 f174, f167, f164, f173;
and.b32 r71, r11, 2044;
add.s32 r72, r8, r71;
barrier.sync 0;
and.b32 r73, r6, 4096;
add.s32 r74, r72, r73;
st.shared.f32 [r74], f162;
st.shared.f32 [r74+2048], f172;
barrier.sync 0;
and.b32 r75, r11, 2048;
sub.s32 r76, r74, r75;
ld.shared.f32 f175, [r76];
ld.shared.f32 f176, [r76+4096];
barrier.sync 0;
st.shared.f32 [r74], f163;
st.shared.f32 [r74+2048], f174;
barrier.sync 0;
ld.shared.f32 f177, [r76];
ld.shared.f32 f178, [r76+4096];
add.f32 %0, f175, f176;
add.f32 %1, f177, f178;
sub.f32 %2, f175, f176;
sub.f32 %3, f177, f178;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y): "r"(smem), "l"(lut_sp_2_2048), "l"(lut_sp_2_1024), "l"(lut_sp_2_512), "l"(lut_sp_2_256), "l"(lut_sp_2_128), "l"(lut_sp_2_64), "l"(lut_sp_2_32), "l"(lut_sp_2_16), "l"(lut_sp_2_8), "l"(lut_sp_2_4), "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y));
};


#endif
